/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.ldap;

import java.io.File;
import org.ballerinalang.stdlib.ldap.util.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SslTrustConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SslTrustConfig.class);
    private File trustStore;
    private String trustStorePass;
    private String sslProtocol = "TLS";
    private String tlsStoreType = "PKCS12";
    private File clientTrustCertificates;

    SslTrustConfig() {
    }

    public File getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStoreFile(File trustStore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using trust store {}", (Object)trustStore);
        }
        this.trustStore = trustStore;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public void setSSLProtocol(String sslProtocol) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set SSLProtocol {}", (Object)sslProtocol);
        }
        this.sslProtocol = sslProtocol;
    }

    public String getSSLProtocol() {
        return this.sslProtocol;
    }

    public String getTLSStoreType() {
        return this.tlsStoreType;
    }

    public void setTLSStoreType(String tlsStoreType) {
        this.tlsStoreType = tlsStoreType;
    }

    public File getClientTrustCertificates() {
        return this.clientTrustCertificates;
    }

    public void setClientTrustCertificates(File clientTrustCertificates) {
        this.clientTrustCertificates = clientTrustCertificates;
    }

    public void setClientTrustCertificates(String clientTrustCertificates) {
        this.setClientTrustCertificates(new File(LdapUtils.substituteVariables(clientTrustCertificates)));
    }
}

