/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.math.nativeimpl;

import java.util.concurrent.ThreadLocalRandom;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.stdlib.math.nativeimpl.Constant;

public class ExternMethods {
    private ExternMethods() {
    }

    public static Object floorDiv(long a, long b) {
        try {
            return Math.floorDiv(a, b);
        }
        catch (ArithmeticException ex) {
            return ExternMethods.createMathError("Division by zero occurred");
        }
    }

    public static Object floorMod(long a, long b) {
        try {
            return Math.floorMod(a, b);
        }
        catch (ArithmeticException ex) {
            return ExternMethods.createMathError("Division by zero occurred");
        }
    }

    public static Object negateExact(long value) {
        try {
            return Math.negateExact(value);
        }
        catch (ArithmeticException ex) {
            return ExternMethods.createMathError("Overflow occurred");
        }
    }

    public static Object randomInRange(long start, long end) {
        try {
            return ThreadLocalRandom.current().nextLong(start, end);
        }
        catch (IllegalArgumentException ex) {
            return ExternMethods.createMathError("End range must be greater than the start range");
        }
    }

    public static double scalb(double a, long b) {
        int intVal = Long.valueOf(b).intValue();
        return Math.scalb(a, intVal);
    }

    private static ErrorValue createMathError(String errMsg) {
        return BallerinaErrors.createDistinctError((String)"ArithmeticError", (BPackage)Constant.MATH_PACKAGE_ID, (String)errMsg);
    }
}

