/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq;

import java.util.concurrent.CountDownLatch;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQMetricsUtil;

public class RabbitMQErrorResourceCallback
implements CallableUnitCallback {
    private CountDownLatch countDownLatch;

    RabbitMQErrorResourceCallback(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public void notifySuccess() {
        this.countDownLatch.countDown();
    }

    public void notifyFailure(ErrorValue error) {
        this.countDownLatch.countDown();
        RabbitMQMetricsUtil.reportError("error_dispatch");
        ErrorHandlerUtils.printError((String)("RabbitMQ Error: " + error.getPrintableStackTrace()));
    }
}

