/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq;

import java.util.List;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.messaging.rabbitmq.RabbitMQResourceValidator;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(packageName="rabbitmq", name="Listener"), paramTypes={@SupportedResourceParamTypes.Type(packageName="rabbitmq", name="Message")})
public class RabbitMQServiceCompilerPlugin
extends AbstractCompilerPlugin {
    private DiagnosticLog dlog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        int count = 0;
        for (AnnotationAttachmentNode annotation : annotations) {
            if (!annotation.getAnnotationName().getValue().equals("ServiceConfig")) continue;
            ++count;
        }
        if (count > 1) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"There cannot be more than one rabbitmq:ServiceConfig annotations");
        } else if (count == 0) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"There has to be a rabbitmq:ServiceConfig annotation declared for service");
        }
        List resources = serviceNode.getResources();
        if (resources.size() > 2) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"Only maximum of two resources are allowed in the service");
        }
        resources.forEach(res -> RabbitMQResourceValidator.validate(res, this.dlog));
    }
}

