/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq.observability;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.ArrayList;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.metrics.DefaultMetricRegistry;
import org.ballerinalang.jvm.observability.metrics.MetricId;
import org.ballerinalang.jvm.observability.metrics.MetricRegistry;
import org.ballerinalang.jvm.observability.metrics.StatisticConfig;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQObservabilityConstants;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQObservabilityUtil;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQObserverContext;

public class RabbitMQMetricsUtil {
    private static final MetricRegistry metricRegistry = DefaultMetricRegistry.getInstance();

    public static void reportNewConnection(Connection connection) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQMetricsUtil.incrementGauge(new RabbitMQObserverContext(connection), RabbitMQObservabilityConstants.METRIC_CONNECTIONS[0], RabbitMQObservabilityConstants.METRIC_CONNECTIONS[1]);
    }

    public static void reportConnectionClose(Connection connection) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQMetricsUtil.decrementGauge(new RabbitMQObserverContext(connection), RabbitMQObservabilityConstants.METRIC_CONNECTIONS[0], RabbitMQObservabilityConstants.METRIC_CONNECTIONS[1]);
    }

    public static void reportNewChannel(Channel channel) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQMetricsUtil.incrementGauge(new RabbitMQObserverContext(channel), RabbitMQObservabilityConstants.METRIC_CHANNELS[0], RabbitMQObservabilityConstants.METRIC_CHANNELS[1]);
    }

    public static void reportChannelClose(Channel channel) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQMetricsUtil.decrementGauge(new RabbitMQObserverContext(channel), RabbitMQObservabilityConstants.METRIC_CHANNELS[0], RabbitMQObservabilityConstants.METRIC_CHANNELS[1]);
    }

    public static void reportNewQueue(Channel channel, String queueName) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        observerContext.addTag("queue", queueName);
        RabbitMQMetricsUtil.incrementGauge(observerContext, RabbitMQObservabilityConstants.METRIC_QUEUES[0], RabbitMQObservabilityConstants.METRIC_QUEUES[1]);
    }

    public static void reportQueueDeletion(Channel channel, String queueName) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        observerContext.addTag("queue", queueName);
        RabbitMQMetricsUtil.decrementGauge(observerContext, RabbitMQObservabilityConstants.METRIC_QUEUES[0], RabbitMQObservabilityConstants.METRIC_QUEUES[1]);
    }

    public static void reportNewExchange(Channel channel, String exchangeName) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        observerContext.addTag("exchange", exchangeName);
        RabbitMQMetricsUtil.incrementGauge(observerContext, RabbitMQObservabilityConstants.METRIC_EXCHANGES[0], RabbitMQObservabilityConstants.METRIC_EXCHANGES[1]);
    }

    public static void reportExchangeDeletion(Channel channel, String exchangeName) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        observerContext.addTag("exchange", exchangeName);
        RabbitMQMetricsUtil.decrementGauge(observerContext, RabbitMQObservabilityConstants.METRIC_EXCHANGES[0], RabbitMQObservabilityConstants.METRIC_EXCHANGES[1]);
    }

    public static void reportNewConsumer(Channel channel) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQMetricsUtil.incrementGauge(new RabbitMQObserverContext(channel), RabbitMQObservabilityConstants.METRIC_CONSUMERS[0], RabbitMQObservabilityConstants.METRIC_CONSUMERS[1]);
    }

    public static void reportConsumerClose(Channel channel) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQMetricsUtil.decrementGauge(new RabbitMQObserverContext(channel), RabbitMQObservabilityConstants.METRIC_CONSUMERS[0], RabbitMQObservabilityConstants.METRIC_CONSUMERS[1]);
    }

    public static void reportSubscription(Channel channel, ObjectValue service) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        observerContext.addTag("queue", RabbitMQObservabilityUtil.getQueueName(service));
        RabbitMQMetricsUtil.incrementGauge(observerContext, RabbitMQObservabilityConstants.METRIC_SUBSCRIPTION[0], RabbitMQObservabilityConstants.METRIC_SUBSCRIPTION[1]);
    }

    public static void reportUnsubscription(Channel channel, ObjectValue service) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        observerContext.addTag("queue", RabbitMQObservabilityUtil.getQueueName(service));
        RabbitMQMetricsUtil.decrementGauge(observerContext, RabbitMQObservabilityConstants.METRIC_SUBSCRIPTION[0], RabbitMQObservabilityConstants.METRIC_SUBSCRIPTION[1]);
    }

    public static void reportBulkUnsubscription(Channel channel, ObjectValue listenerObjectValue) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        ArrayList services = (ArrayList)listenerObjectValue.getNativeData("consumer_services");
        for (ObjectValue service : services) {
            RabbitMQMetricsUtil.reportUnsubscription(channel, service);
        }
    }

    public static void reportPublish(Channel channel, String exchangeName, String routingKey, int size) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        if (exchangeName == null) {
            exchangeName = "unknown";
        }
        if (exchangeName.equals("")) {
            exchangeName = "default";
        }
        observerContext.addTag("exchange", exchangeName);
        observerContext.addTag("routing_key", routingKey);
        RabbitMQMetricsUtil.incrementCounter(observerContext, RabbitMQObservabilityConstants.METRIC_PUBLISHED[0], RabbitMQObservabilityConstants.METRIC_PUBLISHED[1]);
        RabbitMQMetricsUtil.incrementCounter(observerContext, RabbitMQObservabilityConstants.METRIC_PUBLISHED_SIZE[0], RabbitMQObservabilityConstants.METRIC_PUBLISHED_SIZE[1], size);
    }

    public static void reportConsume(Channel channel, String queueName, int size, String consumeType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        observerContext.addTag("queue", queueName);
        observerContext.addTag("consume_type", consumeType);
        RabbitMQMetricsUtil.incrementCounter(observerContext, RabbitMQObservabilityConstants.METRIC_CONSUMED[0], RabbitMQObservabilityConstants.METRIC_CONSUMED[1]);
        RabbitMQMetricsUtil.incrementCounter(observerContext, RabbitMQObservabilityConstants.METRIC_CONSUMED_SIZE[0], RabbitMQObservabilityConstants.METRIC_CONSUMED_SIZE[1], size);
    }

    public static void reportAcknowledgement(Channel channel, String ackType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        observerContext.addTag("ack_type", ackType);
        RabbitMQMetricsUtil.incrementCounter(observerContext, RabbitMQObservabilityConstants.METRIC_ACK[0], RabbitMQObservabilityConstants.METRIC_ACK[1]);
    }

    public static void reportError(String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext();
        observerContext.addTag("error_type", errorType);
        RabbitMQMetricsUtil.incrementCounter(observerContext, RabbitMQObservabilityConstants.METRIC_ERRORS[0], RabbitMQObservabilityConstants.METRIC_ERRORS[1]);
    }

    public static void reportError(Connection connection, String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(connection);
        observerContext.addTag("error_type", errorType);
        RabbitMQMetricsUtil.incrementCounter(observerContext, RabbitMQObservabilityConstants.METRIC_ERRORS[0], RabbitMQObservabilityConstants.METRIC_ERRORS[1]);
    }

    public static void reportError(Channel channel, String errorType) {
        if (!ObserveUtils.isMetricsEnabled()) {
            return;
        }
        RabbitMQObserverContext observerContext = new RabbitMQObserverContext(channel);
        observerContext.addTag("error_type", errorType);
        RabbitMQMetricsUtil.incrementCounter(observerContext, RabbitMQObservabilityConstants.METRIC_ERRORS[0], RabbitMQObservabilityConstants.METRIC_ERRORS[1]);
    }

    private static void incrementCounter(RabbitMQObserverContext observerContext, String name, String desc) {
        RabbitMQMetricsUtil.incrementCounter(observerContext, name, desc, 1);
    }

    private static void incrementCounter(RabbitMQObserverContext observerContext, String name, String desc, int amount) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.counter(new MetricId("rabbitmq_" + name, desc, observerContext.getAllTags())).increment((long)amount);
    }

    private static void incrementGauge(RabbitMQObserverContext observerContext, String name, String desc) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.gauge(new MetricId("rabbitmq_" + name, desc, observerContext.getAllTags()), new StatisticConfig[0]).increment();
    }

    private static void decrementGauge(RabbitMQObserverContext observerContext, String name, String desc) {
        if (metricRegistry == null) {
            return;
        }
        metricRegistry.gauge(new MetricId("rabbitmq_" + name, desc, observerContext.getAllTags()), new StatisticConfig[0]).decrement();
    }

    private RabbitMQMetricsUtil() {
    }
}

