/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq.observability;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.observability.metrics.Tag;
import org.ballerinalang.jvm.observability.metrics.Tags;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQObservabilityUtil;

public class RabbitMQObserverContext
extends ObserverContext {
    RabbitMQObserverContext() {
        this.setConnectorName("rabbitmq");
    }

    RabbitMQObserverContext(Connection connection) {
        this();
        this.addTag("url", RabbitMQObservabilityUtil.getServerUrl(connection));
    }

    public RabbitMQObserverContext(Channel channel) {
        this(channel.getConnection());
        this.addTag("channel", channel.toString());
    }

    Set<Tag> getAllTags() {
        Map tags = this.getTags();
        HashSet<Tag> allTags = new HashSet<Tag>(tags.size());
        Tags.tags(allTags, (Map)tags);
        return allTags;
    }
}

