/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq;

import com.rabbitmq.client.Channel;
import java.util.concurrent.CountDownLatch;
import org.ballerinalang.jvm.services.ErrorHandlerUtils;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.messaging.rabbitmq.observability.RabbitMQMetricsUtil;

public class RabbitMQResourceCallback
implements CallableUnitCallback {
    private CountDownLatch countDownLatch;
    private Channel channel;
    private String queueName;
    private int size;

    RabbitMQResourceCallback(CountDownLatch countDownLatch, Channel channel, String queueName, int size) {
        this.countDownLatch = countDownLatch;
        this.channel = channel;
        this.queueName = queueName;
        this.size = size;
    }

    public void notifySuccess() {
        RabbitMQMetricsUtil.reportConsume(this.channel, this.queueName, this.size, "service");
        this.countDownLatch.countDown();
    }

    public void notifyFailure(ErrorValue error) {
        this.countDownLatch.countDown();
        RabbitMQMetricsUtil.reportError(this.channel, "dispatch");
        ErrorHandlerUtils.printError((String)("RabbitMQ Error: " + error.getPrintableStackTrace()));
    }
}

