/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq;

import java.util.List;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;

public class RabbitMQResourceValidator {
    private static final String INVALID_RESOURCE_SIGNATURE_FOR = "Invalid resource signature for ";
    private static final String RESOURCE_IN_SERVICE = " resource in service ";

    public static void validate(BLangFunction resource, DiagnosticLog dlog) {
        switch (resource.getName().getValue()) {
            case "onMessage": {
                RabbitMQResourceValidator.validateOnMessageResource(resource, dlog);
                break;
            }
            case "onError": {
                RabbitMQResourceValidator.validateOnErrorResource(resource, dlog);
                break;
            }
            default: {
                dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("Invalid resource name " + resource.getName().getValue() + " in service, only " + "onMessage" + " and " + "onError" + " are allowed"));
            }
        }
    }

    private static void validateOnMessageResource(BLangFunction resource, DiagnosticLog dlog) {
        List paramDetails = resource.getParameters();
        RabbitMQResourceValidator.validateParamDetailsSize(paramDetails, 1, 2, resource, dlog);
        if (!"ballerina/rabbitmq:Message".equals(((BLangSimpleVariable)paramDetails.get((int)0)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + resource.getName().getValue() + " resource: The first parameter should be a rabbitmq:Message"));
        }
        if (paramDetails.size() == 2) {
            RabbitMQResourceValidator.validateDataBindingParam(resource, resource.getParameters(), dlog);
        }
    }

    private static void validateOnErrorResource(BLangFunction resource, DiagnosticLog dlog) {
        List paramDetails = resource.getParameters();
        if (paramDetails.size() != 2) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + resource.getName().getValue() + RESOURCE_IN_SERVICE + ". Expected first parameter (required) type is rabbitmq:Message and the expected second parameter (required) type is error"));
        }
        if (!"ballerina/rabbitmq:Message".equals(((BLangSimpleVariable)paramDetails.get((int)0)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + resource.getName().getValue() + " resource: The first parameter should be a rabbitmq:Message"));
        }
        if (paramDetails.size() < 2 || !"error".equals(((BLangSimpleVariable)paramDetails.get((int)1)).type.toString())) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)String.format("Invalid resource signature for %s resource in service : The second parameter should be an error", resource.getName().getValue()));
        }
    }

    private static void validateParamDetailsSize(List<BLangSimpleVariable> paramDetails, int min, int max, BLangFunction resource, DiagnosticLog dlog) {
        if (paramDetails == null || paramDetails.size() < min || paramDetails.size() > max) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + resource.getName().getValue() + RESOURCE_IN_SERVICE + ": Unexpected parameter count"));
        }
    }

    private static void validateDataBindingParam(BLangFunction resource, List<BLangSimpleVariable> paramDetails, DiagnosticLog dlog) {
        BType paramType = paramDetails.get((int)1).type;
        int paramTypeTag = paramType.tag;
        if (paramTypeTag != 5 && paramTypeTag != 7 && paramTypeTag != 8 && paramTypeTag != 12 && paramTypeTag != 3 && paramTypeTag != 1 && RabbitMQResourceValidator.validateArrayType(paramType)) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + resource.getName().getValue() + RESOURCE_IN_SERVICE + ": The second parameter can only be an int, float, string, json, xml, byte[] or a record type"));
        }
    }

    private static boolean validateArrayType(BType paramType) {
        return paramType.tag != 19 || paramType instanceof BArrayType && ((BArrayType)paramType).getElementType().tag != 2;
    }

    private RabbitMQResourceValidator() {
    }
}

