/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.rabbitmq;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Objects;
import javax.transaction.xa.XAResource;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.transactions.BallerinaTransactionContext;
import org.ballerinalang.jvm.transactions.TransactionLocalContext;
import org.ballerinalang.jvm.transactions.TransactionResourceManager;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.messaging.rabbitmq.RabbitMQConnectorException;

public class RabbitMQTransactionContext
implements BallerinaTransactionContext {
    private Channel channel;
    private String connectorId;

    public RabbitMQTransactionContext(ObjectValue channelObject, String connectorId) {
        this.channel = (Channel)channelObject.getNativeData("rabbitmq_channel_object");
        this.connectorId = connectorId;
    }

    public void commit() {
        try {
            this.channel.txCommit();
        }
        catch (IOException exception) {
            throw new RabbitMQConnectorException("Transaction commit failed: " + exception.getMessage(), exception);
        }
    }

    public void rollback() {
        try {
            this.channel.txRollback();
        }
        catch (IOException exception) {
            throw new RabbitMQConnectorException("Transaction rollback failed: " + exception.getMessage(), exception);
        }
    }

    public void close() {
    }

    public XAResource getXAResource() {
        return null;
    }

    public void handleTransactionBlock(Strand strand) {
        TransactionLocalContext transactionLocalContext = strand.transactionLocalContext;
        BallerinaTransactionContext txContext = transactionLocalContext.getTransactionContext(this.connectorId);
        if (Objects.isNull(txContext)) {
            try {
                this.channel.txSelect();
            }
            catch (IOException exception) {
                throw new RabbitMQConnectorException("I/O Error occurred while initiating the transaction." + exception.getMessage(), exception);
            }
            transactionLocalContext.registerTransactionContext(this.connectorId, (BallerinaTransactionContext)this);
            String globalTxId = transactionLocalContext.getGlobalTransactionId();
            String currentTxBlockId = transactionLocalContext.getCurrentTransactionBlockId();
            TransactionResourceManager.getInstance().register(globalTxId, currentTxBlockId, (BallerinaTransactionContext)this);
        }
    }
}

