/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.ballerinalang.jvm.TableResourceManager;
import org.ballerinalang.jvm.TableUtils;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.TableIterator;

public class TableProvider {
    private static final String UNASSIGNABLE_UNIONTYPE_EXCEPTION = "Corresponding Union type in the record is not an assignable nillable type";
    private static TableProvider tableProvider = null;
    private int tableID = 0;
    private int indexID = 0;

    private TableProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableProvider getInstance() {
        if (tableProvider != null) {
            return tableProvider;
        }
        Class<TableProvider> clazz = TableProvider.class;
        synchronized (TableProvider.class) {
            if (tableProvider == null) {
                tableProvider = new TableProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tableProvider;
        }
    }

    private synchronized int getTableID() {
        return this.tableID++;
    }

    private synchronized int getIndexID() {
        return this.indexID++;
    }

    public String createTable(BType constrainedType, ArrayValue primaryKeys) {
        String tableName = "TABLE_" + constrainedType.getName().toUpperCase() + "_" + this.getTableID();
        String sqlStmt = this.generateCreateTableStatement(tableName, constrainedType, primaryKeys);
        this.executeStatement(sqlStmt);
        return tableName;
    }

    public String createTable(String fromTableName, String joinTableName, String query, BStructureType tableType, ArrayValue params) {
        String newTableName = "TABLE_" + tableType.getName().toUpperCase() + "_" + this.getTableID();
        String sqlStmt = query.replaceFirst("\\[\\[tableName\\]\\]", fromTableName);
        if (joinTableName != null && !joinTableName.isEmpty()) {
            sqlStmt = sqlStmt.replaceFirst("\\[\\[tableName\\]\\]", joinTableName);
        }
        sqlStmt = this.generateCreateTableStatement(sqlStmt, newTableName);
        this.prepareAndExecuteStatement(sqlStmt, params);
        return newTableName;
    }

    public String createTable(String fromTableName, String query, BStructureType tableType, ArrayValue params) {
        return this.createTable(fromTableName, null, query, tableType, params);
    }

    public void insertData(String tableName, MapValueImpl<String, Object> constrainedType) {
        String sqlStmt = TableUtils.generateInsertDataStatement(tableName, constrainedType);
        this.prepareAndExecuteStatement(sqlStmt, constrainedType);
    }

    public void deleteData(String tableName, MapValueImpl<String, Object> constrainedType) {
        String sqlStmt = TableUtils.generateDeleteDataStatment(tableName, constrainedType);
        this.prepareAndExecuteStatement(sqlStmt, constrainedType);
    }

    public void dropTable(String tableName) {
        String sqlStmt = "DROP TABLE " + tableName;
        this.executeStatement(sqlStmt);
    }

    public TableIterator createIterator(String tableName, BStructureType type) {
        TableIterator itr;
        Statement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
            TableResourceManager rm = new TableResourceManager(conn, stmt, true);
            rm.addResultSet(rs);
            itr = new TableIterator(rm, rs, type);
        }
        catch (SQLException e) {
            this.releaseResources(conn, stmt);
            throw TableUtils.createTableOperationError("error in creating iterator for table : " + e.getMessage());
        }
        return itr;
    }

    private Connection getConnection() {
        Connection conn;
        try {
            conn = DriverManager.getConnection("jdbc:h2:mem:TABLEDB;DB_CLOSE_DELAY=-1", "sa", "");
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError("error in getting connection for table db : " + e.getMessage());
        }
        return conn;
    }

    private String generateCreateTableStatement(String tableName, BType constrainedType, ArrayValue primaryKeys) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(tableName).append(" (");
        Collection<BField> structFields = ((BStructureType)constrainedType).getFields().values();
        String seperator = "";
        for (BField sf : structFields) {
            int type = sf.getFieldType().getTag();
            String name = sf.getFieldName();
            sb.append(seperator).append(name).append(" ");
            switch (type) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 20: {
                    this.generateCreateTableStatement(type, sf, sb);
                    break;
                }
                case 21: {
                    List<BType> members = ((BUnionType)sf.getFieldType()).getMemberTypes();
                    if (members.size() != 2) {
                        throw TableUtils.createTableOperationError(UNASSIGNABLE_UNIONTYPE_EXCEPTION);
                    }
                    if (members.get(0).getTag() == 10) {
                        this.generateCreateTableStatement(members.get(1).getTag(), sf, sb);
                        break;
                    }
                    if (members.get(1).getTag() == 10) {
                        this.generateCreateTableStatement(members.get(0).getTag(), sf, sb);
                        break;
                    }
                    throw TableUtils.createTableOperationError(UNASSIGNABLE_UNIONTYPE_EXCEPTION);
                }
                default: {
                    throw TableUtils.createTableOperationError("Unsupported column type for table : " + sf.getFieldType());
                }
            }
            seperator = ",";
        }
        if (primaryKeys != null) {
            seperator = "";
            int primaryKeyCount = primaryKeys.size();
            if (primaryKeyCount > 0) {
                sb.append(",PRIMARY KEY (");
                for (int i = 0; i < primaryKeyCount; ++i) {
                    sb.append(seperator).append(primaryKeys.getString(i));
                    seperator = ",";
                }
                sb.append(")");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private void generateCreateTableStatement(int type, BField sf, StringBuilder sb) {
        switch (type) {
            case 1: {
                sb.append("BIGINT");
                break;
            }
            case 5: {
                sb.append("VARCHAR");
                break;
            }
            case 3: {
                sb.append("DOUBLE");
                break;
            }
            case 4: {
                sb.append("DECIMAL");
                break;
            }
            case 6: {
                sb.append("BOOLEAN");
                break;
            }
            case 7: 
            case 8: {
                sb.append("CLOB");
                break;
            }
            case 20: {
                BType elementType = ((BArrayType)sf.getFieldType()).getElementType();
                if (elementType.getTag() == 2) {
                    sb.append("BLOB");
                    break;
                }
                sb.append("ARRAY");
                break;
            }
            default: {
                throw TableUtils.createTableOperationError("Unsupported nillable field for table : " + sf.getFieldType());
            }
        }
    }

    private String generateCreateTableStatement(String query, String newTableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(newTableName).append(" ").append("AS ");
        sb.append(query);
        return sb.toString();
    }

    private void executeStatement(String queryStatement) {
        Statement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(queryStatement);
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError("error in executing statement : " + queryStatement + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }

    private void prepareAndExecuteStatement(String queryStatement, ArrayValue params) {
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.prepareStatement(queryStatement);
            block14: for (int index = 1; index <= params.size(); ++index) {
                Object param = params.getRefValue(index - 1);
                BType paramType = TypeChecker.getType(param);
                switch (paramType.getTag()) {
                    case 1: {
                        stmt.setLong(index, (Long)params.getRefValue(index - 1));
                        continue block14;
                    }
                    case 5: {
                        stmt.setString(index, (String)params.getRefValue(index - 1));
                        continue block14;
                    }
                    case 3: {
                        stmt.setDouble(index, (Double)params.getRefValue(index - 1));
                        continue block14;
                    }
                    case 4: {
                        stmt.setBigDecimal(index, ((DecimalValue)params.getRefValue(index - 1)).value());
                        continue block14;
                    }
                    case 6: {
                        stmt.setBoolean(index, (Boolean)params.getRefValue(index - 1));
                        continue block14;
                    }
                    case 7: 
                    case 8: {
                        stmt.setString(index, params.getString(index - 1));
                        continue block14;
                    }
                    case 20: {
                        BType elementType = ((BArrayType)paramType).getElementType();
                        if (elementType.getTag() == 2) {
                            byte[] blobData = params.getBytes();
                            stmt.setBlob(index, new ByteArrayInputStream(blobData), blobData.length);
                            continue block14;
                        }
                        Object[] arrayData = TableUtils.getArrayData((ArrayValue)param);
                        stmt.setObject(index, arrayData);
                    }
                }
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError("error in executing statement : " + queryStatement + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }

    private void prepareAndExecuteStatement(String queryStatement, MapValueImpl<String, Object> constrainedType) {
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.prepareStatement(queryStatement);
            TableUtils.prepareAndExecuteStatement(stmt, constrainedType);
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError("error in executing statement : " + queryStatement + " error:" + e.getMessage());
        }
        finally {
            this.releaseResources(conn, stmt);
        }
    }

    private void releaseResources(Connection conn, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError("error in releasing table statement resource : " + e.getMessage());
        }
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw TableUtils.createTableOperationError("error in releasing table connection resource : " + e.getMessage());
        }
    }
}

