/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.commons.TypeValuePair;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.Flags;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;

public class TypeConverter {
    private static final String NaN = "NaN";
    private static final String POSITIVE_INFINITY = "Infinity";
    private static final String NEGATIVE_INFINITY = "-Infinity";

    public static Object convertValues(BType targetType, Object inputValue) {
        BType inputType = TypeChecker.getType(inputValue);
        switch (targetType.getTag()) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return TypeConverter.anyToInt(inputValue, () -> BallerinaErrors.createNumericConversionError(inputValue, BTypes.typeInt));
            }
            case 4: {
                return TypeConverter.anyToDecimal(inputValue, () -> BallerinaErrors.createNumericConversionError(inputValue, BTypes.typeDecimal));
            }
            case 3: {
                return TypeConverter.anyToFloat(inputValue, () -> BallerinaErrors.createNumericConversionError(inputValue, BTypes.typeFloat));
            }
            case 5: {
                return TypeConverter.anyToString(inputValue);
            }
            case 6: {
                return TypeConverter.anyToBoolean(inputValue, () -> BallerinaErrors.createNumericConversionError(inputValue, BTypes.typeBoolean));
            }
            case 2: {
                return TypeConverter.anyToByte(inputValue, () -> BallerinaErrors.createNumericConversionError(inputValue, BTypes.typeByte));
            }
        }
        throw new ErrorValue(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, (Object)BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, inputType, inputValue, targetType));
    }

    public static Object castValues(BType targetType, Object inputValue) {
        switch (targetType.getTag()) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return TypeConverter.anyToIntCast(inputValue, () -> BallerinaErrors.createTypeCastError(inputValue, BTypes.typeInt));
            }
            case 4: {
                return TypeConverter.anyToDecimal(inputValue, () -> BallerinaErrors.createTypeCastError(inputValue, BTypes.typeDecimal));
            }
            case 3: {
                return TypeConverter.anyToFloatCast(inputValue, () -> BallerinaErrors.createTypeCastError(inputValue, BTypes.typeFloat));
            }
            case 5: {
                return TypeConverter.anyToStringCast(inputValue, () -> BallerinaErrors.createTypeCastError(inputValue, BTypes.typeString));
            }
            case 6: {
                return TypeConverter.anyToBooleanCast(inputValue, () -> BallerinaErrors.createTypeCastError(inputValue, BTypes.typeBoolean));
            }
            case 2: {
                return TypeConverter.anyToByteCast(inputValue, () -> BallerinaErrors.createTypeCastError(inputValue, BTypes.typeByte));
            }
        }
        throw BallerinaErrors.createTypeCastError(inputValue, targetType);
    }

    static boolean isConvertibleToByte(Object value) {
        BType inputType = TypeChecker.getType(value);
        switch (inputType.getTag()) {
            case 2: {
                return true;
            }
            case 1: {
                return TypeChecker.isByteLiteral((Long)value);
            }
            case 3: {
                Double doubleValue = (Double)value;
                return TypeConverter.isFloatWithinIntRange(doubleValue) && TypeChecker.isByteLiteral(doubleValue.longValue());
            }
            case 4: {
                return DecimalValue.isDecimalWithinIntRange((BigDecimal)value) && TypeChecker.isByteLiteral(((BigDecimal)value).longValue());
            }
        }
        return false;
    }

    static boolean isConvertibleToInt(Object value) {
        BType inputType = TypeChecker.getType(value);
        switch (inputType.getTag()) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: {
                return TypeConverter.isFloatWithinIntRange((Double)value);
            }
            case 4: {
                return DecimalValue.isDecimalWithinIntRange((BigDecimal)value);
            }
        }
        return false;
    }

    static boolean isConvertibleToIntSubType(Object value, BType targetType) {
        long val;
        BType inputType = TypeChecker.getType(value);
        switch (inputType.getTag()) {
            case 1: 
            case 2: {
                val = ((Number)value).longValue();
                break;
            }
            case 3: {
                if (!TypeConverter.isFloatWithinIntRange((Double)value)) {
                    return false;
                }
                val = TypeConverter.floatToInt((Double)value);
                break;
            }
            case 4: {
                if (!DecimalValue.isDecimalWithinIntRange((BigDecimal)value)) {
                    return false;
                }
                val = ((BigDecimal)value).intValue();
                break;
            }
            default: {
                return false;
            }
        }
        switch (targetType.getTag()) {
            case 38: {
                return TypeChecker.isSigned32LiteralValue(val);
            }
            case 39: {
                return TypeChecker.isSigned16LiteralValue(val);
            }
            case 40: {
                return TypeChecker.isSigned8LiteralValue(val);
            }
            case 41: {
                return TypeChecker.isUnsigned32LiteralValue(val);
            }
            case 42: {
                return TypeChecker.isUnsigned16LiteralValue(val);
            }
            case 43: {
                return TypeChecker.isUnsigned8LiteralValue(val);
            }
        }
        return false;
    }

    static boolean isConvertibleToChar(Object value) {
        BType inputType = TypeChecker.getType(value);
        if (inputType.getTag() == 5) {
            return TypeChecker.isCharLiteralValue(value);
        }
        return false;
    }

    static boolean isConvertibleToFloatingPointTypes(Object value) {
        BType inputType = TypeChecker.getType(value);
        switch (inputType.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static List<BType> getConvertibleTypes(Object inputValue, BType targetType) {
        return TypeConverter.getConvertibleTypes(inputValue, targetType, new ArrayList<TypeValuePair>());
    }

    public static List<BType> getConvertibleTypes(Object inputValue, BType targetType, List<TypeValuePair> unresolvedValues) {
        ArrayList<BType> convertibleTypes = new ArrayList<BType>();
        int targetTypeTag = targetType.getTag();
        switch (targetTypeTag) {
            case 21: {
                for (BType memType : ((BUnionType)targetType).getMemberTypes()) {
                    convertibleTypes.addAll(TypeConverter.getConvertibleTypes(inputValue, memType, unresolvedValues));
                }
                break;
            }
            case 12: {
                if (!TypeConverter.isConvertibleToRecordType(inputValue, (BRecordType)targetType, unresolvedValues)) break;
                convertibleTypes.add(targetType);
                break;
            }
            case 11: {
                BType matchingType = TypeConverter.resolveMatchingTypeForUnion(inputValue, targetType);
                if (matchingType == null) break;
                convertibleTypes.add(matchingType);
                break;
            }
            default: {
                if (!TypeChecker.checkIsLikeType(inputValue, targetType, true)) break;
                convertibleTypes.add(targetType);
            }
        }
        return convertibleTypes;
    }

    private static boolean isConvertibleToRecordType(Object sourceValue, BRecordType targetType, List<TypeValuePair> unresolvedValues) {
        if (!(sourceValue instanceof MapValueImpl)) {
            return false;
        }
        TypeValuePair typeValuePair = new TypeValuePair(sourceValue, targetType);
        if (unresolvedValues.contains(typeValuePair)) {
            return true;
        }
        unresolvedValues.add(typeValuePair);
        HashMap<String, BType> targetFieldTypes = new HashMap<String, BType>();
        BType restFieldType = targetType.restFieldType;
        for (BField field : targetType.getFields().values()) {
            targetFieldTypes.put(field.getFieldName(), field.type);
        }
        MapValueImpl sourceMapValueImpl = (MapValueImpl)sourceValue;
        for (Map.Entry targetTypeEntry : targetFieldTypes.entrySet()) {
            String fieldName = targetTypeEntry.getKey().toString();
            if (sourceMapValueImpl.containsKey(fieldName)) continue;
            BField targetField = targetType.getFields().get(fieldName);
            if (!Flags.isFlagOn(targetField.flags, 256)) continue;
            return false;
        }
        for (Map.Entry object : sourceMapValueImpl.entrySet()) {
            Map.Entry valueEntry = object;
            String fieldName = valueEntry.getKey().toString();
            if (targetFieldTypes.containsKey(fieldName)) {
                if (TypeConverter.getConvertibleTypes(valueEntry.getValue(), (BType)targetFieldTypes.get(fieldName), unresolvedValues).size() == 1) continue;
                return false;
            }
            if (!targetType.sealed) {
                if (TypeConverter.getConvertibleTypes(valueEntry.getValue(), restFieldType, unresolvedValues).size() == 1) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    static long anyToInt(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Long) {
            return (Long)sourceVal;
        }
        if (sourceVal instanceof Double) {
            return TypeConverter.floatToInt((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return ((Integer)sourceVal).longValue();
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1L : 0L;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).intValue();
        }
        if (sourceVal instanceof String) {
            try {
                return Long.parseLong((String)sourceVal);
            }
            catch (NumberFormatException e) {
                throw errorFunc.get();
            }
        }
        throw errorFunc.get();
    }

    static long anyToIntCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Long) {
            return (Long)sourceVal;
        }
        if (sourceVal instanceof Double) {
            return TypeConverter.floatToInt((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return ((Integer)sourceVal).longValue();
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1L : 0L;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).intValue();
        }
        throw errorFunc.get();
    }

    static long anyToIntSubTypeCast(Object sourceVal, BType type, Supplier<ErrorValue> errorFunc) {
        long value = TypeConverter.anyToIntCast(sourceVal, errorFunc);
        if (type == BTypes.typeIntSigned32 && TypeChecker.isSigned32LiteralValue(value)) {
            return value;
        }
        if (type == BTypes.typeIntSigned16 && TypeChecker.isSigned16LiteralValue(value)) {
            return value;
        }
        if (type == BTypes.typeIntSigned8 && TypeChecker.isSigned8LiteralValue(value)) {
            return value;
        }
        if (type == BTypes.typeIntUnsigned32 && TypeChecker.isUnsigned32LiteralValue(value)) {
            return value;
        }
        if (type == BTypes.typeIntUnsigned16 && TypeChecker.isUnsigned16LiteralValue(value)) {
            return value;
        }
        if (type == BTypes.typeIntUnsigned8 && TypeChecker.isUnsigned8LiteralValue(value)) {
            return value;
        }
        throw errorFunc.get();
    }

    static double anyToFloat(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Long) {
            return ((Long)sourceVal).doubleValue();
        }
        if (sourceVal instanceof Double) {
            return (Double)sourceVal;
        }
        if (sourceVal instanceof Integer) {
            return ((Integer)sourceVal).floatValue();
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1.0 : 0.0;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).floatValue();
        }
        if (sourceVal instanceof String) {
            try {
                return Double.parseDouble((String)sourceVal);
            }
            catch (NumberFormatException e) {
                throw errorFunc.get();
            }
        }
        throw errorFunc.get();
    }

    static double anyToFloatCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Long) {
            return ((Long)sourceVal).doubleValue();
        }
        if (sourceVal instanceof Double) {
            return (Double)sourceVal;
        }
        if (sourceVal instanceof Integer) {
            return ((Integer)sourceVal).floatValue();
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1.0 : 0.0;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).floatValue();
        }
        throw errorFunc.get();
    }

    static boolean anyToBoolean(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Long) {
            return (Long)sourceVal != 0L;
        }
        if (sourceVal instanceof Double) {
            return (Double)sourceVal != 0.0;
        }
        if (sourceVal instanceof Integer) {
            return (Integer)sourceVal != 0;
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).booleanValue();
        }
        if (sourceVal instanceof String) {
            try {
                return Boolean.parseBoolean((String)sourceVal);
            }
            catch (NumberFormatException e) {
                throw errorFunc.get();
            }
        }
        throw errorFunc.get();
    }

    static boolean anyToBooleanCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal;
        }
        throw errorFunc.get();
    }

    public static int intToByte(long sourceVal) {
        if (!TypeChecker.isByteLiteral(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeByte);
        }
        return Long.valueOf(sourceVal).intValue();
    }

    public static long intToSigned32(long sourceVal) {
        if (!TypeChecker.isSigned32LiteralValue(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeIntSigned32);
        }
        return sourceVal;
    }

    public static long intToSigned16(long sourceVal) {
        if (!TypeChecker.isSigned16LiteralValue(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeIntSigned16);
        }
        return sourceVal;
    }

    public static long intToSigned8(long sourceVal) {
        if (!TypeChecker.isSigned8LiteralValue(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeIntSigned8);
        }
        return sourceVal;
    }

    public static long intToUnsigned32(long sourceVal) {
        if (!TypeChecker.isUnsigned32LiteralValue(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeIntUnsigned32);
        }
        return sourceVal;
    }

    public static long intToUnsigned16(long sourceVal) {
        if (!TypeChecker.isUnsigned16LiteralValue(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeIntUnsigned16);
        }
        return sourceVal;
    }

    public static long intToUnsigned8(long sourceVal) {
        if (!TypeChecker.isUnsigned8LiteralValue(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeIntUnsigned8);
        }
        return sourceVal;
    }

    public static long floatToSigned32(double sourceVal) {
        return TypeConverter.intToSigned32(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToSigned16(double sourceVal) {
        return TypeConverter.intToSigned16(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToSigned8(double sourceVal) {
        return TypeConverter.intToSigned8(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToUnsigned32(double sourceVal) {
        return TypeConverter.intToUnsigned32(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToUnsigned16(double sourceVal) {
        return TypeConverter.intToUnsigned16(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToUnsigned8(double sourceVal) {
        return TypeConverter.intToUnsigned8(TypeConverter.floatToInt(sourceVal));
    }

    public static String stringToChar(Object sourceVal) {
        if (!TypeChecker.isCharLiteralValue(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeStringChar);
        }
        return Objects.toString(sourceVal);
    }

    public static String anyToChar(Object sourceVal) {
        String value = Objects.toString(sourceVal);
        return TypeConverter.stringToChar(value);
    }

    public static int floatToByte(double sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, BTypes.typeByte);
        long intVal = Math.round(sourceVal);
        if (!TypeChecker.isByteLiteral(intVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeByte);
        }
        return (int)intVal;
    }

    public static long floatToInt(double sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, BTypes.typeInt);
        if (!TypeConverter.isFloatWithinIntRange(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeInt);
        }
        return (long)Math.rint(sourceVal);
    }

    private static void checkIsValidFloat(double sourceVal, BType targetType) {
        if (Double.isNaN(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(NaN, BTypes.typeFloat, targetType);
        }
        if (Double.isInfinite(sourceVal)) {
            String value = sourceVal > 0.0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
            throw BallerinaErrors.createNumericConversionError(value, BTypes.typeFloat, targetType);
        }
    }

    static int anyToByte(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Long) {
            return TypeConverter.intToByte((Long)sourceVal);
        }
        if (sourceVal instanceof Double) {
            return TypeConverter.floatToByte((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return (Integer)sourceVal;
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1 : 0;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).byteValue();
        }
        if (sourceVal instanceof String) {
            try {
                return Integer.parseInt((String)sourceVal);
            }
            catch (NumberFormatException e) {
                throw errorFunc.get();
            }
        }
        throw errorFunc.get();
    }

    static int anyToByteCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Long) {
            return TypeConverter.intToByte((Long)sourceVal);
        }
        if (sourceVal instanceof Byte) {
            return ((Byte)sourceVal).intValue();
        }
        if (sourceVal instanceof Double) {
            return TypeConverter.floatToByte((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return (Integer)sourceVal;
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1 : 0;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).byteValue();
        }
        throw errorFunc.get();
    }

    private static String anyToString(Object sourceVal) {
        if (sourceVal instanceof Long) {
            return Long.toString((Long)sourceVal);
        }
        if (sourceVal instanceof Double) {
            return Double.toString((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return Long.toString(((Integer)sourceVal).intValue());
        }
        if (sourceVal instanceof Boolean) {
            return Boolean.toString((Boolean)sourceVal);
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).stringValue();
        }
        if (sourceVal instanceof String) {
            return (String)sourceVal;
        }
        if (sourceVal == null) {
            return "()";
        }
        throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeString);
    }

    private static String anyToStringCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof String) {
            return (String)sourceVal;
        }
        throw errorFunc.get();
    }

    static DecimalValue anyToDecimal(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Long) {
            return DecimalValue.valueOf((Long)sourceVal);
        }
        if (sourceVal instanceof Double) {
            return DecimalValue.valueOf((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return DecimalValue.valueOf((Integer)sourceVal);
        }
        if (sourceVal instanceof Boolean) {
            return DecimalValue.valueOf((Boolean)sourceVal);
        }
        if (sourceVal instanceof DecimalValue) {
            return (DecimalValue)sourceVal;
        }
        if (sourceVal instanceof String) {
            return new DecimalValue((String)sourceVal);
        }
        if (sourceVal instanceof DecimalValue) {
            return (DecimalValue)sourceVal;
        }
        throw errorFunc.get();
    }

    static byte anyToJByteCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Byte) {
            return (Byte)sourceVal;
        }
        throw errorFunc.get();
    }

    static char anyToJCharCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Character) {
            return ((Character)sourceVal).charValue();
        }
        throw errorFunc.get();
    }

    static short anyToJShortCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Short) {
            return (Short)sourceVal;
        }
        throw errorFunc.get();
    }

    static int anyToJIntCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Integer) {
            return (Integer)sourceVal;
        }
        throw errorFunc.get();
    }

    static long anyToJLongCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Long) {
            return (Long)sourceVal;
        }
        throw errorFunc.get();
    }

    static float anyToJFloatCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Float) {
            return ((Float)sourceVal).floatValue();
        }
        throw errorFunc.get();
    }

    static double anyToJDoubleCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Double) {
            return (Double)sourceVal;
        }
        throw errorFunc.get();
    }

    static boolean anyToJBooleanCast(Object sourceVal, Supplier<ErrorValue> errorFunc) {
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal;
        }
        throw errorFunc.get();
    }

    public static long jFloatToBInt(float sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, BTypes.typeInt);
        if (!TypeConverter.isFloatWithinIntRange(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(Float.valueOf(sourceVal), BTypes.typeInt);
        }
        return (long)Math.rint(sourceVal);
    }

    public static long jDoubleToBInt(double sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, BTypes.typeInt);
        if (!TypeConverter.isFloatWithinIntRange(sourceVal)) {
            throw BallerinaErrors.createNumericConversionError(sourceVal, BTypes.typeInt);
        }
        return (long)Math.rint(sourceVal);
    }

    private static boolean isFloatWithinIntRange(double doubleValue) {
        return doubleValue < 9.223372036854776E18 && doubleValue > -9.223372036854776E18;
    }

    public static BType resolveMatchingTypeForUnion(Object value, BType type) {
        if (value instanceof ArrayValue && ((ArrayValue)value).getType().getTag() == 20 && !TypeConverter.isDeepStampingRequiredForArray(((ArrayValue)value).getType())) {
            return ((ArrayValue)value).getType();
        }
        if (value instanceof MapValue && ((MapValue)value).getType().getTag() == 15 && !TypeConverter.isDeepStampingRequiredForMap(((MapValue)value).getType())) {
            return ((MapValue)value).getType();
        }
        if (value == null && type.isNilable()) {
            return BTypes.typeNull;
        }
        if (TypeChecker.checkIsLikeType(value, BTypes.typeInt)) {
            return BTypes.typeInt;
        }
        if (TypeChecker.checkIsLikeType(value, BTypes.typeFloat)) {
            return BTypes.typeFloat;
        }
        if (TypeChecker.checkIsLikeType(value, BTypes.typeString)) {
            return BTypes.typeString;
        }
        if (TypeChecker.checkIsLikeType(value, BTypes.typeBoolean)) {
            return BTypes.typeBoolean;
        }
        if (TypeChecker.checkIsLikeType(value, BTypes.typeByte)) {
            return BTypes.typeByte;
        }
        BArrayType anydataArrayType = new BArrayType(type);
        if (TypeChecker.checkIsLikeType(value, anydataArrayType)) {
            return anydataArrayType;
        }
        if (TypeChecker.checkIsLikeType(value, BTypes.typeXML)) {
            return BTypes.typeXML;
        }
        BMapType anydataMapType = new BMapType(type);
        if (TypeChecker.checkIsLikeType(value, anydataMapType)) {
            return anydataMapType;
        }
        return null;
    }

    private static boolean isDeepStampingRequiredForArray(BType sourceType) {
        BType elementType = ((BArrayType)sourceType).getElementType();
        if (elementType != null) {
            if (BTypes.isValueType(elementType)) {
                return false;
            }
            if (elementType instanceof BArrayType) {
                return TypeConverter.isDeepStampingRequiredForArray(elementType);
            }
            return true;
        }
        return true;
    }

    private static boolean isDeepStampingRequiredForMap(BType sourceType) {
        BType constrainedType = ((BMapType)sourceType).getConstrainedType();
        if (constrainedType != null) {
            if (BTypes.isValueType(constrainedType)) {
                return false;
            }
            if (constrainedType instanceof BMapType) {
                return TypeConverter.isDeepStampingRequiredForMap(constrainedType);
            }
            return true;
        }
        return true;
    }
}

