/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.TableOMDataSource;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.XMLTreeBuilder;
import org.ballerinalang.jvm.XMLValidator;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.TableValue;
import org.ballerinalang.jvm.values.XMLComment;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLPi;
import org.ballerinalang.jvm.values.XMLQName;
import org.ballerinalang.jvm.values.XMLSequence;
import org.ballerinalang.jvm.values.XMLText;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BXML;

public class XMLFactory {
    public static final StAXParserConfiguration STAX_PARSER_CONFIGURATION = StAXParserConfiguration.STANDALONE;

    public static XMLValue parse(String xmlStr) {
        try {
            if (xmlStr.isEmpty()) {
                return new XMLSequence();
            }
            XMLTreeBuilder treeBuilder = new XMLTreeBuilder(xmlStr);
            return treeBuilder.parse();
        }
        catch (Throwable e) {
            throw BallerinaErrors.createError(StringUtils.fromString("failed to parse xml: " + e.getMessage()));
        }
    }

    public static XMLValue parse(InputStream xmlStream) {
        try {
            XMLTreeBuilder treeBuilder = new XMLTreeBuilder(new InputStreamReader(xmlStream));
            return treeBuilder.parse();
        }
        catch (DeferredParsingException e) {
            throw BallerinaErrors.createError(e.getCause().getMessage());
        }
        catch (Throwable e) {
            throw BallerinaErrors.createError("failed to create xml: " + e.getMessage());
        }
    }

    public static XMLValue parse(InputStream xmlStream, String charset) {
        try {
            XMLTreeBuilder xmlTreeBuilder = new XMLTreeBuilder(new InputStreamReader(xmlStream, charset));
            return xmlTreeBuilder.parse();
        }
        catch (DeferredParsingException e) {
            throw BallerinaErrors.createError(e.getCause().getMessage());
        }
        catch (Throwable e) {
            throw BallerinaErrors.createError("failed to create xml: " + e.getMessage());
        }
    }

    public static XMLValue parse(Reader reader) {
        try {
            XMLTreeBuilder xmlTreeBuilder = new XMLTreeBuilder(reader);
            return xmlTreeBuilder.parse();
        }
        catch (DeferredParsingException e) {
            throw BallerinaErrors.createError(e.getCause().getMessage());
        }
        catch (Throwable e) {
            throw BallerinaErrors.createError("failed to create xml: " + e.getMessage());
        }
    }

    public static XMLValue concatenate(XMLValue firstSeq, XMLValue secondSeq) {
        ArrayList<BXML> concatenatedList = new ArrayList<BXML>();
        if (firstSeq.getNodeType() == XMLNodeType.TEXT && secondSeq.getNodeType() == XMLNodeType.TEXT) {
            return new XMLText(firstSeq.getTextValue() + secondSeq.getTextValue());
        }
        if (firstSeq.getNodeType() == XMLNodeType.SEQUENCE) {
            concatenatedList.addAll(((XMLSequence)firstSeq).getChildrenList());
        } else {
            concatenatedList.add(firstSeq);
        }
        if (!concatenatedList.isEmpty()) {
            int lastIndexOFLeftChildren = concatenatedList.size() - 1;
            BXML lastItem = (BXML)concatenatedList.get(lastIndexOFLeftChildren);
            if (lastItem.getNodeType() == XMLNodeType.TEXT && secondSeq.getNodeType() == XMLNodeType.SEQUENCE) {
                BXML firsOfRightSeq;
                List<BXML> rightChildren = ((XMLSequence)secondSeq).getChildrenList();
                if (!rightChildren.isEmpty() && (firsOfRightSeq = rightChildren.get(0)).getNodeType() == XMLNodeType.TEXT) {
                    concatenatedList.remove(lastIndexOFLeftChildren);
                    concatenatedList.addAll(rightChildren);
                    String merged = ((XMLText)lastItem).getTextValue() + ((XMLText)firsOfRightSeq).getTextValue();
                    concatenatedList.set(lastIndexOFLeftChildren, new XMLText(merged));
                    return new XMLSequence(concatenatedList);
                }
            } else if (lastItem.getNodeType() == XMLNodeType.TEXT && secondSeq.getNodeType() == XMLNodeType.TEXT) {
                String merged = lastItem.getTextValue() + secondSeq.getTextValue();
                concatenatedList.set(lastIndexOFLeftChildren, new XMLText(merged));
                return new XMLSequence(concatenatedList);
            }
        }
        if (secondSeq.getNodeType() == XMLNodeType.SEQUENCE) {
            concatenatedList.addAll(((XMLSequence)secondSeq).getChildrenList());
        } else {
            concatenatedList.add(secondSeq);
        }
        return new XMLSequence(concatenatedList);
    }

    public static XMLValue tableToXML(TableValue table) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLStreamWriter streamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream);
            TableOMDataSource tableOMDataSource = new TableOMDataSource(table, null, null);
            tableOMDataSource.serialize(streamWriter);
            streamWriter.flush();
            outputStream.flush();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return XMLFactory.parse(inputStream);
        }
        catch (IOException | XMLStreamException e) {
            throw new BallerinaException(e);
        }
    }

    @Deprecated
    public static XMLValue createXMLElement(XMLQName startTagName, XMLQName endTagName, String defaultNsUri) {
        if (!(StringUtils.isEqual(startTagName.getLocalName(), endTagName.getLocalName()) && StringUtils.isEqual(startTagName.getUri(), endTagName.getUri()) && StringUtils.isEqual(startTagName.getPrefix(), endTagName.getPrefix()))) {
            throw BallerinaErrors.createError("start and end tag names mismatch: '" + startTagName + "' and '" + endTagName + "'");
        }
        return XMLFactory.createXMLElement(startTagName, defaultNsUri);
    }

    @Deprecated
    public static XMLValue createXMLElement(XMLQName startTagName, String defaultNsUri) {
        String prefix;
        XMLValidator.validateXMLQName(startTagName);
        String nsUri = startTagName.getUri();
        if (defaultNsUri == null) {
            defaultNsUri = "";
        }
        String string = prefix = startTagName.getPrefix() == null ? "" : startTagName.getPrefix();
        if (nsUri == null) {
            return new XMLItem(new QName(defaultNsUri, startTagName.getLocalName(), prefix));
        }
        XMLItem xmlItem = new XMLItem(new QName(nsUri, startTagName.getLocalName(), prefix));
        if (defaultNsUri != null && !defaultNsUri.isEmpty()) {
            xmlItem.setAttribute("xmlns", null, null, defaultNsUri);
        }
        return xmlItem;
    }

    public static XMLValue createXMLElement(XMLQName startTagName, BString defaultNsUriVal) {
        return XMLFactory.createXMLElement(startTagName, defaultNsUriVal == null ? "" : defaultNsUriVal.getValue());
    }

    @Deprecated
    public static XMLValue createXMLComment(String content) {
        return new XMLComment(content);
    }

    public static XMLValue createXMLComment(BString content) {
        return XMLFactory.createXMLComment(content.getValue());
    }

    @Deprecated
    public static XMLValue createXMLText(String content) {
        return new XMLText(XMLTextUnescape.unescape(content));
    }

    public static XMLValue createXMLText(BString contentVal) {
        return XMLFactory.createXMLText(contentVal.getValue());
    }

    @Deprecated
    public static XMLValue createXMLProcessingInstruction(String tartget, String data) {
        return new XMLPi(data, tartget);
    }

    public static XMLValue createXMLProcessingInstruction(BString tartget, BString data) {
        return XMLFactory.createXMLProcessingInstruction(tartget.getValue(), data.getValue());
    }

    public static boolean isEqual(XMLValue xmlOne, XMLValue xmlTwo) {
        return xmlOne.equals(xmlTwo);
    }

    public static OMElement stringToOM(String xmlFragment) throws XMLStreamException {
        return XMLFactory.stringToOM(OMAbstractFactory.getOMFactory(), xmlFragment);
    }

    private static OMElement stringToOM(OMFactory omFactory, String xmlFragment) throws XMLStreamException {
        return xmlFragment != null ? OMXMLBuilderFactory.createOMBuilder((OMFactory)omFactory, (StAXParserConfiguration)STAX_PARSER_CONFIGURATION, (Reader)new StringReader(xmlFragment)).getDocumentElement() : null;
    }

    public static class XMLTextUnescape {
        public static String unescape(String str) {
            return XMLTextUnescape.unescape(str.getBytes(StandardCharsets.UTF_8));
        }

        /*
         * Unable to fully structure code
         */
        private static String unescape(byte[] bytes) {
            target = new byte[bytes.length];
            size = bytes.length;
            len = 0;
            i = 0;
            while (i < size) {
                block8: {
                    block7: {
                        b = bytes[i];
                        i1 = i + 1;
                        if (b != 13 || i1 >= size || bytes[i1] != 10) break block7;
                        target[len] = 10;
                        ++i;
                        break block8;
                    }
                    if (b != 38) ** GOTO lbl-1000
                    i2 = i + 2;
                    i3 = i + 3;
                    if (i3 < size && bytes[i1] == 103 && bytes[i2] == 116 && bytes[i3] == 59) {
                        target[len] = 62;
                        i += 3;
                    } else if (i3 < size && bytes[i1] == 108 && bytes[i2] == 116 && bytes[i3] == 59) {
                        target[len] = 60;
                        i += 3;
                    } else if (i3 + 1 < size && bytes[i1] == 97 && bytes[i2] == 109 && bytes[i3] == 112 && bytes[i3 + 1] == 59) {
                        target[len] = 38;
                        i += 4;
                    } else lbl-1000:
                    // 2 sources

                    {
                        target[len] = b;
                    }
                }
                ++i;
                ++len;
            }
            return new String(target, 0, len);
        }
    }
}

