/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability.tracer;

import io.opentracing.Span;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.observability.tracer.TraceManager;

public class BSpan {
    private static final TraceManager manager = TraceManager.getInstance();
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, String> tags = new HashMap<String, String>();
    private String connectorName = "BallerinaConnector";
    private String actionName = "BallerinaAction";
    private ObserverContext observerContext = null;
    private Span span;

    public BSpan(ObserverContext observerContext, boolean isClientContext) {
        this.observerContext = observerContext;
        this.tags.put("span.kind", isClientContext ? "client" : "server");
    }

    public void startSpan() {
        manager.startSpan(this.getParentBSpan(), this);
    }

    public void finishSpan() {
        manager.finishSpan(this);
    }

    public void log(Map<String, Object> fields) {
        manager.log(this, fields);
    }

    public void logError(Map<String, Object> fields) {
        this.addTags(Collections.singletonMap("error", "true"));
        manager.log(this, fields);
    }

    public void addTags(Map<String, String> tags) {
        if (this.span != null) {
            manager.addTags(this, tags);
        } else {
            this.tags.putAll(tags);
        }
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        if (this.properties != null) {
            this.properties.put(key, value);
        }
    }

    public String getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Span getSpan() {
        return this.span;
    }

    public void setSpan(Span span) {
        this.span = span;
    }

    public Map<String, String> getTraceContext() {
        return manager.extractTraceContext(this.span, this.connectorName);
    }

    private BSpan getParentBSpan() {
        if (this.observerContext.getParent() != null) {
            return (BSpan)this.observerContext.getParent().getProperty("_span_");
        }
        return null;
    }
}

