/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.scheduling;

import java.util.function.Consumer;
import java.util.function.Function;
import org.ballerinalang.jvm.scheduling.State;
import org.ballerinalang.jvm.values.FutureValue;

class SchedulerItem {
    private Function function;
    private Object[] params;
    final FutureValue future;
    boolean parked;

    public SchedulerItem(Function function, Object[] params, FutureValue future) {
        this.future = future;
        this.function = function;
        this.params = params;
    }

    @Deprecated
    public SchedulerItem(Consumer consumer, Object[] params, FutureValue future) {
        this.future = future;
        this.function = val -> {
            consumer.accept(val);
            return null;
        };
        this.params = params;
    }

    public Object execute() {
        return this.function.apply(this.params);
    }

    public boolean isYielded() {
        return this.future.strand.isYielded();
    }

    public State getState() {
        return this.future.strand.getState();
    }

    public void setState(State state) {
        this.future.strand.setState(state);
    }

    public String toString() {
        return this.future == null ? "POISON_PILL" : String.valueOf(this.future.strand.hashCode());
    }
}

