/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.scheduling;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ballerinalang.jvm.scheduling.State;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ErrorValue;

public class WorkerDataChannel {
    private Strand receiver;
    private WaitingSender waitingSender;
    private WaitingSender flushSender;
    private ErrorValue error;
    private Throwable panic;
    private int senderCounter = 0;
    private int receiverCounter = 0;
    private boolean reschedule;
    private Lock channelLock;
    public String chnlName;
    private Queue<WorkerResult> channel = new LinkedList<WorkerResult>();

    public WorkerDataChannel() {
        this.channelLock = new ReentrantLock();
    }

    public WorkerDataChannel(String channelName) {
        this.channelLock = new ReentrantLock();
        this.chnlName = channelName;
    }

    public void acquireChannelLock() {
        this.channelLock.lock();
    }

    public void releaseChannelLock() {
        this.channelLock.unlock();
    }

    public void sendData(Object data, Strand sender) {
        try {
            this.acquireChannelLock();
            this.channel.add(new WorkerResult(data));
            ++this.senderCounter;
            if (this.receiver != null) {
                this.receiver.scheduler.unblockStrand(this.receiver);
                this.receiver = null;
            }
        }
        finally {
            this.releaseChannelLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object syncSendData(Object data, Strand strand) throws Throwable {
        try {
            this.acquireChannelLock();
            if (!this.reschedule) {
                this.channel.add(new WorkerResult(data, true));
                ++this.senderCounter;
                this.waitingSender = new WaitingSender(strand, -1);
                if (this.receiver != null) {
                    this.receiver.scheduler.unblockStrand(this.receiver);
                    this.receiver = null;
                } else {
                    if (this.panic != null) {
                        Throwable panic = this.panic;
                        this.panic = null;
                        throw panic;
                    }
                    if (this.error != null) {
                        ErrorValue ret;
                        ErrorValue errorValue = ret = this.error;
                        return errorValue;
                    }
                }
                this.reschedule = true;
                strand.setState(State.BLOCK_AND_YIELD);
                Object ret = null;
                return ret;
            }
            this.reschedule = false;
            if (this.panic != null && this.channel.peek() != null) {
                Throwable e = this.panic;
                throw e;
            }
            if (this.error != null && this.channel.peek() != null) {
                ErrorValue ret;
                ErrorValue errorValue = ret = this.error;
                return errorValue;
            }
            Object var3_8 = null;
            return var3_8;
        }
        finally {
            this.releaseChannelLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object tryTakeData(Strand strand) throws Throwable {
        try {
            this.acquireChannelLock();
            WorkerResult result = this.channel.peek();
            if (result != null) {
                ++this.receiverCounter;
                this.channel.remove();
                if (result.isSync) {
                    Strand waiting = this.waitingSender.waitingStrand;
                    waiting.scheduler.unblockStrand(waiting);
                    this.waitingSender = null;
                } else if (this.flushSender != null && this.flushSender.flushCount == this.receiverCounter) {
                    this.flushSender.waitingStrand.flushDetail.flushLock.lock();
                    ++this.flushSender.waitingStrand.flushDetail.flushedCount;
                    if (this.flushSender.waitingStrand.flushDetail.flushedCount == this.flushSender.waitingStrand.flushDetail.flushChannels.length && this.flushSender.waitingStrand.isBlocked()) {
                        this.flushSender.waitingStrand.scheduler.unblockStrand(this.flushSender.waitingStrand);
                    }
                    this.flushSender.waitingStrand.flushDetail.flushLock.unlock();
                    this.flushSender = null;
                }
                Object object = result.value;
                return object;
            }
            if (this.panic != null && this.senderCounter == this.receiverCounter + 1) {
                ++this.receiverCounter;
                throw this.panic;
            }
            if (this.error != null && this.senderCounter == this.receiverCounter + 1) {
                ++this.receiverCounter;
                ErrorValue errorValue = this.error;
                return errorValue;
            }
            this.receiver = strand;
            strand.setState(State.BLOCK_AND_YIELD);
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            this.releaseChannelLock();
        }
    }

    public void setSendError(ErrorValue error) {
        this.acquireChannelLock();
        this.error = error;
        ++this.senderCounter;
        if (this.receiver != null) {
            this.receiver.scheduler.unblockStrand(this.receiver);
            this.receiver = null;
        }
        this.releaseChannelLock();
    }

    public void setReceiveError(ErrorValue error) {
        this.acquireChannelLock();
        this.error = error;
        ++this.receiverCounter;
        if (this.flushSender != null) {
            this.flushSender.waitingStrand.flushDetail.flushLock.lock();
            Strand flushStrand = this.flushSender.waitingStrand;
            if (flushStrand.isBlocked()) {
                flushStrand.flushDetail.result = error;
                flushStrand.scheduler.unblockStrand(flushStrand);
            }
            this.flushSender.waitingStrand.flushDetail.flushLock.unlock();
            this.flushSender = null;
        } else if (this.waitingSender != null) {
            Strand waiting = this.waitingSender.waitingStrand;
            waiting.scheduler.unblockStrand(waiting);
            this.waitingSender = null;
        }
        this.releaseChannelLock();
    }

    public ErrorValue flushChannel(Strand strand) throws Throwable {
        this.acquireChannelLock();
        try {
            if (this.panic != null) {
                throw this.panic;
            }
            if (this.error != null) {
                ErrorValue errorValue = this.error;
                return errorValue;
            }
            if (this.receiverCounter == this.senderCounter) {
                strand.flushDetail.flushLock.lock();
                ++strand.flushDetail.flushedCount;
                strand.flushDetail.flushLock.unlock();
                ErrorValue errorValue = null;
                return errorValue;
            }
            this.flushSender = new WaitingSender(strand, this.senderCounter);
            ErrorValue errorValue = null;
            return errorValue;
        }
        finally {
            this.releaseChannelLock();
        }
    }

    public void removeFlushWait() {
        this.acquireChannelLock();
        this.flushSender = null;
        this.releaseChannelLock();
    }

    public void setSendPanic(Throwable panic) {
        try {
            this.acquireChannelLock();
            this.panic = panic;
            ++this.senderCounter;
            if (this.receiver != null) {
                this.receiver.scheduler.unblockStrand(this.receiver);
                this.receiver = null;
            }
        }
        finally {
            this.releaseChannelLock();
        }
    }

    public void setReceiverPanic(Throwable panic) {
        this.acquireChannelLock();
        this.panic = panic;
        ++this.receiverCounter;
        if (this.flushSender != null) {
            this.flushSender.waitingStrand.flushDetail.flushLock.lock();
            Strand flushStrand = this.flushSender.waitingStrand;
            this.flushSender.waitingStrand.flushDetail.panic = panic;
            if (flushStrand.isBlocked()) {
                flushStrand.scheduler.unblockStrand(flushStrand);
            }
            this.flushSender.waitingStrand.flushDetail.flushLock.unlock();
            this.flushSender = null;
        } else if (this.waitingSender != null) {
            Strand waiting = this.waitingSender.waitingStrand;
            waiting.scheduler.unblockStrand(waiting);
            this.waitingSender = null;
        }
        this.releaseChannelLock();
    }

    public static class WaitingSender {
        public Strand waitingStrand;
        public int flushCount;

        public WaitingSender(Strand strand, int flushCount) {
            this.waitingStrand = strand;
            this.flushCount = flushCount;
        }
    }

    public static class WorkerResult {
        public Object value;
        public boolean isSync;

        public WorkerResult(Object value) {
            this.value = value;
        }

        public WorkerResult(Object value, boolean sync) {
            this.value = value;
            this.isSync = sync;
        }
    }
}

