/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import org.ballerinalang.jvm.types.AnnotatableType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ErrorValue;

public class BErrorType
extends AnnotatableType {
    public BType reasonType;
    public BType detailType;

    public BErrorType(String typeName, BPackage pkg, BType reasonType, BType detailType) {
        super(typeName, pkg, ErrorValue.class);
        this.reasonType = reasonType;
        this.detailType = detailType;
    }

    public BErrorType(String typeName, BPackage pkg, BType reasonType) {
        super(typeName, pkg, ErrorValue.class);
        this.reasonType = reasonType;
    }

    public BErrorType(BType reasonType) {
        super("error", (BPackage)null, ErrorValue.class);
        this.reasonType = reasonType;
        this.detailType = this.detailType;
    }

    @Override
    public <V> V getZeroValue() {
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 29;
    }

    public void setDetailType(BType detailType) {
        this.detailType = detailType;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BErrorType)) {
            return false;
        }
        BErrorType other = (BErrorType)obj;
        if (this.reasonType == other.reasonType && this.detailType == other.detailType) {
            return true;
        }
        return this.reasonType.equals(other.reasonType) && this.detailType.equals(other.detailType);
    }

    @Override
    public String getAnnotationKey() {
        return this.typeName;
    }

    public BType getDetailType() {
        return this.detailType;
    }
}

