/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Objects;

public class BPackage {
    public String org;
    public String name;
    public String version;
    private int hashCode;

    public BPackage(String org, String name, String version) {
        this.hashCode = Objects.hash(this.org, this.name, this.version);
        this.org = org;
        this.name = name;
        this.version = version;
    }

    public BPackage(String org, String name) {
        this.hashCode = Objects.hash(this.org, this.name, this.version);
        this.org = org;
        this.name = name;
        this.version = "";
    }

    public String getOrg() {
        return this.org;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BPackage bPackage = (BPackage)o;
        return Objects.equals(this.org, bPackage.org) && Objects.equals(this.name, bPackage.name) && Objects.equals(this.version, bPackage.version);
    }

    public String toString() {
        if (".".equals(this.name)) {
            return this.name;
        }
        String orgName = "";
        if (this.org != null && !this.org.equals("$anon")) {
            orgName = this.org + "/";
        }
        if (this.version == null || this.version.equals("")) {
            return orgName + this.name;
        }
        return orgName + this.name + ":" + this.version;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

