/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Objects;
import org.ballerinalang.jvm.types.BPackage;

public abstract class BType {
    protected String typeName;
    protected BPackage pkg;
    protected Class<? extends Object> valueClass;
    private int hashCode;

    protected BType(String typeName, BPackage pkg, Class<? extends Object> valueClass) {
        this.typeName = typeName;
        this.pkg = pkg;
        this.valueClass = valueClass;
        if (pkg != null && typeName != null) {
            this.hashCode = Objects.hash(pkg, typeName);
        }
    }

    public <V> Class<V> getValueClass() {
        return this.valueClass;
    }

    public abstract <V> V getZeroValue();

    public abstract <V> V getEmptyValue();

    public abstract int getTag();

    public String toString() {
        return this.pkg == null || this.pkg.getName() == null || this.pkg.getName().equals(".") ? this.typeName : this.pkg.getName() + ":" + this.typeName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BType) {
            BType other = (BType)obj;
            boolean namesEqual = this.typeName.equals(other.getName());
            if (this.pkg == null || other.pkg == null) {
                return namesEqual;
            }
            String thisPkgName = this.pkg.getName();
            String otherPkgName = other.pkg.getName();
            if (otherPkgName == null) {
                if (thisPkgName == null) {
                    return namesEqual;
                }
            } else if (thisPkgName != null) {
                return namesEqual && thisPkgName.equals(otherPkgName);
            }
        }
        return false;
    }

    public boolean isNilable() {
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getName() {
        return this.typeName;
    }

    public String getQualifiedName() {
        return this.pkg == null ? this.typeName : this.pkg.toString() + ":" + this.typeName;
    }

    public BPackage getPackage() {
        return this.pkg;
    }

    public boolean isPublic() {
        return false;
    }

    public boolean isNative() {
        return false;
    }

    public boolean isAnydata() {
        return this.getTag() <= 11;
    }

    public boolean isPureType() {
        return this.getTag() == 29 || this.isAnydata();
    }
}

