/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.Flags;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.StringValue;
import org.ballerinalang.jvm.values.api.BString;

public abstract class AbstractObjectValue
implements ObjectValue {
    private BObjectType type;
    private final HashMap<String, Object> nativeData = new HashMap();

    public AbstractObjectValue(BObjectType type) {
        this.type = type;
    }

    @Override
    public abstract Object call(Strand var1, String var2, Object ... var3);

    @Override
    public abstract Object get(String var1);

    @Override
    public abstract Object get(StringValue var1);

    @Override
    public abstract Object get(BString var1);

    @Override
    public abstract void set(String var1, Object var2);

    @Override
    public abstract void set(StringValue var1, Object var2);

    @Override
    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    @Override
    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    @Override
    public HashMap<String, Object> getNativeData() {
        return this.nativeData;
    }

    @Override
    public long getIntValue(String fieldName) {
        return (Long)this.get(fieldName);
    }

    @Override
    public double getFloatValue(String fieldName) {
        return (Double)this.get(fieldName);
    }

    @Override
    public String getStringValue(String fieldName) {
        return (String)this.get(fieldName);
    }

    @Override
    public String stringValue() {
        return "object " + this.type.toString();
    }

    @Override
    public boolean getBooleanValue(String fieldName) {
        return (Boolean)this.get(fieldName);
    }

    @Override
    public MapValueImpl getMapValue(String fieldName) {
        return (MapValueImpl)this.get(fieldName);
    }

    @Override
    public ObjectValue getObjectValue(String fieldName) {
        return (ObjectValue)this.get(fieldName);
    }

    @Override
    public ArrayValue getArrayValue(String fieldName) {
        return (ArrayValue)this.get(fieldName);
    }

    @Override
    public BObjectType getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        for (Map.Entry<String, BField> field : this.type.getFields().entrySet()) {
            if (!Flags.isFlagOn(field.getValue().flags, 1)) continue;
            String fieldName = field.getKey();
            sj.add(fieldName + ":" + this.getStringValue(this.get(fieldName)));
        }
        return sj.toString();
    }

    private String getStringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "\"" + value.toString() + "\"";
        }
        return value.toString();
    }

    protected void checkFieldUpdate(String fieldName, Object value) {
        BType fieldType = this.type.getFields().get((Object)fieldName).type;
        if (TypeChecker.checkIsType(value, fieldType)) {
            return;
        }
        throw BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.object", "InherentTypeViolation"), "invalid value for object field '" + fieldName + "': expected value of type '" + fieldType + "', found '" + TypeChecker.getType(value) + "'");
    }
}

