/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Arrays;
import org.ballerinalang.jvm.values.BmpStringValue;
import org.ballerinalang.jvm.values.StringValue;
import org.ballerinalang.jvm.values.api.BString;

public class NonBmpStringValue
implements StringValue {
    private final String value;
    private final int[] surrogates;

    public NonBmpStringValue(String value, int[] surrogatePairLocations) {
        this.value = value;
        this.surrogates = surrogatePairLocations;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getCodePoint(int index) {
        if (index < 0 || index >= this.value.length() - this.surrogates.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        int offset = index;
        for (int surrogate : this.surrogates) {
            if (surrogate < index) {
                ++offset;
                continue;
            }
            if (surrogate > index) break;
            return Character.toCodePoint(this.value.charAt(offset), this.value.charAt(offset + 1));
        }
        return this.value.charAt(offset);
    }

    @Override
    public int length() {
        return this.value.length() - this.surrogates.length;
    }

    @Override
    public BString concat(BString str) {
        if (str instanceof NonBmpStringValue) {
            NonBmpStringValue other = (NonBmpStringValue)str;
            int[] both = Arrays.copyOf(this.surrogates, this.surrogates.length + other.surrogates.length);
            System.arraycopy(other.surrogates, 0, both, this.surrogates.length, other.surrogates.length);
            return new NonBmpStringValue(this.value + other.value, both);
        }
        if (str instanceof BmpStringValue) {
            BmpStringValue other = (BmpStringValue)str;
            return new NonBmpStringValue(this.value + other.getValue(), this.surrogates);
        }
        throw new RuntimeException("not impl yet");
    }

    @Override
    public String stringValue() {
        return this.value;
    }

    @Override
    public BString bStringValue() {
        return null;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

