/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.Map;
import java.util.UUID;
import org.ballerinalang.jvm.IteratorUtils;
import org.ballerinalang.jvm.types.BStreamType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.api.BStream;
import org.ballerinalang.jvm.values.api.BString;

public class StreamValue
implements RefValue,
BStream {
    private BType type;
    private BType constraintType;
    private BType iteratorNextReturnType;
    private ObjectValue iteratorObj;
    public String streamId;

    @Deprecated
    public StreamValue(BType type) {
        this.constraintType = ((BStreamType)type).getConstrainedType();
        this.type = new BStreamType(this.constraintType);
        this.streamId = UUID.randomUUID().toString();
        this.iteratorObj = null;
    }

    public StreamValue(BType type, ObjectValue iteratorObj) {
        this.constraintType = ((BStreamType)type).getConstrainedType();
        this.type = new BStreamType(this.constraintType);
        this.streamId = UUID.randomUUID().toString();
        this.iteratorObj = iteratorObj;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public ObjectValue getIteratorObj() {
        return this.iteratorObj;
    }

    public BType getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(this.constraintType);
        }
        return this.iteratorNextReturnType;
    }

    @Override
    public String stringValue() {
        return "stream <" + this.getType().toString() + ">";
    }

    @Override
    public BString bStringValue() {
        return null;
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BType getConstraintType() {
        return this.constraintType;
    }

    public String toString() {
        return this.stringValue();
    }
}

