/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.ColumnDefinition;
import org.ballerinalang.jvm.DataIterator;
import org.ballerinalang.jvm.IteratorUtils;
import org.ballerinalang.jvm.TableProvider;
import org.ballerinalang.jvm.TableUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BFunctionType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BTableType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.StringValue;
import org.ballerinalang.jvm.values.TableIterator;
import org.ballerinalang.jvm.values.api.BFunctionPointer;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BTable;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public class TableValue
implements RefValue,
BTable {
    protected DataIterator iterator;
    private boolean hasNextVal;
    private boolean nextPrefetched;
    private TableProvider tableProvider;
    private String tableName;
    private BStructureType constraintType;
    private ArrayValue primaryKeys;
    private boolean tableClosed;
    private volatile Status freezeStatus = new Status(State.UNFROZEN);
    private BType type;
    private BType iteratorNextReturnType;

    @Deprecated
    public TableValue() {
        this.iterator = null;
        this.tableProvider = null;
        this.nextPrefetched = false;
        this.hasNextVal = false;
        this.tableName = null;
        this.type = BTypes.typeTable;
    }

    @Deprecated
    public TableValue(String tableName, BStructureType constraintType) {
        this(constraintType);
        this.tableName = tableName;
    }

    @Deprecated
    public TableValue(BStructureType constraintType) {
        this.nextPrefetched = false;
        this.hasNextVal = false;
        this.constraintType = constraintType;
        this.type = new BTableType(constraintType);
    }

    @Deprecated
    public TableValue(String query, TableValue fromTable, TableValue joinTable, BStructureType constraintType, ArrayValue params) {
        this.tableProvider = TableProvider.getInstance();
        if (!fromTable.isInMemoryTable()) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Table query over a cursor table not supported");
        }
        if (joinTable != null) {
            if (!joinTable.isInMemoryTable()) {
                throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Table query over a cursor table not supported");
            }
            this.tableName = this.tableProvider.createTable(fromTable.tableName, joinTable.tableName, query, constraintType, params);
        } else {
            this.tableName = this.tableProvider.createTable(fromTable.tableName, query, constraintType, params);
        }
        this.constraintType = constraintType;
        this.type = new BTableType(constraintType);
    }

    @Deprecated
    public TableValue(BType type, ArrayValue keyColumns, ArrayValue dataRows) {
        BType constrainedType = ((BTableType)type).getConstrainedType();
        this.tableProvider = TableProvider.getInstance();
        this.tableName = this.tableProvider.createTable(constrainedType, keyColumns);
        this.constraintType = (BStructureType)constrainedType;
        this.type = new BTableType(this.constraintType);
        this.primaryKeys = keyColumns;
        if (dataRows != null) {
            this.insertInitialData(dataRows);
        }
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public String stringValue() {
        return this.createStringValueDataEntry();
    }

    @Override
    public BString bStringValue() {
        return null;
    }

    private String createStringValueDataEntry() {
        StringJoiner sj = new StringJoiner(" ");
        while (this.hasNext()) {
            BMap struct = this.getNext();
            sj.add(((MapValueImpl)struct).stringValue());
        }
        return sj.toString();
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        if (this.tableClosed) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Trying to perform hasNext operation over a closed table");
        }
        if (this.isIteratorGenerationConditionMet()) {
            this.generateIterator();
        }
        if (!this.nextPrefetched) {
            this.hasNextVal = this.iterator.next();
            this.nextPrefetched = true;
        }
        if (!this.hasNextVal) {
            this.reset();
        }
        return this.hasNextVal;
    }

    @Override
    public void moveToNext() {
        if (this.tableClosed) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_CLOSED_ERROR, "Trying to perform an operation over a closed table");
        }
        if (this.isIteratorGenerationConditionMet()) {
            this.generateIterator();
        }
        if (!this.nextPrefetched) {
            this.iterator.next();
        } else {
            this.nextPrefetched = false;
        }
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.tableClosed = true;
    }

    @Override
    public void reset() {
        if (this.iterator != null) {
            this.iterator.reset();
            this.iterator = null;
        }
        this.resetIterationHelperAttributes();
    }

    public MapValueImpl<String, Object> getNext() {
        this.moveToNext();
        return (MapValueImpl)this.iterator.generateNext();
    }

    @Override
    public Object performAddOperation(BMap<String, Object> data) {
        return this.performAddOperation((MapValueImpl)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object performAddOperation(MapValueImpl<String, Object> data) {
        TableValue tableValue = this;
        synchronized (tableValue) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.table");
            }
        }
        try {
            this.addData(data);
            return null;
        }
        catch (ErrorValue e) {
            return e;
        }
        catch (Throwable e) {
            return TableUtils.createTableOperationError(e);
        }
    }

    public void addData(MapValueImpl<String, Object> data) {
        if (data.getType() != this.constraintType) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "incompatible types: record of type:" + data.getType().getName() + " cannot be added to a table with type:" + this.constraintType.getName());
        }
        this.tableProvider.insertData(this.tableName, data);
        this.reset();
    }

    @Override
    public void addData(BMap<String, Object> data) {
        this.addData((MapValueImpl)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object performRemoveOperation(Strand strand, FPValue<Object, Boolean> func) {
        TableValue tableValue = this;
        synchronized (tableValue) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.table");
            }
        }
        if (((BFunctionType)func.type).paramTypes[0] != this.constraintType) {
            return TableUtils.createTableOperationError(new Exception("incompatible types: function with record type:" + ((BFunctionType)func.type).paramTypes[0].getName() + " cannot be used to remove records from a table with type:" + this.constraintType.getName()));
        }
        int deletedCount = 0;
        while (this.hasNext()) {
            BMap row = this.getNext();
            if (!func.call(new Object[]{strand, row, true}).booleanValue()) continue;
            this.tableProvider.deleteData(this.tableName, (MapValueImpl<String, Object>)row);
            ++deletedCount;
        }
        return deletedCount;
    }

    @Override
    public Object performRemoveOperation(Strand strand, BFunctionPointer<Object, Boolean> func) {
        return this.performRemoveOperation(strand, (FPValue)func);
    }

    @Override
    public String getString(int columnIndex) {
        return this.iterator.getString(columnIndex);
    }

    @Override
    public Long getInt(int columnIndex) {
        return this.iterator.getInt(columnIndex);
    }

    @Override
    public Double getFloat(int columnIndex) {
        return this.iterator.getFloat(columnIndex);
    }

    @Override
    public Boolean getBoolean(int columnIndex) {
        return this.iterator.getBoolean(columnIndex);
    }

    @Override
    public String getBlob(int columnIndex) {
        return this.iterator.getBlob(columnIndex);
    }

    @Override
    public Object[] getStruct(int columnIndex) {
        return this.iterator.getStruct(columnIndex);
    }

    @Override
    public Object[] getArray(int columnIndex) {
        return this.iterator.getArray(columnIndex);
    }

    @Override
    public DecimalValue getDecimal(int columnIndex) {
        return this.iterator.getDecimal(columnIndex);
    }

    @Override
    public List<ColumnDefinition> getColumnDefs() {
        return this.iterator.getColumnDefinitions();
    }

    @Override
    public BStructureType getStructType() {
        return this.iterator.getStructType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.tableClosed) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.TABLE_OPERATION_ERROR, "Trying to invoke clone built-in method over a closed table");
        }
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        TableIterator cloneIterator = this.tableProvider.createIterator(this.tableName, this.constraintType);
        ArrayValueImpl data = new ArrayValueImpl(new BArrayType(this.constraintType));
        int cursor = 0;
        try {
            while (cloneIterator.next()) {
                data.add((long)cursor++, cloneIterator.generateNext());
            }
            TableValue table = new TableValue(new BTableType(this.constraintType), this.primaryKeys, data);
            refs.put(this, table);
            TableValue tableValue = table;
            return tableValue;
        }
        finally {
            cloneIterator.close();
        }
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        TableValue copy = (TableValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    public IteratorValue getIterator() {
        return new TableValueIterator(this);
    }

    private void generateIterator() {
        this.iterator = this.tableProvider.createIterator(this.tableName, this.constraintType);
        this.resetIterationHelperAttributes();
    }

    protected boolean isIteratorGenerationConditionMet() {
        return this.iterator == null;
    }

    protected void resetIterationHelperAttributes() {
        this.nextPrefetched = false;
        this.hasNextVal = false;
    }

    public void finalize() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.tableProvider.dropTable(this.tableName);
    }

    private void insertInitialData(ArrayValue data) {
        int count = data.size();
        for (int i = 0; i < count; ++i) {
            this.addData((MapValueImpl)data.getRefValue(i));
        }
    }

    @Override
    public boolean isInMemoryTable() {
        return true;
    }

    @Override
    public ArrayValue getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public synchronized boolean isFrozen() {
        return this.freezeStatus.isFrozen();
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            this.freezeStatus = freezeStatus;
        }
    }

    @Override
    public void freezeDirect() {
        this.freezeStatus.setFrozen();
    }

    public BType getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(this.constraintType);
        }
        return this.iteratorNextReturnType;
    }

    private static class TableValueIterator
    implements IteratorValue {
        private TableValue table;

        TableValueIterator(TableValue value) {
            this.table = value;
        }

        @Override
        public boolean hasNext() {
            return this.table.hasNext();
        }

        public Object next() {
            if (this.hasNext()) {
                return this.table.getNext();
            }
            return null;
        }

        @Override
        public StringValue bStringValue() {
            return null;
        }
    }
}

