/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.BLangConstants;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.XMLText;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BXML;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public final class XMLSequence
extends XMLValue {
    List<BXML> children;

    public XMLSequence() {
        this.children = new ArrayList<BXML>();
    }

    public XMLSequence(List<BXML> children) {
        this.children = children;
    }

    public XMLSequence(BXML child) {
        this.children = new ArrayList<BXML>();
        this.children.add(child);
    }

    public List<BXML> getChildrenList() {
        return this.children;
    }

    @Override
    public XMLNodeType getNodeType() {
        return XMLNodeType.SEQUENCE;
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean isSingleton() {
        return this.children.size() == 1 && this.children.get(0).isSingleton();
    }

    @Override
    public String getItemType() {
        if (this.isSingleton()) {
            return this.children.get(0).getItemType();
        }
        return XMLNodeType.SEQUENCE.value();
    }

    @Override
    public String getElementName() {
        if (this.isSingleton()) {
            return this.children.get(0).getElementName();
        }
        return "";
    }

    @Override
    public String getTextValue() {
        StringBuilder seqTextBuilder = new StringBuilder();
        for (BXML x : this.children) {
            if (x.getNodeType() != XMLNodeType.ELEMENT && x.getNodeType() != XMLNodeType.TEXT) continue;
            seqTextBuilder.append(x.getTextValue());
        }
        return seqTextBuilder.toString();
    }

    @Override
    public String getAttribute(String localName, String namespace) {
        if (this.isSingleton()) {
            return this.children.get(0).getAttribute(localName, namespace);
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    @Override
    public String getAttribute(String localName, String namespace, String prefix) {
        if (this.isSingleton()) {
            return this.children.get(0).getAttribute(localName, namespace, prefix);
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    @Override
    public void setAttribute(String localName, String namespace, String prefix, String value) {
        if (this.isSingleton()) {
            this.children.get(0).setAttribute(localName, namespace, prefix, value);
        }
    }

    @Override
    public MapValue<String, String> getAttributesMap() {
        if (this.isSingleton()) {
            return (MapValue)this.children.get(0).getAttributesMap();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(BMap<String, ?> attributes) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.isSingleton()) {
            this.children.get(0).setAttributes(attributes);
        }
    }

    @Override
    public XMLValue elements() {
        ArrayList<BXML> elementsSeq = new ArrayList<BXML>();
        for (BXML child : this.children) {
            if (child.getNodeType() != XMLNodeType.ELEMENT) continue;
            elementsSeq.add(child);
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue elements(String qname) {
        ArrayList<BXML> elementsSeq = new ArrayList<BXML>();
        String qnameStr = this.getQname(qname).toString();
        for (BXML child : this.children) {
            if (child.getNodeType() != XMLNodeType.ELEMENT || !child.getElementName().equals(qnameStr)) continue;
            elementsSeq.add(child);
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue children() {
        if (this.children.size() == 1) {
            return (XMLValue)this.children.get(0).children();
        }
        return new XMLSequence(new ArrayList<BXML>(this.children));
    }

    @Override
    public XMLValue children(String qname) {
        ArrayList<BXML> selected = new ArrayList<BXML>();
        if (this.children.size() == 1) {
            BXML bxml = this.children.get(0);
            return (XMLValue)bxml.children(qname);
        }
        for (BXML elem : this.children) {
            XMLSequence elements = (XMLSequence)elem.children().elements(qname);
            List<BXML> childrenList = elements.getChildrenList();
            if (childrenList.size() == 1) {
                selected.add(childrenList.get(0));
                continue;
            }
            if (childrenList.size() <= 1) continue;
            selected.addAll(childrenList);
        }
        if (selected.size() == 1) {
            return (XMLValue)selected.get(0);
        }
        return new XMLSequence(selected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChildren(BXML seq) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.children.size() != 1) {
            throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        this.children.get(0).setChildren(seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void addChildren(BXML seq) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.children.size() != 1) {
            throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        this.children.get(0).addChildren(seq);
    }

    @Override
    public XMLValue strip() {
        ArrayList<BXML> elementsSeq = new ArrayList<BXML>();
        boolean prevChildWasATextNode = false;
        String prevConsecutiveText = null;
        for (BXML x : this.children) {
            XMLValue item = (XMLValue)x;
            if (item.getNodeType() == XMLNodeType.TEXT) {
                prevConsecutiveText = prevChildWasATextNode ? prevConsecutiveText + x.getTextValue() : x.getTextValue();
                prevChildWasATextNode = true;
                continue;
            }
            if (item.getNodeType() != XMLNodeType.ELEMENT) continue;
            if (prevChildWasATextNode && !prevConsecutiveText.trim().isEmpty()) {
                elementsSeq.add(new XMLText(prevConsecutiveText));
                prevConsecutiveText = null;
            }
            prevChildWasATextNode = false;
            elementsSeq.add(x);
        }
        if (prevChildWasATextNode && !prevConsecutiveText.trim().isEmpty()) {
            elementsSeq.add(new XMLText(prevConsecutiveText));
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue slice(long startIndex, long endIndex) {
        if (startIndex > (long)this.children.size() || endIndex > (long)this.children.size() || startIndex < -1L || endIndex < -1L) {
            throw BallerinaErrors.createError("index out of range: [" + startIndex + "," + endIndex + "]");
        }
        if (startIndex == -1L) {
            startIndex = 0L;
        }
        if (endIndex == -1L) {
            endIndex = this.children.size();
        }
        if (startIndex == endIndex) {
            return new XMLSequence();
        }
        if (startIndex > endIndex) {
            throw BallerinaErrors.createError("invalid indices: " + startIndex + " < " + endIndex);
        }
        int j = 0;
        ArrayList<BXML> elementsSeq = new ArrayList<BXML>();
        int i = (int)startIndex;
        while ((long)i < endIndex) {
            elementsSeq.add(j++, this.children.get(i));
            ++i;
        }
        return new XMLSequence(elementsSeq);
    }

    @Override
    public XMLValue descendants(List<String> qnames) {
        ArrayList<BXML> descendants = new ArrayList<BXML>();
        for (BXML child : this.children) {
            if (child.getNodeType() != XMLNodeType.ELEMENT) continue;
            XMLItem element = (XMLItem)child;
            String name = element.getQName().toString();
            if (qnames.contains(name)) {
                descendants.add(element);
            }
            this.addDescendants(descendants, element, qnames);
        }
        return new XMLSequence(descendants);
    }

    @Override
    public Object value() {
        BArrayType bArrayType = new BArrayType(BTypes.typeXML);
        return new ArrayValueImpl(this.children.toArray(), bArrayType);
    }

    public String toString() {
        try {
            return this.stringValue();
        }
        catch (Throwable t) {
            XMLSequence.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public String stringValue() {
        try {
            StringBuilder sb = new StringBuilder();
            for (BXML child : this.children) {
                sb.append(child.stringValue());
            }
            return sb.toString();
        }
        catch (Throwable t) {
            XMLSequence.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public BString bStringValue() {
        return null;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        ArrayList<BXML> copiedChildrenList = new ArrayList<BXML>(this.children.size());
        XMLSequence copiedSeq = new XMLSequence(copiedChildrenList);
        refs.put(this, copiedSeq);
        for (BXML child : this.children) {
            copiedChildrenList.add((XMLValue)child.copy(refs));
        }
        return copiedSeq;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        XMLSequence copy = (XMLSequence)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public XMLValue getItem(int index) {
        try {
            if (index >= this.children.size()) {
                return new XMLSequence();
            }
            return (XMLValue)this.children.get(index);
        }
        catch (Exception e) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, e.getMessage());
        }
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public void build() {
        for (BXML child : this.children) {
            child.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String qname) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.children.size() != 1) {
            throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        this.children.get(0).removeAttribute(qname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void removeChildren(String qname) {
        XMLSequence xMLSequence = this;
        synchronized (xMLSequence) {
            if (this.freezeStatus.getState() != State.UNFROZEN) {
                FreezeUtils.handleInvalidUpdate(this.freezeStatus.getState(), "lang.xml");
            }
        }
        if (this.children.size() != 1) {
            throw BallerinaErrors.createError("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        this.children.get(0).removeChildren(qname);
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            this.freezeStatus = freezeStatus;
            for (BXML elem : this.children) {
                elem.attemptFreeze(freezeStatus);
            }
        }
    }

    @Override
    public void freezeDirect() {
        this.freezeStatus.setFrozen();
        for (BXML elem : this.children) {
            elem.freezeDirect();
        }
    }

    @Override
    public synchronized boolean isFrozen() {
        if (this.freezeStatus.isFrozen()) {
            return true;
        }
        for (BXML child : this.children) {
            if (child.isFrozen()) continue;
            return false;
        }
        this.freezeStatus.setFrozen();
        return true;
    }

    @Override
    public IteratorValue getIterator() {
        return new IteratorValue(){
            Iterator<BXML> iterator;
            {
                this.iterator = XMLSequence.this.children.iterator();
            }

            @Override
            public BString bStringValue() {
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public Object next() {
                return this.iterator.next();
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XMLSequence) {
            XMLSequence that = (XMLSequence)obj;
            return that.children.equals(this.children);
        }
        if (obj instanceof XMLItem) {
            return this.children.size() == 1 && this.children.get(0).equals(obj);
        }
        return false;
    }
}

