/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ballerinalang.jvm.BallerinaXMLSerializer;
import org.ballerinalang.jvm.XMLNodeType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.CollectionValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.XMLItem;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.api.BXML;
import org.ballerinalang.jvm.values.api.BXMLQName;
import org.ballerinalang.jvm.values.freeze.State;
import org.ballerinalang.jvm.values.freeze.Status;

public abstract class XMLValue
implements RefValue,
BXML,
CollectionValue {
    BType type = BTypes.typeXML;
    protected volatile Status freezeStatus = new Status(State.UNFROZEN);

    @Override
    public abstract int size();

    @Override
    public String getAttribute(BXMLQName attributeName) {
        return this.getAttribute(attributeName.getLocalName(), attributeName.getUri(), attributeName.getPrefix());
    }

    @Override
    @Deprecated
    public void setAttribute(BXMLQName attributeName, String value) {
        this.setAttribute(attributeName.getLocalName(), attributeName.getUri(), attributeName.getPrefix(), value);
    }

    public void setAttribute(BXMLQName attributeName, BString value) {
        this.setAttribute(attributeName.getLocalName(), attributeName.getUri(), attributeName.getPrefix(), value.getValue());
    }

    public abstract MapValue<String, ?> getAttributesMap();

    @Override
    public abstract void setAttributes(BMap<String, ?> var1);

    @Override
    public abstract XMLNodeType getNodeType();

    @Override
    public abstract void build();

    @Override
    public BType getType() {
        return this.type;
    }

    protected static void handleXmlException(String message, Throwable t) {
        if (t.getCause() != null) {
            throw new BallerinaException(message + t.getCause().getMessage());
        }
        throw new BallerinaException(message + t.getMessage());
    }

    protected QName getQname(String qname) {
        String nsUri;
        String localname;
        int rParenIndex = qname.indexOf(125);
        if (qname.startsWith("{") && rParenIndex > 0) {
            localname = qname.substring(rParenIndex + 1, qname.length());
            nsUri = qname.substring(1, rParenIndex);
        } else {
            localname = qname;
            nsUri = "";
        }
        return new QName(nsUri, localname);
    }

    protected void addDescendants(List<BXML> descendants, XMLItem currentElement, List<String> qnames) {
        for (BXML child : currentElement.getChildrenSeq().children) {
            if (child.getNodeType() != XMLNodeType.ELEMENT) continue;
            String elemName = ((XMLItem)child).getQName().toString();
            if (qnames.contains(elemName)) {
                descendants.add(child);
            }
            this.addDescendants(descendants, (XMLItem)child, qnames);
        }
    }

    @Override
    public synchronized boolean isFrozen() {
        return this.freezeStatus.isFrozen();
    }

    public void addChildren(XMLValue seq) {
        this.addChildren((BXML)seq);
    }

    public void setChildren(XMLValue seq) {
        this.setChildren((BXML)seq);
    }

    @Override
    public abstract XMLValue children();

    @Override
    public abstract XMLValue children(String var1);

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        XMLValue copy = (XMLValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public abstract XMLValue getItem(int var1);

    @Override
    public void serialize(OutputStream outputStream) {
        try {
            if (outputStream instanceof BallerinaXMLSerializer) {
                ((BallerinaXMLSerializer)outputStream).write(this);
            } else {
                BallerinaXMLSerializer xmlSerializer = new BallerinaXMLSerializer(outputStream);
                xmlSerializer.write(this);
                xmlSerializer.flush();
                xmlSerializer.close();
            }
        }
        catch (Throwable t) {
            XMLValue.handleXmlException("error occurred during writing the message to the output stream: ", t);
        }
    }
}

