/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values.utils;

import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.utils.GetFunction;

public class ArrayUtils {
    @Deprecated
    public static void add(ArrayValue arr, int elemTypeTag, long index, Object value) {
        switch (elemTypeTag) {
            case 1: {
                arr.add(index, (Long)value);
                break;
            }
            case 6: {
                arr.add(index, (Boolean)value);
                break;
            }
            case 2: {
                arr.add(index, ((Integer)value).byteValue());
                break;
            }
            case 3: {
                arr.add(index, (Double)value);
                break;
            }
            case 5: {
                arr.add(index, (String)value);
                break;
            }
            default: {
                arr.add(index, value);
            }
        }
    }

    public static GetFunction getElementAccessFunction(BType arrType, String funcName) {
        switch (arrType.getTag()) {
            case 20: {
                return BArray::get;
            }
            case 31: {
                return BArray::getRefValue;
            }
        }
        throw ArrayUtils.createOpNotSupportedError(arrType, funcName);
    }

    public static void checkIsArrayOnlyOperation(BType arrType, String op) {
        if (arrType.getTag() != 20) {
            throw ArrayUtils.createOpNotSupportedError(arrType, op);
        }
    }

    public static ErrorValue createOpNotSupportedError(BType type, String op) {
        return BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "OperationNotSupported"), String.format("%s not supported on type '%s'", op, type.getQualifiedName()));
    }
}

