/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.LogManager;
import org.ballerinalang.BLangProgramLoader;
import org.ballerinalang.BLangProgramRunner;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.logging.BLogManager;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.runtime.threadpool.ThreadPoolFactory;
import org.ballerinalang.tool.BLauncherException;
import org.ballerinalang.tool.util.BFileUtil;
import org.ballerinalang.util.BootstrapRunner;
import org.ballerinalang.util.JBallerinaInMemoryClassLoader;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ProgramFileReader;
import org.ballerinalang.util.exceptions.BLangUsageException;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;
import org.wso2.ballerinalang.programfile.ProgramFileWriter;
import org.wso2.ballerinalang.util.RepoUtils;

public class LauncherUtils {
    private static final String STATUS_CODE = "statusCode";
    private static final int EXIT_CODE_GENERAL_ERROR = 1;
    private static final int EXIT_CODE_SUCCESS = 0;
    private static PrintStream errStream = System.err;

    public static void runProgram(Path sourceRootPath, Path sourcePath, Map<String, String> runtimeParams, String configFilePath, String[] args, boolean offline, boolean observeFlag) {
        LauncherUtils.runProgram(sourceRootPath, sourcePath, runtimeParams, configFilePath, args, offline, observeFlag, false, true);
    }

    public static void runProgram(Path sourceRootPath, Path sourcePath, Map<String, String> runtimeParams, String configFilePath, String[] args, boolean offline, boolean observeFlag, boolean siddhiRuntimeFlag, boolean experimentalFlag) {
        String srcPathStr = sourcePath.toString();
        Path fullPath = sourceRootPath.resolve(sourcePath);
        System.setProperty("ballerina.source.root", fullPath.getParent().toString());
        LauncherUtils.loadConfigurations(fullPath.getParent(), runtimeParams, configFilePath, observeFlag);
        if (srcPathStr.endsWith(".jar")) {
            LauncherUtils.runJar(sourcePath, args);
            return;
        }
        LauncherUtils.runBal(sourceRootPath, sourcePath, args, offline, siddhiRuntimeFlag, experimentalFlag, srcPathStr, fullPath);
    }

    public static Path getSourceRootPath(String sourceRoot) {
        Path sourceRootPath;
        if (sourceRoot == null || sourceRoot.isEmpty()) {
            sourceRootPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        } else {
            try {
                sourceRootPath = Paths.get(sourceRoot, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                throw new RuntimeException("error reading from directory: " + sourceRoot + " reason: " + e.getMessage(), e);
            }
            if (!Files.isDirectory(sourceRootPath, LinkOption.NOFOLLOW_LINKS)) {
                throw new RuntimeException("source root must be a directory");
            }
        }
        return sourceRootPath;
    }

    private static BLauncherException createUsageException(String errorMsg) {
        BLauncherException launcherException = new BLauncherException();
        launcherException.addMessage("ballerina: " + errorMsg);
        return launcherException;
    }

    public static BLauncherException createUsageExceptionWithHelp(String errorMsg) {
        BLauncherException launcherException = new BLauncherException();
        launcherException.addMessage("ballerina: " + errorMsg);
        launcherException.addMessage("Run 'ballerina help' for usage.");
        return launcherException;
    }

    public static BLauncherException createLauncherException(String errorMsg) {
        BLauncherException launcherException = new BLauncherException();
        launcherException.addMessage("error: " + errorMsg);
        return launcherException;
    }

    public static BLauncherException createLauncherException(String errorPrefix, Throwable cause) {
        String message = cause instanceof ErrorValue ? ((ErrorValue)cause).getPrintableStackTrace() : cause.toString();
        BLauncherException launcherException = new BLauncherException();
        launcherException.addMessage("error: " + errorPrefix + message);
        return launcherException;
    }

    static void printLauncherException(BLauncherException e, PrintStream outStream) {
        List<String> errorMessages = e.getMessages();
        errorMessages.forEach(outStream::println);
    }

    static String makeFirstLetterLowerCase(String s) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    static void writePID(String ballerinaHome) {
        Throwable throwable;
        Process p;
        String[] cmd = new String[]{"bash", "-c", "echo $PPID"};
        String pid = "";
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            return;
        }
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                pid = builder.toString();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable e) {
            throw LauncherUtils.createLauncherException("failed to write ballerina.pid file: " + LauncherUtils.makeFirstLetterLowerCase(e.getMessage()));
        }
        if (pid.length() != 0) {
            try {
                throwable = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Paths.get(ballerinaHome, "ballerina.pid").toString()), StandardCharsets.UTF_8));){
                    writer.write(pid);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("failed to write ballerina.pid file: " + LauncherUtils.makeFirstLetterLowerCase(e.getMessage()));
            }
        }
    }

    public static ProgramFile compile(Path sourceRootPath, Path sourcePath, boolean offline, boolean enableExpFeatures) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootPath.toString());
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(offline));
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(enableExpFeatures));
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        BLangPackage entryPkgNode = compiler.compile(sourcePath.toString());
        CompiledBinaryFile.ProgramFile programFile = compiler.getExecutableProgram(entryPkgNode);
        if (programFile == null) {
            throw new BLangCompilerException("compilation contains errors");
        }
        ProgramFile progFile = LauncherUtils.getExecutableProgram(programFile);
        progFile.setProgramFilePath(sourcePath);
        return progFile;
    }

    public static ProgramFile compile(Path sourceRootPath, Path sourcePath, boolean offline, boolean siddhiRuntimeFlag, boolean enableExpFeatures) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootPath.toString());
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(offline));
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(enableExpFeatures));
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        BLangPackage entryPkgNode = compiler.compile(sourcePath.toString());
        CompiledBinaryFile.ProgramFile programFile = compiler.getExecutableProgram(entryPkgNode);
        if (programFile == null) {
            throw new BLangCompilerException("compilation contains errors");
        }
        ProgramFile progFile = LauncherUtils.getExecutableProgram(programFile);
        progFile.setProgramFilePath(sourcePath);
        return progFile;
    }

    public static ProgramFile getExecutableProgram(CompiledBinaryFile.ProgramFile programFile) {
        ByteArrayInputStream byteIS = null;
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try {
            ProgramFileWriter.writeProgram((CompiledBinaryFile.ProgramFile)programFile, (OutputStream)byteOutStream);
            ProgramFileReader reader = new ProgramFileReader();
            byteIS = new ByteArrayInputStream(byteOutStream.toByteArray());
            ProgramFile programFile2 = reader.readProgram((InputStream)byteIS);
            return programFile2;
        }
        catch (Throwable e) {
            throw LauncherUtils.createLauncherException("failed to compile file: " + LauncherUtils.makeFirstLetterLowerCase(e.getMessage()));
        }
        finally {
            if (byteIS != null) {
                try {
                    byteIS.close();
                }
                catch (IOException iOException) {}
            }
            try {
                byteOutStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void loadConfigurations(Path sourceRootPath, String configFilePath) {
        LauncherUtils.loadConfigurations(sourceRootPath, new HashMap<String, String>(), configFilePath, false);
    }

    public static void loadConfigurations(Path sourceRootPath, Map<String, String> runtimeParams, String configFilePath, boolean observeFlag) {
        Path ballerinaConfPath = sourceRootPath.resolve("ballerina.conf");
        try {
            ConfigRegistry.getInstance().initRegistry(runtimeParams, configFilePath, ballerinaConfPath);
            ((BLogManager)LogManager.getLogManager()).loadUserProvidedLogConfiguration();
            if (observeFlag) {
                ConfigRegistry.getInstance().addConfiguration("b7a.observability.metrics.enabled", (Object)Boolean.TRUE);
                ConfigRegistry.getInstance().addConfiguration("b7a.observability.tracing.enabled", (Object)Boolean.TRUE);
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("failed to read the specified configuration file: " + ballerinaConfPath.toString());
        }
        catch (RuntimeException e) {
            throw LauncherUtils.createLauncherException(e.getMessage());
        }
    }

    private static void runBal(Path sourceRootPath, Path sourcePath, String[] args, boolean offline, boolean siddhiRuntimeFlag, boolean experimentalFlag, String srcPathStr, Path fullPath) {
        int exitCode;
        if ("jvm".equals(System.getProperty("ballerina.target"))) {
            LauncherUtils.compileAndRunJar(sourceRootPath, offline, true, true, experimentalFlag, siddhiRuntimeFlag, args, sourcePath, fullPath, srcPathStr);
            return;
        }
        ProgramFile programFile = LauncherUtils.getCompiledProgram(sourceRootPath, sourcePath, offline, siddhiRuntimeFlag, experimentalFlag, srcPathStr, fullPath);
        if (!programFile.isMainEPAvailable() && !programFile.isServiceEPAvailable()) {
            throw LauncherUtils.createLauncherException("'" + programFile.getProgramFilePath() + "' does not contain a main function or a service");
        }
        try {
            exitCode = LauncherUtils.executeCompiledProgram(programFile, args);
        }
        catch (BLangUsageException | BallerinaException e) {
            throw LauncherUtils.createUsageException(LauncherUtils.makeFirstLetterLowerCase(e.getLocalizedMessage()));
        }
        BLangProgramRunner.resumeStates((ProgramFile)programFile);
        if (exitCode != 0 || !programFile.isServiceEPAvailable()) {
            try {
                ThreadPoolFactory.getInstance().getWorkerExecutor().shutdown();
                ThreadPoolFactory.getInstance().getWorkerExecutor().awaitTermination(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Runtime.getRuntime().exit(exitCode);
        }
    }

    private static void compileAndRunJar(Path sourceRootPath, boolean offline, boolean lockEnabled, boolean skiptests, boolean enableExperimentalFeatures, boolean siddhiRuntimeEnabled, String[] args, Path sourcePath, Path fullPath, String srcPathStr) {
        JBallerinaInMemoryClassLoader classLoader;
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootPath.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(offline));
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.BIR_GEN.toString());
        options.put(CompilerOptionName.LOCK_ENABLED, Boolean.toString(lockEnabled));
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.toString(skiptests));
        options.put(CompilerOptionName.TEST_ENABLED, "true");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(enableExperimentalFeatures));
        String source = LauncherUtils.validateAndGetSrcPath(sourceRootPath, sourcePath, fullPath, srcPathStr);
        if (RepoUtils.isBallerinaStandaloneFile((Path)fullPath)) {
            options.put(CompilerOptionName.PROJECT_DIR, fullPath.getParent().toString());
            options.put(CompilerOptionName.SOURCE_TYPE, "SINGLE_BAL_FILE");
        } else {
            options.put(CompilerOptionName.PROJECT_DIR, sourceRootPath.toString());
        }
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        BLangPackage entryPkgNode = compiler.compile(source);
        if (entryPkgNode.diagCollector.hasErrors()) {
            throw new BLangCompilerException("compilation contains errors");
        }
        String balHome = Objects.requireNonNull(System.getProperty("ballerina.home"), "ballerina.home is not set");
        try {
            Path targetDirectory = Files.createTempDirectory("ballerina-compile", new FileAttribute[0]).toAbsolutePath();
            classLoader = BootstrapRunner.createClassLoaders((BLangPackage)entryPkgNode, (Path)Paths.get(balHome, new String[0]).resolve("bir-cache"), (Path)targetDirectory, Optional.empty(), (boolean)false);
        }
        catch (IOException e) {
            throw new BLangCompilerException("error invoking jballerina backend", (Throwable)e);
        }
        String initClassName = BFileUtil.getQualifiedClassName(entryPkgNode.packageID.orgName.value, entryPkgNode.packageID.name.value, "___init");
        LauncherUtils.runInMemoryJar(classLoader, args, initClassName);
    }

    private static ProgramFile getCompiledProgram(Path sourceRootPath, Path sourcePath, boolean offline, boolean siddhiRuntimeFlag, boolean experimentalFlag, String srcPathStr, Path fullPath) {
        if (srcPathStr.endsWith(".balx")) {
            return BLangProgramLoader.read((Path)sourcePath);
        }
        if (Files.isRegularFile(fullPath, new LinkOption[0]) && srcPathStr.endsWith(".bal") && !RepoUtils.isBallerinaProject((Path)sourceRootPath)) {
            return LauncherUtils.compile(fullPath.getParent(), fullPath.getFileName(), offline, siddhiRuntimeFlag, experimentalFlag);
        }
        if (Files.isDirectory(sourceRootPath, new LinkOption[0])) {
            return LauncherUtils.compileModule(sourceRootPath, sourcePath, offline, siddhiRuntimeFlag, experimentalFlag, srcPathStr, fullPath);
        }
        throw LauncherUtils.createLauncherException("only modules, .bal and .balx files can be used with the 'ballerina run' command.");
    }

    private static int executeCompiledProgram(ProgramFile programFile, String[] args) {
        BValue result = BLangProgramRunner.runProgram((ProgramFile)programFile, (String[])args);
        if (result != null && result.getType().getTag() == 27) {
            BError returnedError = (BError)result;
            errStream.print(LauncherUtils.prepareErrorReturnedErrorMessage(returnedError));
            if (returnedError.getDetails() != null) {
                return LauncherUtils.getStatusCode((BMap<String, BValue>)((BMap)returnedError.getDetails()));
            }
        }
        return 0;
    }

    private static void runInMemoryJar(JBallerinaInMemoryClassLoader classLoader, String[] args, String initClassName) {
        try {
            Class initClazz = classLoader.loadClass(initClassName);
            Method mainMethod = initClazz.getDeclaredMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
            if (!initClazz.getField("serviceEPAvailable").getBoolean(initClazz)) {
                Runtime.getRuntime().exit(0);
            }
        }
        catch (NoSuchMethodException e) {
            throw LauncherUtils.createLauncherException("main method cannot be found for init class " + initClassName);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw LauncherUtils.createLauncherException("invoking main method failed due to " + e.getMessage());
        }
        catch (NoSuchFieldException | InvocationTargetException e) {
            throw LauncherUtils.createLauncherException("invoking main method failed due to " + e.getCause());
        }
    }

    private static String validateAndGetSrcPath(Path sourceRootPath, Path sourcePath, Path fullPath, String srcPathStr) {
        if (RepoUtils.isBallerinaStandaloneFile((Path)fullPath)) {
            return fullPath.getFileName().toString();
        }
        if (!ProjectDirs.isProject((Path)sourceRootPath)) {
            throw LauncherUtils.createLauncherException("you are trying to run a module that is not inside a project. Run `ballerina init` from " + sourceRootPath + " to initialize it as a project and then run the module.");
        }
        if (ProjectDirs.isModuleExist((Path)sourceRootPath, (String)srcPathStr)) {
            return sourcePath.toString();
        }
        throw LauncherUtils.createLauncherException("Module not found :" + sourcePath);
    }

    private static void runJar(Path sourcePath, String[] args) {
        String initClassName = null;
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{sourcePath.toUri().toURL()}, ClassLoader.getSystemClassLoader());
            initClassName = LauncherUtils.getModuleInitClassName(sourcePath);
            Class<?> initClazz = classLoader.loadClass(initClassName);
            Method mainMethod = initClazz.getDeclaredMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
            if (!initClazz.getField("serviceEPAvailable").getBoolean(initClazz)) {
                Runtime.getRuntime().exit(0);
            }
        }
        catch (MalformedURLException e) {
            throw LauncherUtils.createLauncherException("loading jar file failed with given source path " + sourcePath);
        }
        catch (ClassNotFoundException e) {
            throw LauncherUtils.createLauncherException("module init class with name " + initClassName + " cannot be found ");
        }
        catch (NoSuchMethodException e) {
            throw LauncherUtils.createLauncherException("main method cannot be found for init class " + initClassName);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw LauncherUtils.createLauncherException("invoking main method failed due to " + e.getMessage());
        }
        catch (NoSuchFieldException | InvocationTargetException e) {
            throw LauncherUtils.createLauncherException("invoking main method failed due to " + e.getCause());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getModuleInitClassName(Path sourcePath) {
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(sourcePath.toString()));){
            Manifest mf = jarStream.getManifest();
            Attributes attributes = mf.getMainAttributes();
            String initClassName = attributes.getValue("Main-Class");
            if (initClassName == null) {
                throw LauncherUtils.createLauncherException("Main-class manifest entry cannot be found in the jar.");
            }
            String string = initClassName.replaceAll("/", ".");
            return string;
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("error while getting init class name from manifest due to " + e.getMessage());
        }
    }

    private static ProgramFile compileModule(Path sourceRootPath, Path sourcePath, boolean offline, boolean siddhiRuntimeFlag, boolean experimentalFlag, String srcPathStr, Path fullPath) {
        if (Files.isDirectory(fullPath, new LinkOption[0]) && !RepoUtils.isBallerinaProject((Path)sourceRootPath)) {
            throw LauncherUtils.createLauncherException("you are trying to run a module that is not inside a project. Run `ballerina init` from " + sourceRootPath + " to initialize it as a project and then run the module.");
        }
        if (Files.exists(fullPath, new LinkOption[0])) {
            if (Files.isRegularFile(fullPath, new LinkOption[0]) && !srcPathStr.endsWith(".bal")) {
                throw LauncherUtils.createLauncherException("only modules, .bal and .balx files can be used with the 'ballerina run' command.");
            }
        } else {
            throw LauncherUtils.createLauncherException("ballerina source does not exist '" + srcPathStr + "'");
        }
        if (Files.isRegularFile(fullPath, new LinkOption[0]) && srcPathStr.endsWith(".bal") && sourcePath.getParent() != null) {
            throw LauncherUtils.createLauncherException("you are trying to run a ballerina file inside a module within a project. Try running 'ballerina run <module-name>'");
        }
        ProgramFile programFile = LauncherUtils.compile(sourceRootPath, sourcePath, offline, siddhiRuntimeFlag, experimentalFlag);
        return programFile;
    }

    private static int getStatusCode(BMap<String, BValue> errorDetails) {
        if (!errorDetails.hasKey((Object)STATUS_CODE)) {
            return 1;
        }
        BValue specifiedStatusCode = errorDetails.get((Object)STATUS_CODE);
        if (specifiedStatusCode.getType().getTag() != 1) {
            return 1;
        }
        long specifiedIntCode = ((BInteger)specifiedStatusCode).intValue();
        if (specifiedIntCode >= 1L) {
            if (specifiedIntCode > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)specifiedIntCode;
        }
        return 1;
    }

    private static String prepareErrorReturnedErrorMessage(BError error) {
        return "error: " + BLangVMErrors.getErrorMessage((BError)error);
    }
}

