/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.config.cipher.AESCipherTool;
import org.ballerinalang.config.cipher.AESCipherToolException;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.BLauncherException;
import org.ballerinalang.tool.LauncherUtils;
import org.ballerinalang.tool.util.BCompileUtil;
import org.ballerinalang.tool.util.ToolUtil;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class Main {
    private static final String UNMATCHED_ARGUMENT_PREFIX = "Unmatched argument";
    private static final String MISSING_REQUIRED_PARAMETER_PREFIX = "Missing required parameter";
    private static final String COMPILATION_ERROR_MESSAGE = "compilation contains errors";
    private static PrintStream errStream = System.err;
    private static PrintStream outStream = System.out;
    private static final Logger breLog = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) {
        try {
            Optional<BLauncherCmd> optionalInvokedCmd = Main.getInvokedCmd(args);
            optionalInvokedCmd.ifPresent(BLauncherCmd::execute);
        }
        catch (BLangRuntimeException e) {
            errStream.println(e.getMessage());
            Runtime.getRuntime().exit(1);
        }
        catch (BLangCompilerException e) {
            if (!e.getMessage().contains(COMPILATION_ERROR_MESSAGE)) {
                errStream.println(Main.prepareCompilerErrorMessage(e.getMessage()));
            }
            Runtime.getRuntime().exit(1);
        }
        catch (BLauncherException e) {
            LauncherUtils.printLauncherException(e, errStream);
            Runtime.getRuntime().exit(1);
        }
        catch (Throwable e) {
            errStream.println(Main.getMessageForInternalErrors());
            breLog.error(e.getMessage(), e);
            Runtime.getRuntime().exit(1);
        }
    }

    private static Optional<BLauncherCmd> getInvokedCmd(String ... args) {
        try {
            DefaultCmd defaultCmd = new DefaultCmd();
            CommandLine cmdParser = new CommandLine((Object)defaultCmd);
            defaultCmd.setParentCmdParser(cmdParser);
            cmdParser.setStopAtPositional(true);
            HelpCmd helpCmd = new HelpCmd();
            cmdParser.addSubcommand("help", (Object)helpCmd);
            helpCmd.setParentCmdParser(cmdParser);
            ServiceLoader<BLauncherCmd> bCmds = ServiceLoader.load(BLauncherCmd.class);
            for (BLauncherCmd bCmd : bCmds) {
                cmdParser.addSubcommand(bCmd.getName(), (Object)bCmd);
                bCmd.setParentCmdParser(cmdParser);
            }
            VersionCmd versionCmd = new VersionCmd();
            cmdParser.addSubcommand("version", (Object)versionCmd);
            versionCmd.setParentCmdParser(cmdParser);
            HomeCmd homeCmd = new HomeCmd();
            cmdParser.addSubcommand("home", (Object)homeCmd);
            homeCmd.setParentCmdParser(cmdParser);
            EncryptCmd encryptCmd = new EncryptCmd();
            cmdParser.addSubcommand("encrypt", (Object)encryptCmd);
            encryptCmd.setParentCmdParser(cmdParser);
            DistCmd distCmd = new DistCmd();
            CommandLine distCmdParser = new CommandLine((Object)distCmd);
            distCmd.setParentCmdParser(distCmdParser);
            ListCmd listCmd = new ListCmd();
            distCmdParser.addSubcommand("list", (Object)listCmd);
            listCmd.setParentCmdParser(distCmdParser);
            PullCmd pullCmd = new PullCmd();
            distCmdParser.addSubcommand("pull", (Object)pullCmd);
            pullCmd.setParentCmdParser(distCmdParser);
            UseCmd useCmd = new UseCmd();
            distCmdParser.addSubcommand("use", (Object)useCmd);
            useCmd.setParentCmdParser(distCmdParser);
            UpdateCmd updateCmd = new UpdateCmd();
            distCmdParser.addSubcommand("update", (Object)updateCmd);
            updateCmd.setParentCmdParser(distCmdParser);
            RemoveCmd removeCmd = new RemoveCmd();
            distCmdParser.addSubcommand("remove", (Object)removeCmd);
            removeCmd.setParentCmdParser(distCmdParser);
            distCmdParser.setCommandName("dist");
            distCmdParser.setPosixClusteredShortOptionsAllowed(false);
            cmdParser.addSubcommand("dist", (Object)distCmdParser);
            cmdParser.setCommandName("ballerina");
            cmdParser.setPosixClusteredShortOptionsAllowed(false);
            List parsedCommands = cmdParser.parse(args);
            if (parsedCommands.size() < 1) {
                return Optional.of(defaultCmd);
            }
            return Optional.of(((CommandLine)parsedCommands.get(parsedCommands.size() - 1)).getCommand());
        }
        catch (CommandLine.UnmatchedArgumentException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("internal error occurred");
            }
            if (errorMessage.contains(UNMATCHED_ARGUMENT_PREFIX)) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command '" + Main.getFirstUnknownArg(errorMessage) + "'");
            }
            throw LauncherUtils.createUsageExceptionWithHelp(LauncherUtils.makeFirstLetterLowerCase(errorMessage));
        }
        catch (CommandLine.ParameterException e) {
            String msg = e.getMessage();
            if (msg == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("internal error occurred");
            }
            if (msg.startsWith(MISSING_REQUIRED_PARAMETER_PREFIX)) {
                throw LauncherUtils.createUsageExceptionWithHelp("flag " + msg.substring(msg.indexOf("'")) + " needs an argument");
            }
            throw LauncherUtils.createUsageExceptionWithHelp(LauncherUtils.makeFirstLetterLowerCase(msg));
        }
    }

    private static void printUsageInfo(String commandName) {
        String usageInfo = BLauncherCmd.getCommandUsageInfo(commandName);
        errStream.println(usageInfo);
    }

    private static void printVersionInfo() {
        try (InputStream inputStream = Main.class.getResourceAsStream("/META-INF/tool.properties");){
            Properties properties = new Properties();
            properties.load(inputStream);
            String output = "Ballerina " + properties.getProperty("ballerina.version") + "\n";
            output = output + "Language specification " + properties.getProperty("spec.version") + "\n";
            output = output + "Ballerina tool " + properties.getProperty("tool.version") + "\n";
            outStream.print(output);
        }
        catch (Throwable ignore) {
            throw LauncherUtils.createUsageExceptionWithHelp("version info not available");
        }
    }

    private static void printBallerinaDistPath() {
        String balHome = System.getProperty("ballerina.home");
        if (balHome == null) {
            throw LauncherUtils.createUsageExceptionWithHelp("home info not available");
        }
        outStream.print(balHome + "\n");
    }

    private static String getMessageForInternalErrors() {
        String errorMsg;
        try {
            errorMsg = BCompileUtil.readFileAsString("cli-help/internal-error-message.txt");
        }
        catch (IOException e) {
            errorMsg = "ballerina: internal error occurred";
        }
        return errorMsg;
    }

    private static String prepareCompilerErrorMessage(String message) {
        return "error: " + LauncherUtils.makeFirstLetterLowerCase(message);
    }

    private static String getFirstUnknownArg(String errorMessage) {
        String optionsString = errorMessage.split(":")[1];
        return optionsString.split(",")[0].trim();
    }

    @CommandLine.Command(description={"Default Command."}, name="default")
    private static class DefaultCmd
    implements BLauncherCmd {
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true, description={"for more information"})
        private boolean helpFlag;
        @CommandLine.Option(names={"--debug"}, description={"start Ballerina in remote debugging mode"})
        private String debugPort;
        @CommandLine.Option(names={"--version", "-v"}, hidden=true)
        private boolean versionFlag;

        private DefaultCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("help");
                return;
            }
            if (this.versionFlag) {
                Main.printVersionInfo();
                return;
            }
            Main.printUsageInfo("default");
        }

        @Override
        public String getName() {
            return "default";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
        }
    }

    @CommandLine.Command(name="remove", description={"Remove Ballerina distribution"})
    private static class RemoveCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> removeCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private RemoveCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("remove");
                return;
            }
            if (this.removeCommands == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("distribution is not provided");
            }
            if (this.removeCommands.size() == 1) {
                ToolUtil.remove(outStream, this.removeCommands.get(0));
                return;
            }
            if (this.removeCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.removeCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "remove";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina remove\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="update", description={"Update Ballerina current distribution"})
    private static class UpdateCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> updateCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private UpdateCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("update");
                return;
            }
            if (this.updateCommands == null) {
                ToolUtil.update(outStream, "version");
                return;
            }
            if (this.updateCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.updateCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina update\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="use", description={"Use Ballerina distribution"})
    private static class UseCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> useCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private UseCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("use");
                return;
            }
            if (this.useCommands == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("distribution is not provided");
            }
            if (this.useCommands.size() == 1) {
                ToolUtil.use(outStream, this.useCommands.get(0));
                return;
            }
            if (this.useCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.useCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  install update\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="pull", description={"Pull Ballerina distribution"})
    private static class PullCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> pullCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private PullCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("pull");
                return;
            }
            if (this.pullCommands == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("distribution is not provided");
            }
            if (this.pullCommands.size() == 1) {
                ToolUtil.install(outStream, this.pullCommands.get(0));
                return;
            }
            if (this.pullCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.pullCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  install update\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="list", description={"List Ballerina Distributions"})
    private static class ListCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> listCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        @CommandLine.Option(names={"--remote"}, hidden=true)
        private boolean remoteFlag;
        private CommandLine parentCmdParser;

        private ListCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("list");
                return;
            }
            if (this.listCommands == null) {
                ToolUtil.listDistributions(outStream, this.remoteFlag);
                return;
            }
            if (this.listCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.listCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "list";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina list\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="dist", description={"Ballerina distribution commands"})
    private static class DistCmd
    implements BLauncherCmd {
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true, description={"for more information"})
        private boolean helpFlag;

        private DistCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("help");
                return;
            }
            Main.printUsageInfo("dist");
        }

        @Override
        public String getName() {
            return "dist";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
        }
    }

    @CommandLine.Command(name="encrypt", description={"encrypt sensitive data"})
    public static class EncryptCmd
    implements BLauncherCmd {
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("encrypt");
                return;
            }
            String value = this.promptForInput("Enter value: ");
            if (value.trim().isEmpty() && value.trim().isEmpty() && (value = this.promptForInput("Value cannot be empty; enter value: ")).trim().isEmpty()) {
                throw LauncherUtils.createLauncherException("encryption failed: empty value.");
            }
            String secret = this.promptForInput("Enter secret: ");
            if (secret.trim().isEmpty() && secret.trim().isEmpty() && (secret = this.promptForInput("Secret cannot be empty; enter secret: ")).trim().isEmpty()) {
                throw LauncherUtils.createLauncherException("encryption failed: empty secret.");
            }
            String secretVerifyVal = this.promptForInput("Re-enter secret to verify: ");
            if (!secret.equals(secretVerifyVal)) {
                throw LauncherUtils.createLauncherException("secrets did not match.");
            }
            try {
                AESCipherTool cipherTool = new AESCipherTool(secret);
                String encryptedValue = cipherTool.encrypt(value);
                errStream.println("Add the following to the runtime config:");
                errStream.println("@encrypted:{" + encryptedValue + "}\n");
                errStream.println("Or add to the runtime command line:");
                errStream.println("-e<param>=@encrypted:{" + encryptedValue + "}");
            }
            catch (AESCipherToolException e) {
                throw LauncherUtils.createLauncherException("failed to encrypt value: " + e.getMessage());
            }
        }

        @Override
        public String getName() {
            return "encrypt";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
            out.append("The encrypt command can be used to encrypt sensitive data.\n\n");
            out.append("When the command is executed, the user will be prompted to\n");
            out.append("enter the value to be encrypted and a secret. The secret will be used in \n");
            out.append("encrypting the value.\n\n");
            out.append("Once encrypted, the user can place the encrypted value in the config files,\n");
            out.append("similar to the following example:\n");
            out.append("\tuser.password=\"@encrypted:{UtD9d+o6eHpqFnBxtvhb+RWXey7qm7xLMt6+6mrt9w0=}\"\n\n");
            out.append("The Ballerina Config API will automatically decrypt the values on-demand.\n");
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina encrypt\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
        }

        private String promptForInput(String msg) {
            errStream.println(msg);
            return new String(System.console().readPassword());
        }
    }

    @CommandLine.Command(name="home", description={"Prints the path of current Ballerina dist"})
    private static class HomeCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> homeCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private HomeCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("home");
                return;
            }
            if (this.homeCommands == null) {
                Main.printBallerinaDistPath();
                return;
            }
            if (this.homeCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.homeCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "home";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina home\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="version", description={"Prints Ballerina version"})
    private static class VersionCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> versionCommands;
        @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
        private boolean helpFlag;
        private CommandLine parentCmdParser;

        private VersionCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                Main.printUsageInfo("version");
                return;
            }
            if (this.versionCommands == null) {
                Main.printVersionInfo();
                return;
            }
            if (this.versionCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.versionCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina version\n");
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }

    @CommandLine.Command(name="help", description={"print usage information"})
    private static class HelpCmd
    implements BLauncherCmd {
        @CommandLine.Parameters(description={"Command name"})
        private List<String> helpCommands;
        private CommandLine parentCmdParser;

        private HelpCmd() {
        }

        @Override
        public void execute() {
            if (this.helpCommands == null) {
                Main.printUsageInfo("help");
                return;
            }
            if (this.helpCommands.size() > 1) {
                throw LauncherUtils.createUsageExceptionWithHelp("too many arguments given");
            }
            String userCommand = this.helpCommands.get(0);
            if (this.parentCmdParser.getSubcommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageExceptionWithHelp("unknown help topic `" + userCommand + "`");
            }
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo(userCommand);
            errStream.println(commandUsageInfo);
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
        }

        @Override
        public void setParentCmdParser(CommandLine parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }
    }
}

