/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import java.io.File;
import java.util.Locale;

public class OSUtils {
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.getDefault());
    private static final String BALLERINA_HOME_DIR = ".ballerina";
    private static final String TOOLS_DIR = "tools";

    public static String getToolPath() {
        String home = System.getProperty("user.home");
        if (OSUtils.isWindows()) {
            return home + File.separator + BALLERINA_HOME_DIR + File.separator + TOOLS_DIR;
        }
        if (OSUtils.isUnix() || OSUtils.isSolaris()) {
            return home + File.separator + BALLERINA_HOME_DIR + File.separator + TOOLS_DIR;
        }
        if (OSUtils.isMac()) {
            return home + File.separator + BALLERINA_HOME_DIR + File.separator + TOOLS_DIR;
        }
        return null;
    }

    public static String getDistributionsPath() {
        return OSUtils.getToolPath() + File.separator + "distributions";
    }

    public static String getUserAgent(String ballerinaVersion, String toolVersion, String distributionType) {
        String os = "none";
        if (OSUtils.isWindows()) {
            os = "win-64";
        } else if (OSUtils.isUnix() || OSUtils.isSolaris()) {
            os = "linux-64";
        } else if (OSUtils.isMac()) {
            os = "macos-64";
        }
        return distributionType + "/" + ballerinaVersion + " (" + os + ") Updater/" + toolVersion;
    }

    private static boolean isWindows() {
        return OS.contains("win");
    }

    private static boolean isMac() {
        return OS.contains("mac");
    }

    private static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    private static boolean isSolaris() {
        return OS.contains("sunos");
    }
}

