/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.tool.util.OSUtils;

public class ToolUtil {
    private static final String STAGING_URL = "https://api.staging-central.ballerina.io/update-tool";
    private static final String BALLERINA_CONFIG = "ballerina-version";
    private static final String BALLERINA_TOOLS_CONFIG = "ballerina-tools-version";
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public static void listDistributions(PrintStream outStream, boolean isRemote) {
        try {
            String currentBallerinaVersion = ToolUtil.getCurrentBallerinaVersion();
            if (isRemote) {
                MapValue distributions = ToolUtil.getDistributions();
                for (int i = 0; i < distributions.getArrayValue("list").size(); ++i) {
                    MapValue dist = (MapValue)distributions.getArrayValue("list").get((long)i);
                    outStream.println(ToolUtil.markVersion(currentBallerinaVersion, dist.getStringValue("type") + "-" + dist.getStringValue("version")));
                }
            } else {
                File folder = new File(OSUtils.getDistributionsPath());
                File[] listOfFiles = folder.listFiles();
                for (int i = 0; i < listOfFiles.length; ++i) {
                    if (!listOfFiles[i].isDirectory()) continue;
                    outStream.println(ToolUtil.markVersion(currentBallerinaVersion, listOfFiles[i].getName()));
                }
            }
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            outStream.println("Ballerina Update service is not available");
        }
    }

    private static String getCurrentBallerinaVersion() throws IOException {
        return ToolUtil.getVersion(OSUtils.getDistributionsPath() + File.separator + BALLERINA_CONFIG);
    }

    private static void setCurrentBallerinaVersion(String version) throws IOException {
        ToolUtil.setVersion(OSUtils.getDistributionsPath() + File.separator + BALLERINA_CONFIG, version);
    }

    private static String getCurrentToolsVersion() throws IOException {
        return ToolUtil.getVersion(OSUtils.getToolPath() + File.separator + BALLERINA_TOOLS_CONFIG);
    }

    private static void setCurrentToolsVersion(String version) throws IOException {
        ToolUtil.setVersion(OSUtils.getToolPath() + File.separator + BALLERINA_TOOLS_CONFIG, version);
    }

    private static String getVersion(String path) throws IOException {
        BufferedReader br = Files.newBufferedReader(Paths.get(path, new String[0]));
        List list = br.lines().collect(Collectors.toList());
        return (String)list.get(0);
    }

    private static void setVersion(String path, String version) throws IOException {
        PrintWriter writer = new PrintWriter(path, "UTF-8");
        writer.println(version);
        writer.close();
    }

    private static String markVersion(String used, String current) {
        if (used.equals(current)) {
            return "* " + current;
        }
        return "  " + current;
    }

    public static boolean use(PrintStream printStream, String distribution) {
        try {
            File installFile = new File(OSUtils.getDistributionsPath() + File.separator + distribution);
            if (installFile.exists()) {
                if (distribution.equals(ToolUtil.getCurrentBallerinaVersion())) {
                    printStream.println(distribution + " is already in use ");
                    return true;
                }
                ToolUtil.setCurrentBallerinaVersion(distribution);
                printStream.println("Using " + distribution);
                return true;
            }
        }
        catch (IOException e) {
            printStream.println("Cannot use " + distribution);
        }
        return false;
    }

    public static void install(PrintStream printStream, String distribution) {
        try {
            if (!ToolUtil.use(printStream, distribution)) {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                String distributionType = distribution.split("-")[0];
                String distributionVersion = distribution.replace(distributionType + "-", "");
                URL url = new URL("https://api.staging-central.ballerina.io/update-tool/distributions/" + distributionVersion);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("user-agent", OSUtils.getUserAgent(distributionVersion, ToolUtil.getCurrentToolsVersion(), distributionType));
                conn.setRequestProperty("Accept", "application/json");
                if (conn.getResponseCode() == 302) {
                    String newUrl = conn.getHeaderField("Location");
                    conn = (HttpURLConnection)new URL(newUrl).openConnection();
                    conn.setRequestProperty("content-type", "binary/data");
                    ToolUtil.download(printStream, conn, distribution);
                } else if (conn.getResponseCode() == 200) {
                    ToolUtil.download(printStream, conn, distribution);
                } else {
                    printStream.println(distribution + " is not found ");
                }
            }
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            printStream.println("Cannot connect to the central server");
        }
    }

    public static void download(PrintStream printStream, HttpURLConnection conn, String distribution) throws IOException {
        int count;
        printStream.print("Downloading " + distribution);
        InputStream in = conn.getInputStream();
        String zipFileLocation = OSUtils.getDistributionsPath() + File.separator + distribution + ".zip";
        FileOutputStream out = new FileOutputStream(zipFileLocation);
        byte[] b = new byte[1024];
        int progress = 0;
        while ((count = in.read(b)) > 0) {
            out.write(b, 0, count);
            if (++progress % 1024 != 0) continue;
            printStream.print(".");
        }
        printStream.println();
        ToolUtil.unzip(zipFileLocation, OSUtils.getDistributionsPath());
        ToolUtil.setCurrentBallerinaVersion(distribution);
        if (conn.getResponseCode() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
        }
        conn.disconnect();
        printStream.println(distribution + " is installed ");
    }

    public static void update(PrintStream printStream, String version) {
        ToolUtil.install(printStream, version);
    }

    public static void remove(PrintStream outStream, String version) {
        try {
            if (version.equals(ToolUtil.getCurrentBallerinaVersion())) {
                outStream.println("You cannot remove default Ballerina version");
            } else {
                File directory = new File(OSUtils.getDistributionsPath() + File.separator + version);
                if (directory.exists()) {
                    ToolUtil.deleteFiles(directory.toPath(), outStream, version);
                    outStream.println(version + " deleted successfully");
                } else {
                    outStream.println(version + " does not exist");
                }
            }
        }
        catch (IOException e) {
            outStream.println("Error occurred while removing");
        }
    }

    public static void deleteFiles(Path dirPath, PrintStream outStream, String version) throws IOException {
        if (dirPath == null) {
            return;
        }
        Files.walk(dirPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                outStream.println(version + " cannot remove");
            }
        });
    }

    private static MapValue getDistributions() throws IOException, KeyManagementException, NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        URL url = new URL("https://api.staging-central.ballerina.io/update-tool/distributions");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("user-agent", OSUtils.getUserAgent(ToolUtil.getCurrentBallerinaVersion(), ToolUtil.getCurrentToolsVersion(), "jballerina"));
        conn.setRequestProperty("Accept", "application/json");
        if (conn.getResponseCode() != 200) {
            conn.disconnect();
            throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
        }
        JSONParser parser = new JSONParser();
        MapValue distributions = (MapValue)JSONParser.parse((Reader)new InputStreamReader(conn.getInputStream()));
        conn.disconnect();
        return distributions;
    }

    public static void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
                byte[] bytesIn = new byte[1024];
                int read = 0;
                while ((read = zipIn.read(bytesIn)) != -1) {
                    bos.write(bytesIn, 0, read);
                }
                bos.close();
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
        new File(zipFilePath).delete();
    }
}

