/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.ballerinalang.tool.util.ToolUtil;

public class OSUtils {
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.getDefault());
    private static final String BALLERINA_HOME_DIR = ".ballerina";
    private static final String BALLERINA_CONFIG = "ballerina-version";

    public static String getInstalltionPath() {
        if (OSUtils.isWindows()) {
            return System.getenv("ProgramFiles") + File.separator + "Ballerina";
        }
        if (OSUtils.isUnix() || OSUtils.isSolaris()) {
            return File.separator + "usr" + File.separator + "lib" + File.separator + "ballerina";
        }
        if (OSUtils.isMac()) {
            return File.separator + "Library" + File.separator + "Ballerina";
        }
        return null;
    }

    public static String getBallerinaVersionFilePath() throws IOException {
        String userHome = System.getProperty("user.home");
        File file = new File(userHome + File.separator + BALLERINA_HOME_DIR + File.separator + BALLERINA_CONFIG);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
            InputStream inputStream = OSUtils.class.getResourceAsStream("/META-INF/tool.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            ToolUtil.setVersion(file.getPath(), properties.getProperty("ballerina.version"));
        }
        return System.getProperty("user.home") + File.separator + BALLERINA_HOME_DIR + File.separator + BALLERINA_CONFIG;
    }

    public static String getDistributionsPath() {
        return OSUtils.getInstalltionPath() + File.separator + "distributions";
    }

    public static String getUserAgent(String ballerinaVersion, String toolVersion, String distributionType) {
        String os = "none";
        if (OSUtils.isWindows()) {
            os = "win-64";
        } else if (OSUtils.isUnix() || OSUtils.isSolaris()) {
            os = "linux-64";
        } else if (OSUtils.isMac()) {
            os = "macos-64";
        }
        return distributionType + "/" + ballerinaVersion + " (" + os + ") Updater/" + toolVersion;
    }

    private static boolean isWindows() {
        return OS.contains("win");
    }

    private static boolean isMac() {
        return OS.contains("mac");
    }

    private static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    private static boolean isSolaris() {
        return OS.contains("sunos");
    }
}

