/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.tool.util.OSUtils;
import org.ballerinalang.tool.util.Version;

public class ToolUtil {
    private static final String STAGING_URL = "https://api.staging-central.ballerina.io/update-tool";
    private static final String BALLERINA_TYPE = "jballerina";
    private static final String BALLERINA_TOOL_NAME = "ballerina";
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public static void listDistributions(PrintStream outStream, boolean isRemote) {
        try {
            outStream.println("Distributions available locally: \n");
            String currentBallerinaVersion = ToolUtil.getCurrentBallerinaVersion();
            File folder = new File(ToolUtil.getDistributionsPath());
            File[] listOfFiles = folder.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isDirectory()) continue;
                outStream.println(ToolUtil.markVersion("jballerina-" + currentBallerinaVersion, listOfFiles[i].getName()));
            }
            outStream.println();
            if (isRemote) {
                outStream.println("Distributions available remotely: \n");
                MapValue distributions = ToolUtil.getDistributions();
                for (int i = 0; i < distributions.getArrayValue("list").size(); ++i) {
                    MapValue dist = (MapValue)distributions.getArrayValue("list").get((long)i);
                    outStream.println(ToolUtil.markVersion("jballerina-" + currentBallerinaVersion, dist.getStringValue("type") + "-" + dist.getStringValue("version")));
                }
                outStream.println();
            }
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            outStream.println("Ballerina Update service is not available");
        }
    }

    private static String getCurrentBallerinaVersion() throws IOException {
        return ToolUtil.getVersion(OSUtils.getBallerinaVersionFilePath());
    }

    private static void setCurrentBallerinaVersion(String version) throws IOException {
        ToolUtil.setVersion(OSUtils.getBallerinaVersionFilePath(), version);
    }

    private static void clearCache(PrintStream outStream) throws IOException {
        OSUtils.clearBirCacheLocation(outStream);
        OSUtils.clearJarCacheLocation(outStream);
    }

    private static String getCurrentToolsVersion() {
        return "1.0.0-beta";
    }

    private static String getVersion(String path) throws IOException {
        BufferedReader br = Files.newBufferedReader(Paths.get(path, new String[0]));
        List list = br.lines().collect(Collectors.toList());
        return ((String)list.get(0)).replace("jballerina-", "");
    }

    public static void setVersion(String path, String version) throws IOException {
        PrintWriter writer = new PrintWriter(path, "UTF-8");
        if (!version.contains(BALLERINA_TYPE)) {
            version = "jballerina-" + version;
        }
        writer.println(version);
        writer.close();
    }

    private static String markVersion(String used, String current) {
        if (used.equals(current)) {
            return "* " + current;
        }
        return "  " + current;
    }

    public static boolean use(PrintStream printStream, String distribution) {
        try {
            File installFile = new File(ToolUtil.getDistributionsPath() + File.separator + distribution);
            if (installFile.exists()) {
                if (distribution.equals(ToolUtil.getCurrentBallerinaVersion())) {
                    printStream.println(distribution + " is already in use ");
                    return true;
                }
                ToolUtil.setCurrentBallerinaVersion(distribution);
                ToolUtil.clearCache(printStream);
                printStream.println("Using " + distribution);
                return true;
            }
        }
        catch (IOException e) {
            printStream.println("Cannot use " + distribution);
        }
        return false;
    }

    public static void install(PrintStream printStream, String distribution, boolean manualUpdate) {
        try {
            if (!ToolUtil.use(printStream, distribution)) {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                String distributionType = distribution.split("-")[0];
                String distributionVersion = distribution.replace(distributionType + "-", "");
                URL url = new URL("https://api.staging-central.ballerina.io/update-tool/distributions/" + distributionVersion);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("user-agent", OSUtils.getUserAgent(distributionVersion, ToolUtil.getCurrentToolsVersion(), distributionType));
                conn.setRequestProperty("Accept", "application/json");
                if (conn.getResponseCode() == 302) {
                    String newUrl = conn.getHeaderField("Location");
                    conn = (HttpURLConnection)new URL(newUrl).openConnection();
                    conn.setRequestProperty("content-type", "binary/data");
                    ToolUtil.download(printStream, conn, distribution, manualUpdate);
                } else if (conn.getResponseCode() == 200) {
                    ToolUtil.download(printStream, conn, distribution, manualUpdate);
                } else {
                    printStream.println(distribution + " is not found ");
                }
            }
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            printStream.println("Cannot connect to the central server");
        }
    }

    public static void download(PrintStream printStream, HttpURLConnection conn, String distribution, boolean manual) throws IOException {
        String distPath = ToolUtil.getDistributionsPath();
        if (new File(distPath).canWrite()) {
            int count;
            printStream.print("Downloading " + distribution);
            InputStream in = conn.getInputStream();
            String zipFileLocation = ToolUtil.getDistributionsPath() + File.separator + distribution + ".zip";
            FileOutputStream out = new FileOutputStream(zipFileLocation);
            byte[] b = new byte[1024];
            int progress = 0;
            while ((count = in.read(b)) > 0) {
                out.write(b, 0, count);
                if (++progress % 1024 != 0) continue;
                printStream.print(".");
            }
            printStream.println();
            ToolUtil.unzip(zipFileLocation, ToolUtil.getDistributionsPath(), distribution);
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            conn.disconnect();
            if (manual) {
                printStream.println(distribution + " is installed. Please execute \"ballerina dist use " + distribution + "\" to use as the default");
            }
        } else {
            printStream.println("Current user does not have write permissions to " + distPath + " directory");
        }
    }

    public static void update(PrintStream printStream) {
        try {
            String version = ToolUtil.getCurrentBallerinaVersion();
            ArrayList<String> versions = new ArrayList<String>();
            MapValue distributions = ToolUtil.getDistributions();
            for (int i = 0; i < distributions.getArrayValue("list").size(); ++i) {
                MapValue dist = (MapValue)distributions.getArrayValue("list").get((long)i);
                versions.add(dist.getStringValue("version"));
            }
            Version currentVersion = new Version(version);
            String latestVersion = currentVersion.getLatest((String[])versions.stream().toArray(String[]::new));
            if (!latestVersion.equals(version)) {
                String distribution = "jballerina-" + latestVersion;
                ToolUtil.install(printStream, distribution, false);
                ToolUtil.use(printStream, distribution);
            } else {
                printStream.println("No update found");
            }
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            printStream.println("Cannot connect to the central server");
        }
    }

    public static void selfUpdate(PrintStream printStream) {
        printStream.println("Self update service is not availalble. Please visit https://ballerina.io/downloads/ to get latest tools");
    }

    public static void remove(PrintStream outStream, String version) {
        boolean isCurrentVersion = false;
        try {
            isCurrentVersion = version.equals(ToolUtil.getCurrentBallerinaVersion());
        }
        catch (IOException e) {
            outStream.println("There is no default version for current user");
        }
        try {
            if (isCurrentVersion) {
                outStream.println("You cannot remove default Ballerina version");
            } else {
                File directory = new File(ToolUtil.getDistributionsPath() + File.separator + version);
                if (directory.exists()) {
                    if (directory.canWrite()) {
                        ToolUtil.deleteFiles(directory.toPath(), outStream, version);
                        outStream.println(version + " deleted successfully");
                    } else {
                        outStream.println("Current user does not have write permissions to " + directory.toPath() + " directory");
                    }
                } else {
                    outStream.println(version + " does not exist");
                }
            }
        }
        catch (IOException e) {
            outStream.println("Error occurred while removing");
        }
    }

    public static void deleteFiles(Path dirPath, PrintStream outStream, String version) throws IOException {
        if (dirPath == null) {
            return;
        }
        Files.walk(dirPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                outStream.println(version + " cannot remove");
            }
        });
    }

    private static MapValue getDistributions() throws IOException, KeyManagementException, NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        URL url = new URL("https://api.staging-central.ballerina.io/update-tool/distributions");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("user-agent", OSUtils.getUserAgent(ToolUtil.getCurrentBallerinaVersion(), ToolUtil.getCurrentToolsVersion(), BALLERINA_TYPE));
        conn.setRequestProperty("Accept", "application/json");
        if (conn.getResponseCode() != 200) {
            conn.disconnect();
            throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
        }
        JSONParser parser = new JSONParser();
        MapValue distributions = (MapValue)JSONParser.parse((Reader)new InputStreamReader(conn.getInputStream()));
        conn.disconnect();
        return distributions;
    }

    public static void unzip(String zipFilePath, String destDirectory, String distribution) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
                byte[] bytesIn = new byte[1024];
                int read = 0;
                while ((read = zipIn.read(bytesIn)) != -1) {
                    bos.write(bytesIn, 0, read);
                }
                bos.close();
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        File file = new File(destDirectory + File.separator + distribution + File.separator + "bin" + File.separator + OSUtils.getExecutableFileName());
        file.setReadable(true, false);
        file.setExecutable(true, false);
        file.setWritable(true, false);
        zipIn.close();
        new File(zipFilePath).delete();
    }

    public static String getDistributionsPath() throws IOException {
        return OSUtils.getInstalltionPath() + File.separator + BALLERINA_TOOL_NAME + "-" + ToolUtil.getCurrentToolsVersion() + File.separator + "distributions";
    }

    public static void checkForUpdate(PrintStream printStream, String[] args) {
        try {
            String version;
            boolean isRunCommand = Arrays.stream(args).anyMatch("run"::equals);
            if (!isRunCommand && OSUtils.updateNotice(version = ToolUtil.getCurrentBallerinaVersion())) {
                Version currentVersion = new Version(version);
                ArrayList<String> versions = new ArrayList<String>();
                MapValue distributions = ToolUtil.getDistributions();
                for (int i = 0; i < distributions.getArrayValue("list").size(); ++i) {
                    MapValue dist = (MapValue)distributions.getArrayValue("list").get((long)i);
                    versions.add(dist.getStringValue("version"));
                }
                String latestVersion = currentVersion.getLatest((String[])versions.stream().toArray(String[]::new));
                if (!latestVersion.equals(version)) {
                    printStream.println();
                    printStream.println("New Ballerina " + latestVersion + " version is available");
                    printStream.println("Please use \"ballerina dist update\" command to update");
                    printStream.println();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

