/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

public class Version {
    private String versionString;
    private int major = 0;
    private int minor = 0;
    private int patch = 0;
    private int preRelease = 0;
    private int preReleaseCount = 0;
    private boolean isSnapshot = false;

    public Version(String version) {
        this.versionString = version;
        version = version.toLowerCase();
        if (version.contains("-")) {
            if (version.contains("snapshot")) {
                this.isSnapshot = true;
                if ((version = version.replace("-snapshot", "")).contains("alpha")) {
                    this.preRelease = 1;
                    this.preReleaseCount = this.getPreReleaseCount(version, "alpha");
                    version = this.replacePreRelease(version, "alpha", this.preReleaseCount);
                } else if (version.contains("beta")) {
                    this.preRelease = 2;
                    this.preReleaseCount = this.getPreReleaseCount(version, "beta");
                    version = this.replacePreRelease(version, "beta", this.preReleaseCount);
                } else if (version.contains("rc")) {
                    this.preRelease = 3;
                    this.preReleaseCount = this.getPreReleaseCount(version, "rc");
                    version = this.replacePreRelease(version, "rc", this.preReleaseCount);
                }
            } else {
                String prePart = version.split("-")[1];
                if (prePart.contains("alpha")) {
                    this.preRelease = 1;
                    this.preReleaseCount = this.getPreReleaseCount(prePart, "alpha");
                    version = this.replacePreRelease(version, "alpha", this.preReleaseCount);
                } else if (prePart.contains("beta")) {
                    this.preRelease = 2;
                    this.preReleaseCount = this.getPreReleaseCount(prePart, "beta");
                    version = this.replacePreRelease(version, "beta", this.preReleaseCount);
                } else if (prePart.contains("rc")) {
                    this.preRelease = 3;
                    this.preReleaseCount = this.getPreReleaseCount(prePart, "rc");
                    version = this.replacePreRelease(version, "rc", this.preReleaseCount);
                }
            }
        }
        String[] versions = version.split("\\.");
        this.major = Integer.parseInt(versions[0]);
        this.minor = Integer.parseInt(versions[1]);
        this.patch = Integer.parseInt(versions[2]);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }

    public int getPreRelease() {
        return this.preRelease;
    }

    public void setPreRelease(int preRelease) {
        this.preRelease = preRelease;
    }

    public int getPreReleaseCount() {
        return this.preReleaseCount;
    }

    public void setPreReleaseCount(int preReleaseCount) {
        this.preReleaseCount = preReleaseCount;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.isSnapshot = snapshot;
    }

    private String replacePreRelease(String version, String type, int preReleaseCount) {
        String newVersion = preReleaseCount == 0 ? version.replace("-" + type, "") : version.replace("-" + type + preReleaseCount, "");
        return newVersion;
    }

    private int getPreReleaseCount(String version, String preReleaseType) {
        String[] parts = (version = version.replace("-", "").replace(".", "")).split(preReleaseType);
        if (parts.length > 1) {
            return Integer.parseInt(parts[1]);
        }
        return 0;
    }

    public String getLatest(String[] versions) {
        Version latestVersion = this;
        for (String versionString : versions) {
            Version currentVersion = new Version(versionString);
            if (!this.isLater(latestVersion, currentVersion)) continue;
            latestVersion = currentVersion;
        }
        return latestVersion.toString();
    }

    private boolean isLater(Version version1, Version version2) {
        boolean isLater = false;
        if (!version2.isSnapshot && version2.getMajor() == version1.getMajor() && version2.getMinor() == version1.getMinor() && version2.getPatch() >= version1.getPatch()) {
            if (version1.preRelease == version2.preRelease && version2.preReleaseCount > version1.preReleaseCount) {
                isLater = true;
            } else if (version2.preRelease == 0) {
                isLater = true;
            } else if (version1.preRelease != 0 && version2.preRelease > version1.preRelease) {
                isLater = true;
            }
        }
        return isLater;
    }

    public String toString() {
        return this.versionString;
    }
}

