/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.tool.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.ballerinalang.tool.util.ToolUtil;

public class OSUtils {
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.getDefault());
    private static final String BALLERINA_HOME_DIR = ".ballerina";
    private static final String BALLERINA_CONFIG = "ballerina-version";
    private static final String UPDATE_NOTICE = "update-notice";
    private static final String BIR_CACHE = "bir_cache";
    private static final String JAR_CACHE = "jar_cache";

    public static String getInstalltionPath() {
        if (OSUtils.isWindows()) {
            return System.getenv("ProgramFiles") + File.separator + "Ballerina";
        }
        if (OSUtils.isUnix() || OSUtils.isSolaris()) {
            return File.separator + "usr" + File.separator + "lib" + File.separator + "ballerina";
        }
        if (OSUtils.isMac()) {
            return File.separator + "Library" + File.separator + "Ballerina";
        }
        return null;
    }

    public static String getExecutableFileName() {
        if (OSUtils.isWindows()) {
            return "ballerina.bat";
        }
        if (OSUtils.isUnix() || OSUtils.isSolaris()) {
            return "ballerina";
        }
        if (OSUtils.isMac()) {
            return "ballerina";
        }
        return null;
    }

    public static String getBallerinaVersionFilePath() throws IOException {
        String userHome = OSUtils.getUserHome();
        File file = new File(userHome + File.separator + BALLERINA_HOME_DIR + File.separator + BALLERINA_CONFIG);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
            InputStream inputStream = OSUtils.class.getResourceAsStream("/META-INF/tool.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            ToolUtil.setVersion(file.getPath(), properties.getProperty("ballerina.version"));
        }
        return OSUtils.getUserHome() + File.separator + BALLERINA_HOME_DIR + File.separator + BALLERINA_CONFIG;
    }

    public static boolean updateNotice(String version) throws IOException {
        boolean showNotice = false;
        String userHome = OSUtils.getUserHome();
        LocalDate today = LocalDate.now();
        File file = new File(userHome + File.separator + BALLERINA_HOME_DIR + File.separator + UPDATE_NOTICE);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
            showNotice = true;
        } else {
            BufferedReader br = Files.newBufferedReader(Paths.get(file.getPath(), new String[0]));
            showNotice = today.minusDays(1L).isAfter(LocalDate.parse((CharSequence)br.lines().collect(Collectors.toList()).get(0)));
        }
        if (showNotice) {
            PrintWriter writer = new PrintWriter(file.getPath(), "UTF-8");
            writer.println(today.toString());
            writer.close();
        }
        return showNotice;
    }

    public static void clearBirCacheLocation(PrintStream outStream) throws IOException {
        OSUtils.deleteDirectory(new File(OSUtils.getUserHome() + File.separator + BALLERINA_HOME_DIR + File.separator + BIR_CACHE), outStream);
    }

    public static void clearJarCacheLocation(PrintStream outStream) throws IOException {
        OSUtils.deleteDirectory(new File(OSUtils.getUserHome() + File.separator + BALLERINA_HOME_DIR + File.separator + JAR_CACHE), outStream);
    }

    private static void deleteDirectory(File file, PrintStream outStream) throws IOException {
        if (file.exists()) {
            Files.walk(file.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    outStream.println(file.getPath() + " cannot remove");
                }
            });
        }
    }

    public static String getUserAgent(String ballerinaVersion, String toolVersion, String distributionType) {
        String os = "none";
        if (OSUtils.isWindows()) {
            os = "win-64";
        } else if (OSUtils.isUnix() || OSUtils.isSolaris()) {
            os = "linux-64";
        } else if (OSUtils.isMac()) {
            os = "macos-64";
        }
        return distributionType + "/" + ballerinaVersion + " (" + os + ") Updater/" + toolVersion;
    }

    private static boolean isWindows() {
        return OS.contains("win");
    }

    private static boolean isMac() {
        return OS.contains("mac");
    }

    private static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    private static boolean isSolaris() {
        return OS.contains("sunos");
    }

    private static String getUserHome() {
        String userHome = System.getenv("HOME");
        if (userHome == null) {
            userHome = System.getProperty("user.home");
        }
        return userHome;
    }
}

