/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.openapi.validator;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.openapi.validator.ErrorMessages;
import org.ballerinalang.openapi.validator.OpenAPIComponentSummary;
import org.ballerinalang.openapi.validator.OpenAPIParameter;
import org.ballerinalang.openapi.validator.OpenAPIPathSummary;
import org.ballerinalang.openapi.validator.OpenApiValidatorException;
import org.ballerinalang.openapi.validator.ResourceParameter;
import org.ballerinalang.openapi.validator.ResourceSummary;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;

class ValidatorUtil {
    ValidatorUtil() {
    }

    public static OpenAPI parseOpenAPIFile(String definitionURI) throws OpenApiValidatorException {
        Path contractPath = java.nio.file.Paths.get(definitionURI, new String[0]);
        if (!Files.exists(contractPath, new LinkOption[0])) {
            throw new OpenApiValidatorException(ErrorMessages.invalidFilePath(definitionURI));
        }
        if (!definitionURI.endsWith(".yaml") && !definitionURI.endsWith(".json")) {
            throw new OpenApiValidatorException(ErrorMessages.invalidFile());
        }
        OpenAPI api = new OpenAPIV3Parser().read(definitionURI);
        if (api == null) {
            throw new OpenApiValidatorException(ErrorMessages.parserException(definitionURI));
        }
        return api;
    }

    public static void summarizeOpenAPI(List<OpenAPIPathSummary> openAPISummaries, OpenAPI contract, OpenAPIComponentSummary openAPIComponentSummary) {
        Paths paths = contract.getPaths();
        for (Map.Entry pathItem : paths.entrySet()) {
            OpenAPIPathSummary openAPISummary = new OpenAPIPathSummary();
            if (pathItem.getKey() instanceof String && pathItem.getValue() instanceof PathItem) {
                String key = (String)pathItem.getKey();
                openAPISummary.setPath(key);
                PathItem operations = (PathItem)pathItem.getValue();
                if (operations.getGet() != null) {
                    ValidatorUtil.addOpenapiSummary(openAPISummary, "get", operations.getGet());
                }
                if (operations.getPost() != null) {
                    ValidatorUtil.addOpenapiSummary(openAPISummary, "post", operations.getPost());
                }
                if (operations.getPut() != null) {
                    ValidatorUtil.addOpenapiSummary(openAPISummary, "put", operations.getPut());
                }
                if (operations.getDelete() != null) {
                    ValidatorUtil.addOpenapiSummary(openAPISummary, "delete", operations.getDelete());
                }
                if (operations.getHead() != null) {
                    ValidatorUtil.addOpenapiSummary(openAPISummary, "head", operations.getHead());
                }
                if (operations.getPatch() != null) {
                    ValidatorUtil.addOpenapiSummary(openAPISummary, "patch", operations.getPatch());
                }
                if (operations.getOptions() != null) {
                    ValidatorUtil.addOpenapiSummary(openAPISummary, "options", operations.getOptions());
                }
                if (operations.getTrace() != null) {
                    ValidatorUtil.addOpenapiSummary(openAPISummary, "trace", operations.getTrace());
                }
            }
            openAPISummaries.add(openAPISummary);
        }
        openAPIComponentSummary.setComponents(contract.getComponents());
    }

    private static void addOpenapiSummary(OpenAPIPathSummary openAPISummary, String get, Operation get2) {
        openAPISummary.addAvailableOperation(get);
        openAPISummary.addOperation(get, get2);
    }

    public static void summarizeResources(List<ResourceSummary> resourceSummaryList, ServiceNode serviceNode) {
        for (FunctionNode resource : serviceNode.getResources()) {
            AnnotationAttachmentNode annotation = null;
            ResourceSummary resourceSummary = new ResourceSummary();
            resourceSummary.setResourcePosition(resource.getPosition());
            for (AnnotationAttachmentNode ann : resource.getAnnotationAttachments()) {
                if (!"http".equals(ann.getPackageAlias().getValue()) || !"ResourceConfig".equals(ann.getAnnotationName().getValue())) continue;
                annotation = ann;
            }
            if (annotation != null && annotation.getExpression() instanceof BLangRecordLiteral) {
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)annotation.getExpression();
                for (RecordLiteralNode.RecordField field : recordLiteral.getFields()) {
                    BLangLiteral value;
                    BLangRecordLiteral.BLangRecordVarNameField valueExpr;
                    BLangRecordLiteral.BLangRecordVarNameField keyExpr;
                    if (field.isKeyValueField()) {
                        BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                        keyExpr = keyValue.getKey();
                        valueExpr = keyValue.getValue();
                    } else {
                        BLangRecordLiteral.BLangRecordVarNameField varNameField;
                        keyExpr = varNameField = (BLangRecordLiteral.BLangRecordVarNameField)field;
                        valueExpr = varNameField;
                    }
                    if (!(keyExpr instanceof BLangSimpleVarRef)) continue;
                    BLangSimpleVarRef path = (BLangSimpleVarRef)keyExpr;
                    String contractAttr = path.getVariableName().getValue();
                    if (contractAttr.equals("path")) {
                        if (!(valueExpr instanceof BLangLiteral) || !((value = (BLangLiteral)valueExpr).getValue() instanceof String)) continue;
                        resourceSummary.setPath((String)value.getValue());
                        resourceSummary.setPathPosition((Diagnostic.DiagnosticPosition)path.getPosition());
                        continue;
                    }
                    if (contractAttr.equals("methods")) {
                        if (!(valueExpr instanceof BLangListConstructorExpr)) continue;
                        BLangListConstructorExpr methodSet = (BLangListConstructorExpr)valueExpr;
                        for (BLangExpression methodExpr : methodSet.exprs) {
                            if (!(methodExpr instanceof BLangLiteral)) continue;
                            BLangLiteral method = (BLangLiteral)methodExpr;
                            resourceSummary.addMethod(((String)method.value).toLowerCase(Locale.ENGLISH));
                            resourceSummary.setMethodsPosition((Diagnostic.DiagnosticPosition)path.getPosition());
                        }
                        continue;
                    }
                    if (!contractAttr.equals("body") || !(valueExpr instanceof BLangLiteral) || !((value = (BLangLiteral)valueExpr).getValue() instanceof String)) continue;
                    resourceSummary.setBody((String)value.getValue());
                }
            }
            if (resource.getParameters().size() > 0) {
                resourceSummary.setParameters(resource.getParameters());
            }
            resourceSummaryList.add(resourceSummary);
        }
    }

    public static void validateResourcesAgainstOpenApi(List<String> tags, List<String> operations, Diagnostic.Kind kind, List<String> excludeTags, List<String> excludeOperations, List<ResourceSummary> resourceSummaryList, List<OpenAPIPathSummary> openAPISummaryList, OpenAPIComponentSummary openAPIComponentSummary, DiagnosticLog dLog) {
        boolean tagFilteringEnabled = tags.size() > 0;
        boolean operationFilteringEnabled = operations.size() > 0;
        boolean excludeTagsFilteringEnabled = excludeTags.size() > 0;
        boolean excludeOperationFilterEnable = excludeOperations.size() > 0;
        for (ResourceSummary resourceSummary : resourceSummaryList) {
            OpenAPIPathSummary openAPIPathSummary = ValidatorUtil.getOpenApiSummaryByPath(resourceSummary.getPath(), openAPISummaryList);
            if (openAPIPathSummary == null) {
                if (operationFilteringEnabled || tagFilteringEnabled || excludeOperationFilterEnable || excludeTagsFilteringEnabled) {
                    kind = Diagnostic.Kind.WARNING;
                }
                dLog.logDiagnostic(kind, resourceSummary.getPathPosition(), (CharSequence)ErrorMessages.undocumentedResourcePath(resourceSummary.getPath()));
                continue;
            }
            ArrayList<String> unmatchedMethods = new ArrayList<String>();
            if (operationFilteringEnabled || tagFilteringEnabled) continue;
            for (String resourceMethod : resourceSummary.getMethods()) {
                boolean noMatch = true;
                for (String method : openAPIPathSummary.getAvailableOperations()) {
                    if (!method.equals(resourceMethod)) continue;
                    noMatch = false;
                    break;
                }
                if (noMatch) {
                    unmatchedMethods.add(resourceMethod);
                }
                List<OpenAPIParameter> operationParamNames = openAPIPathSummary.getParamNamesForOperation(resourceMethod);
                List<ResourceParameter> resourceParamNames = resourceSummary.getParamNames();
                for (ResourceParameter parameter : resourceParamNames) {
                    boolean isExist = false;
                    for (OpenAPIParameter openAPIParameter : operationParamNames) {
                        if (parameter.getName().equals(resourceSummary.getBody())) {
                            isExist = true;
                            continue;
                        }
                        if (openAPIParameter.isTypeAvailableAsRef()) {
                            if (!parameter.getName().equals(openAPIParameter.getName())) continue;
                            isExist = true;
                            Schema schema = openAPIComponentSummary.getSchema(openAPIParameter.getLocalRef());
                            if (schema == null) continue;
                            isExist = ValidatorUtil.validateResourceAgainstOpenAPIParams(parameter, parameter.getParameter().symbol, schema, dLog, resourceMethod, resourceSummary.getPath(), kind);
                            continue;
                        }
                        if (!openAPIParameter.getName().equals(parameter.getName())) continue;
                        isExist = ValidatorUtil.validateResourceAgainstOpenAPIParams(parameter, parameter.getParameter().symbol, openAPIParameter.getParameter().getSchema(), dLog, resourceMethod, resourceSummary.getPath(), kind);
                    }
                    if (isExist) continue;
                    dLog.logDiagnostic(kind, (Diagnostic.DiagnosticPosition)parameter.getParameter().getPosition(), (CharSequence)ErrorMessages.undocumentedResourceParameter(parameter.getName(), resourceMethod, resourceSummary.getPath()));
                }
            }
            String methods = ValidatorUtil.getUnmatchedMethodList(unmatchedMethods);
            if (openAPIPathSummary.getAvailableOperations().containsAll(resourceSummary.getMethods())) continue;
            dLog.logDiagnostic(kind, resourceSummary.getMethodsPosition(), (CharSequence)ErrorMessages.undocumentedResourceMethods(methods, resourceSummary.getPath()));
        }
    }

    public static void validateOpenApiAgainstResources(ServiceNode serviceNode, List<String> tags, List<String> operations, Diagnostic.Kind kind, List<String> excludeTags, List<String> excludeOperations, List<ResourceSummary> resourceSummaryList, List<OpenAPIPathSummary> openAPISummaryList, OpenAPIComponentSummary openAPIComponentSummary, DiagnosticLog dLog) {
        boolean tagFilteringEnabled = tags.size() > 0;
        boolean operationFilteringEnabled = operations.size() > 0;
        boolean excludeTagsFilteringEnabled = excludeTags.size() > 0;
        boolean excludeOperationFilterEnabled = excludeOperations.size() > 0;
        for (OpenAPIPathSummary openApiSummary : openAPISummaryList) {
            List<ResourceSummary> resourceSummaries = ValidatorUtil.getResourceSummaryByPath(openApiSummary.getPath(), resourceSummaryList);
            if (resourceSummaries == null) {
                if (tagFilteringEnabled || operationFilteringEnabled || excludeTagsFilteringEnabled || excludeOperationFilterEnabled) {
                    if (operationFilteringEnabled) {
                        ValidatorUtil.operationsFilter(serviceNode, openApiSummary, operations, kind, Diagnostic.Kind.ERROR, Diagnostic.Kind.WARNING, dLog);
                    } else if (excludeOperationFilterEnabled) {
                        ValidatorUtil.operationsFilter(serviceNode, openApiSummary, excludeOperations, kind, Diagnostic.Kind.WARNING, Diagnostic.Kind.ERROR, dLog);
                    }
                    if (tagFilteringEnabled) {
                        ValidatorUtil.tagsFilter(serviceNode, openApiSummary, tags, kind, Diagnostic.Kind.ERROR, Diagnostic.Kind.WARNING, dLog);
                        continue;
                    }
                    if (!excludeTagsFilteringEnabled) continue;
                    ValidatorUtil.tagsFilter(serviceNode, openApiSummary, excludeTags, kind, Diagnostic.Kind.WARNING, Diagnostic.Kind.ERROR, dLog);
                    continue;
                }
                dLog.logDiagnostic(kind, ValidatorUtil.getServiceNamePosition(serviceNode), (CharSequence)ErrorMessages.unimplementedOpenAPIPath(openApiSummary.getPath()));
                continue;
            }
            List<String> allAvailableResourceMethods = ValidatorUtil.getAllMethodsInResourceSummaries(resourceSummaries);
            ArrayList<String> unmatchedMethods = new ArrayList<String>();
            if (operationFilteringEnabled) {
                if (tagFilteringEnabled) {
                    for (String method : openApiSummary.getAvailableOperations()) {
                        if (!openApiSummary.hasOperations(operations, method) || !openApiSummary.hasTags(tags, method)) continue;
                        ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode, kind);
                    }
                    if (unmatchedMethods.size() <= 0) continue;
                    ValidatorUtil.validateUnmatchedMethods(unmatchedMethods, serviceNode, kind, openApiSummary, dLog);
                    continue;
                }
                if (excludeTagsFilteringEnabled) {
                    for (String method : openApiSummary.getAvailableOperations()) {
                        if (!openApiSummary.hasOperations(operations, method) || openApiSummary.hasTags(excludeTags, method)) continue;
                        ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode, kind);
                    }
                    if (unmatchedMethods.size() <= 0) continue;
                    ValidatorUtil.validateUnmatchedMethods(unmatchedMethods, serviceNode, kind, openApiSummary, dLog);
                    continue;
                }
                for (String method : openApiSummary.getAvailableOperations()) {
                    if (!openApiSummary.hasOperations(operations, method)) continue;
                    ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode, kind);
                }
                if (unmatchedMethods.size() <= 0) continue;
                ValidatorUtil.validateUnmatchedMethods(unmatchedMethods, serviceNode, kind, openApiSummary, dLog);
                continue;
            }
            if (excludeOperationFilterEnabled) {
                if (excludeTagsFilteringEnabled) {
                    for (String method : openApiSummary.getAvailableOperations()) {
                        if (openApiSummary.hasOperations(excludeOperations, method) || openApiSummary.hasTags(excludeTags, method)) continue;
                        ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode, kind);
                    }
                    if (unmatchedMethods.size() <= 0) continue;
                    ValidatorUtil.validateUnmatchedMethods(unmatchedMethods, serviceNode, kind, openApiSummary, dLog);
                    continue;
                }
                if (tagFilteringEnabled) {
                    for (String method : openApiSummary.getAvailableOperations()) {
                        if (openApiSummary.hasOperations(excludeOperations, method) || !openApiSummary.hasTags(tags, method)) continue;
                        ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode, kind);
                    }
                    if (unmatchedMethods.size() <= 0) continue;
                    ValidatorUtil.validateUnmatchedMethods(unmatchedMethods, serviceNode, kind, openApiSummary, dLog);
                    continue;
                }
                for (String method : openApiSummary.getAvailableOperations()) {
                    if (openApiSummary.hasOperations(excludeOperations, method)) continue;
                    ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode, kind);
                }
                if (unmatchedMethods.size() <= 0) continue;
                ValidatorUtil.validateUnmatchedMethods(unmatchedMethods, serviceNode, kind, openApiSummary, dLog);
                continue;
            }
            if (excludeTagsFilteringEnabled) {
                for (String method : openApiSummary.getAvailableOperations()) {
                    if (openApiSummary.hasTags(excludeTags, method)) continue;
                    ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode, kind);
                }
                if (unmatchedMethods.size() <= 0) continue;
                ValidatorUtil.validateUnmatchedMethods(unmatchedMethods, serviceNode, kind, openApiSummary, dLog);
                continue;
            }
            if (tagFilteringEnabled) {
                for (String method : openApiSummary.getAvailableOperations()) {
                    if (!openApiSummary.hasTags(tags, method)) continue;
                    ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode, kind);
                }
                if (unmatchedMethods.size() <= 0) continue;
                ValidatorUtil.validateUnmatchedMethods(unmatchedMethods, serviceNode, kind, openApiSummary, dLog);
                continue;
            }
            for (String method : openApiSummary.getAvailableOperations()) {
                ValidatorUtil.validateOperationForOpenAPI(unmatchedMethods, allAvailableResourceMethods, resourceSummaries, method, openApiSummary, dLog, openAPIComponentSummary, serviceNode, kind);
            }
            String methods = ValidatorUtil.getUnmatchedMethodList(unmatchedMethods);
            if (allAvailableResourceMethods.containsAll(openApiSummary.getAvailableOperations())) continue;
            dLog.logDiagnostic(kind, ValidatorUtil.getServiceNamePosition(serviceNode), (CharSequence)ErrorMessages.unimplementedOpenAPIOperationsForPath(methods, openApiSummary.getPath()));
        }
    }

    private static String getUnmatchedMethodList(List<String> unmatchedMethods) {
        StringBuilder methods = new StringBuilder();
        for (int i = 0; i < unmatchedMethods.size(); ++i) {
            if (i == 0) {
                methods.append(unmatchedMethods.get(i));
                continue;
            }
            methods.append(", ").append(unmatchedMethods.get(i));
        }
        return methods.toString();
    }

    private static OpenAPIPathSummary getOpenApiSummaryByPath(String path, List<OpenAPIPathSummary> openAPISummaryList) {
        OpenAPIPathSummary openAPISummary = null;
        for (OpenAPIPathSummary openAPI : openAPISummaryList) {
            if (!openAPI.getPath().equals(path)) continue;
            openAPISummary = openAPI;
            break;
        }
        return openAPISummary;
    }

    private static void validateOperationForOpenAPI(List<String> unmatchedMethods, List<String> allAvailableResourceMethods, List<ResourceSummary> resourceSummaries, String method, OpenAPIPathSummary openApiSummary, DiagnosticLog dLog, OpenAPIComponentSummary openApiComponentSummary, ServiceNode serviceNode, Diagnostic.Kind kind) {
        boolean noMatch = true;
        for (String resourceMethod : allAvailableResourceMethods) {
            if (!resourceMethod.equals(method)) continue;
            noMatch = false;
            break;
        }
        if (noMatch) {
            unmatchedMethods.add(method);
        }
        ValidatorUtil.checkForParameterMismatch(openApiSummary, resourceSummaries, method, serviceNode, openApiComponentSummary, dLog, kind);
    }

    private static void checkForParameterMismatch(OpenAPIPathSummary openApiSummary, List<ResourceSummary> resourceSummaries, String method, ServiceNode serviceNode, OpenAPIComponentSummary openAPIComponentSummary, DiagnosticLog dLog, Diagnostic.Kind kind) {
        List<OpenAPIParameter> operationParamNames = openApiSummary.getParamNamesForOperation(method);
        ResourceSummary resourceSummaryForMethod = ValidatorUtil.getResourceSummaryByMethod(resourceSummaries, method);
        if (resourceSummaryForMethod != null) {
            List<ResourceParameter> resourceParamNames = resourceSummaryForMethod.getParamNames();
            for (OpenAPIParameter openAPIParameter : operationParamNames) {
                boolean isExist = false;
                ResourceParameter nonExistingResourceParameter = null;
                for (ResourceParameter parameter : resourceParamNames) {
                    if (openAPIParameter.isTypeAvailableAsRef()) {
                        if (openAPIParameter.getName().equals(parameter.getName())) {
                            isExist = true;
                            Schema schema = openAPIComponentSummary.getSchema(openAPIParameter.getLocalRef());
                            if (schema != null) {
                                isExist = ValidatorUtil.validateOpenAPIAgainResourceParams(parameter, parameter.getParameter().symbol, schema, dLog, method, openApiSummary.getPath(), kind);
                            }
                        }
                    } else if (openAPIParameter.getName().equals(parameter.getName())) {
                        isExist = ValidatorUtil.validateOpenAPIAgainResourceParams(parameter, parameter.getParameter().symbol, openAPIParameter.getParameter().getSchema(), dLog, method, openApiSummary.getPath(), kind);
                    }
                    if (isExist) continue;
                    nonExistingResourceParameter = parameter;
                }
                if (isExist) continue;
                if (nonExistingResourceParameter != null) {
                    dLog.logDiagnostic(kind, (Diagnostic.DiagnosticPosition)nonExistingResourceParameter.getParameter().getPosition(), (CharSequence)ErrorMessages.unimplementedParameterForOperation(openAPIParameter.getName(), method, resourceSummaryForMethod.getPath()));
                    continue;
                }
                dLog.logDiagnostic(kind, ValidatorUtil.getServiceNamePosition(serviceNode), (CharSequence)ErrorMessages.unimplementedParameterForOperation(openAPIParameter.getName(), method, resourceSummaryForMethod.getPath()));
            }
        }
    }

    private static boolean validateResourceAgainstOpenAPIParams(ResourceParameter resourceParameter, BVarSymbol resourceParameterType, Schema openAPIParam, DiagnosticLog dLog, String method, String path, Diagnostic.Kind kind) {
        BType resourceParamType = resourceParameterType.getType();
        if (resourceParamType.getKind().typeName().equals("record") && resourceParamType instanceof BRecordType && openAPIParam instanceof ObjectSchema) {
            Map<String, Schema> properties = ((ObjectSchema)openAPIParam).getProperties();
            BRecordType recordType = (BRecordType)resourceParamType;
            for (BField field : recordType.fields) {
                boolean isExist = false;
                for (Map.Entry<String, Schema> entry : properties.entrySet()) {
                    if (!entry.getKey().equals(field.name.getValue()) || !field.getType().getKind().typeName().equals(ValidatorUtil.convertOpenAPITypeToBallerina(entry.getValue().getType()))) continue;
                    isExist = true;
                    if (!ValidatorUtil.convertOpenAPITypeToBallerina(entry.getValue().getType()).equals("record")) continue;
                    isExist = ValidatorUtil.validateResourceAgainstOpenAPIParams(resourceParameter, field.symbol, entry.getValue(), dLog, method, path, kind);
                }
                if (isExist) continue;
                dLog.logDiagnostic(kind, (Diagnostic.DiagnosticPosition)field.pos, (CharSequence)ErrorMessages.undocumentedFieldInRecordParam(field.name.getValue(), resourceParameter.getName(), method, path));
            }
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("[]") && openAPIParam.getType().equals("array")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("string") && openAPIParam.getType().equals("string")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("int") && openAPIParam.getType().equals("integer")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("boolean") && openAPIParam.getType().equals("boolean")) {
            return true;
        }
        return resourceParamType.getKind().typeName().equals("decimal") && openAPIParam.getType().equals("number");
    }

    private static boolean validateOpenAPIAgainResourceParams(ResourceParameter resourceParam, BVarSymbol resourceParameterType, Schema openAPIParam, DiagnosticLog dLog, String operation, String path, Diagnostic.Kind kind) {
        BType resourceParamType = resourceParameterType.getType();
        if (resourceParamType.getKind().typeName().equals("record") && resourceParamType instanceof BRecordType && openAPIParam instanceof ObjectSchema) {
            Map<String, Schema> properties = ((ObjectSchema)openAPIParam).getProperties();
            BRecordType recordType = (BRecordType)resourceParamType;
            for (Map.Entry<String, Schema> entry : properties.entrySet()) {
                boolean isExist = false;
                for (BField field : recordType.fields) {
                    if (!entry.getKey().equals(field.name.getValue()) || !field.getType().getKind().typeName().equals(ValidatorUtil.convertOpenAPITypeToBallerina(entry.getValue().getType()))) continue;
                    isExist = true;
                    if (!ValidatorUtil.convertOpenAPITypeToBallerina(entry.getValue().getType()).equals("record")) continue;
                    isExist = ValidatorUtil.validateOpenAPIAgainResourceParams(resourceParam, field.symbol, entry.getValue(), dLog, operation, path, kind);
                }
                if (isExist) continue;
                dLog.logDiagnostic(kind, (Diagnostic.DiagnosticPosition)resourceParam.getParameter().getPosition(), (CharSequence)ErrorMessages.unimplementedFieldInOperation(entry.getKey(), resourceParam.getName(), operation, path));
            }
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("[]") && openAPIParam.getType().equals("array")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("string") && openAPIParam.getType().equals("string")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("int") && openAPIParam.getType().equals("integer")) {
            return true;
        }
        if (resourceParamType.getKind().typeName().equals("boolean") && openAPIParam.getType().equals("boolean")) {
            return true;
        }
        return resourceParamType.getKind().typeName().equals("decimal") && openAPIParam.getType().equals("number");
    }

    private static ResourceSummary getResourceSummaryByMethod(List<ResourceSummary> resourceSummaries, String method) {
        ResourceSummary matchingResource = null;
        for (ResourceSummary resourceSummary : resourceSummaries) {
            if (!resourceSummary.isMethodAvailable(method)) continue;
            matchingResource = resourceSummary;
            break;
        }
        return matchingResource;
    }

    private static List<String> getAllMethodsInResourceSummaries(List<ResourceSummary> resourceSummaries) {
        ArrayList<String> methods = new ArrayList<String>();
        for (ResourceSummary resourceSummary : resourceSummaries) {
            methods.addAll(resourceSummary.getMethods());
        }
        return methods;
    }

    private static List<ResourceSummary> getResourceSummaryByPath(String path, List<ResourceSummary> resourceSummaryList) {
        ArrayList<ResourceSummary> resourceSummaries = null;
        for (ResourceSummary resourceSummary : resourceSummaryList) {
            if (resourceSummary.getPath() == null || !resourceSummary.getPath().equals(path)) continue;
            if (resourceSummaries == null) {
                resourceSummaries = new ArrayList<ResourceSummary>();
                resourceSummaries.add(resourceSummary);
                continue;
            }
            resourceSummaries.add(resourceSummary);
        }
        return resourceSummaries;
    }

    private static String convertOpenAPITypeToBallerina(String type) {
        String convertedType;
        switch (type) {
            case "integer": {
                convertedType = "int";
                break;
            }
            case "string": {
                convertedType = "string";
                break;
            }
            case "boolean": {
                convertedType = "boolean";
                break;
            }
            case "array": {
                convertedType = "[]";
                break;
            }
            case "object": {
                convertedType = "record";
                break;
            }
            case "number": {
                convertedType = "decimal";
                break;
            }
            default: {
                convertedType = "";
            }
        }
        return convertedType;
    }

    private static Diagnostic.DiagnosticPosition getServiceNamePosition(ServiceNode serviceNode) {
        return serviceNode.getName().getPosition();
    }

    private static void tagsFilter(ServiceNode serviceNode, OpenAPIPathSummary openApiSummary, List<String> tags, Diagnostic.Kind kind, Diagnostic.Kind kind1, Diagnostic.Kind kind2, DiagnosticLog dLog) {
        for (String method : openApiSummary.getAvailableOperations()) {
            if (openApiSummary.hasTags(tags, method)) {
                kind = kind1;
                break;
            }
            kind = kind2;
        }
        dLog.logDiagnostic(kind, ValidatorUtil.getServiceNamePosition(serviceNode), (CharSequence)ErrorMessages.unimplementedOpenAPIPath(openApiSummary.getPath()));
    }

    private static void operationsFilter(ServiceNode serviceNode, OpenAPIPathSummary openApiSummary, List<String> operations, Diagnostic.Kind kind, Diagnostic.Kind kind1, Diagnostic.Kind kind2, DiagnosticLog dLog) {
        for (String method : openApiSummary.getAvailableOperations()) {
            if (openApiSummary.hasOperations(operations, method)) {
                kind = kind1;
                break;
            }
            kind = kind2;
        }
        dLog.logDiagnostic(kind, ValidatorUtil.getServiceNamePosition(serviceNode), (CharSequence)ErrorMessages.unimplementedOpenAPIPath(openApiSummary.getPath()));
    }

    private static void validateUnmatchedMethods(List<String> unmatchedMethods, ServiceNode serviceNode, Diagnostic.Kind kind, OpenAPIPathSummary openApiSummary, DiagnosticLog dLog) {
        String methods = ValidatorUtil.getUnmatchedMethodList(unmatchedMethods);
        dLog.logDiagnostic(kind, ValidatorUtil.getServiceNamePosition(serviceNode), (CharSequence)ErrorMessages.unimplementedOpenAPIOperationsForPath(methods, openApiSummary.getPath()));
    }
}

