/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.apacheds;

import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import org.apache.directory.server.configuration.MutableServerStartupConfiguration;
import org.apache.directory.server.core.configuration.MutablePartitionConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.core.configuration.SyncConfiguration;
import org.apache.directory.server.jndi.ServerContextFactory;
import org.apache.directory.server.ldap.LdapConfiguration;
import org.codehaus.plexus.apacheds.ApacheDs;
import org.codehaus.plexus.apacheds.Partition;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StoppingException;

public class DefaultApacheDs
extends AbstractLogEnabled
implements ApacheDs,
Startable {
    private boolean enableNetworking;
    private File basedir;
    private int port;
    private String password;
    private boolean stopped;
    private MutableServerStartupConfiguration configuration;
    private Set partitionConfigurations = new HashSet();

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setEnableNetworking(boolean enableNetworking) {
        this.enableNetworking = enableNetworking;
    }

    public InitialDirContext getAdminContext() throws NamingException {
        this.assertIsStarted();
        Hashtable<String, String> environment = new Hashtable<String, String>(this.configuration.toJndiEnvironment());
        environment.put("java.naming.factory.initial", ServerContextFactory.class.getName());
        environment.put("java.naming.security.principal", "uid=admin,ou=system");
        environment.put("java.naming.security.credentials", this.password);
        environment.put("java.naming.security.authentication", "simple");
        return new InitialDirContext(environment);
    }

    public InitialDirContext getSystemContext() throws NamingException {
        this.assertIsStarted();
        Hashtable<String, String> environment = new Hashtable<String, String>(this.configuration.toJndiEnvironment());
        environment.put("java.naming.factory.initial", ServerContextFactory.class.getName());
        environment.put("java.naming.security.principal", "uid=admin,ou=system");
        environment.put("java.naming.security.credentials", this.password);
        environment.put("java.naming.security.authentication", "simple");
        environment.put("java.naming.provider.url", "ou=system");
        return new InitialDirContext(environment);
    }

    public void addPartition(String name, String root, Set indexedAttributes, Attributes partitionAttributes) throws NamingException {
        MutablePartitionConfiguration configuration = new MutablePartitionConfiguration();
        configuration.setId(name);
        configuration.setSuffix(root);
        configuration.setIndexedAttributes(indexedAttributes);
        configuration.setContextEntry(partitionAttributes);
        this.partitionConfigurations.add(configuration);
    }

    public void addPartition(Partition partition) throws NamingException {
        MutablePartitionConfiguration configuration = new MutablePartitionConfiguration();
        configuration.setId(partition.getName());
        configuration.setSuffix(partition.getSuffix());
        configuration.setIndexedAttributes(partition.getIndexedAttributes());
        configuration.setContextEntry(partition.getContextAttributes());
        configuration.setCacheSize(1);
        this.partitionConfigurations.add(configuration);
    }

    public Partition addSimplePartition(String name, String[] domainComponents) throws NamingException {
        if (domainComponents.length == 0) {
            throw new NamingException("Illegal argument, there has to be at least one domain component.");
        }
        String suffix = "";
        for (int i = 0; i < domainComponents.length; ++i) {
            String dc = domainComponents[i];
            suffix = suffix + "dc=" + dc;
            if (i == domainComponents.length - 1) continue;
            suffix = suffix + ",";
        }
        BasicAttributes attributes = new BasicAttributes(true);
        attributes.put("dc", domainComponents[0]);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("domain");
        objectClass.add("extensibleObject");
        attributes.put(objectClass);
        Partition partition = new Partition();
        partition.setName(name);
        partition.setSuffix(suffix);
        partition.setContextAttributes(attributes);
        HashSet<String> set = new HashSet<String>();
        set.add("uid");
        set.add("cn");
        partition.setIndexedAttributes(set);
        this.addPartition(partition);
        return partition;
    }

    public void startServer() throws Exception {
        this.getLogger().info("Starting Apache Directory Server server.");
        this.getLogger().info("ApacheDS basedir: " + this.basedir.getAbsolutePath());
        File logs = new File(this.basedir, "logs");
        if (!logs.exists() && !logs.mkdirs()) {
            throw new Exception("Could not create logs directory: " + logs.getAbsolutePath());
        }
        Properties environment = new Properties();
        environment.setProperty("java.naming.security.authentication", "simple");
        environment.setProperty("java.naming.security.principal", "uid=admin,ou=system");
        environment.setProperty("java.naming.security.credentials", this.password);
        MutableServerStartupConfiguration configuration = new MutableServerStartupConfiguration();
        configuration.setWorkingDirectory(this.basedir);
        configuration.setAllowAnonymousAccess(true);
        LdapConfiguration config = new LdapConfiguration();
        config.setIpPort(this.port);
        configuration.setLdapConfiguration(config);
        configuration.setEnableNetworking(this.enableNetworking);
        configuration.setSynchPeriodMillis(100L);
        configuration.setPartitionConfigurations(this.partitionConfigurations);
        Properties env = new Properties();
        env.setProperty("java.naming.security.principal", "uid=admin,ou=system");
        env.setProperty("java.naming.security.credentials", this.password);
        env.setProperty("java.naming.security.authentication", "simple");
        env.setProperty("java.naming.provider.url", "ou=system");
        env.setProperty("java.naming.factory.initial", ServerContextFactory.class.getName());
        env.putAll((Map<?, ?>)configuration.toJndiEnvironment());
        InitialDirContext context = new InitialDirContext(env);
        this.configuration = configuration;
        this.getLogger().info("Started Apache Directory Server server.");
        this.stopped = false;
    }

    public void stopServer() throws Exception {
        if (this.stopped) {
            throw new Exception("Already stopped.");
        }
        this.getLogger().info("Stopping Apache Directory Server server.");
        this.sync();
        this.stopped = true;
        Hashtable env = new Hashtable();
        env.putAll(new ShutdownConfiguration().toJndiEnvironment());
        new InitialDirContext(env);
        this.getLogger().info("Apache Directory Server server stopped.");
    }

    public void sync() throws Exception {
        this.getLogger().info("Sync'ing Apache Directory Server server.");
        Hashtable env = new Hashtable();
        env.putAll(new SyncConfiguration().toJndiEnvironment());
        new InitialDirContext(env);
    }

    public void start() throws StartingException {
    }

    public void stop() throws StoppingException {
        try {
            if (!this.stopped) {
                this.stopServer();
            }
        }
        catch (Exception e) {
            throw new StoppingException("Error while stopping Apache Directory Server server.", (Throwable)e);
        }
    }

    private void assertIsStarted() throws NamingException {
        if (this.configuration == null) {
            throw new NamingException("The server has to be started before used.");
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

