/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.pipeline.valve;

import java.io.IOException;
import org.codehaus.plexus.summit.pipeline.valve.AbstractValve;
import org.codehaus.plexus.summit.pipeline.valve.ValveInvocationException;
import org.codehaus.plexus.summit.resolver.Resolver;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.summit.view.ViewContext;
import org.codehaus.plexus.util.ExceptionUtils;

public class DetermineTargetValve
extends AbstractValve {
    private Resolver resolver;

    public void invoke(RunData data) throws IOException, ValveInvocationException {
        if (data.hasError()) {
            data.setTarget(this.resolver.getErrorView());
            ViewContext viewContext = (ViewContext)data.getMap().get("viewContext");
            viewContext.put("stackTrace", ExceptionUtils.getFullStackTrace((Throwable)data.getError()));
        } else if (data.hasResultMessages()) {
            data.setTarget(this.resolver.getResultMessagesView());
            ViewContext viewContext = (ViewContext)data.getMap().get("viewContext");
            viewContext.put("resultMessages", data.getResultMessages());
        } else if (!data.hasTarget()) {
            String target = data.getParameters().getString("target");
            if (target == null) {
                target = data.getParameters().getString("view");
            }
            if (target != null) {
                data.setTarget(target);
            } else {
                target = this.resolver.getInitialView();
                data.setTarget(target);
            }
        }
    }
}

