/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.renderer;

import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.codehaus.plexus.summit.exception.SummitException;
import org.codehaus.plexus.summit.renderer.AbstractRenderer;
import org.codehaus.plexus.summit.renderer.VelocityContextAdapter;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.summit.view.ViewContext;
import org.codehaus.plexus.velocity.VelocityComponent;

public class VelocityRenderer
extends AbstractRenderer {
    private String encoding = "ISO-8859-1";
    private VelocityComponent velocity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RunData data, String view, Writer writer) throws SummitException, Exception {
        ViewContext viewContext = (ViewContext)data.getMap().get("viewContext");
        viewContext.put("data", data);
        VelocityContextAdapter vca = new VelocityContextAdapter(viewContext);
        try {
            if (!this.velocity.getEngine().templateExists(view)) {
                this.getLogger().error("Template " + view + " does note exist!");
                throw new Exception("Template " + view + " does note exist!");
            }
            Template template = this.velocity.getEngine().getTemplate(view);
            template.merge((Context)vca, writer);
        }
        catch (Throwable e) {
            if (e instanceof MethodInvocationException) {
                e = ((MethodInvocationException)e).getWrappedThrowable();
            }
            this.getLogger().error("Error rendering template: ", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean viewExists(String view) {
        return this.velocity.getEngine().templateExists(view);
    }
}

