/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.users.ldap.ctl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.codehaus.plexus.redback.common.ldap.LdapUser;
import org.codehaus.plexus.redback.common.ldap.LdapUserMapper;
import org.codehaus.plexus.redback.common.ldap.MappingException;
import org.codehaus.plexus.redback.common.ldap.UserMapper;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.ldap.LdapUserQuery;
import org.codehaus.plexus.redback.users.ldap.ctl.LdapController;
import org.codehaus.plexus.redback.users.ldap.ctl.LdapControllerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DefaultLdapController
implements LdapController {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource(name="userMapper#ldap")
    private UserMapper mapper;

    @Override
    public void removeUser(Object principal, DirContext context) throws LdapControllerException {
    }

    @Override
    public void updateUser(User user, DirContext context) throws LdapControllerException, MappingException {
    }

    @Override
    public boolean userExists(Object key, DirContext context) throws LdapControllerException {
        NamingEnumeration<SearchResult> results = null;
        try {
            results = this.searchUsers(key, context);
            boolean bl = results.hasMoreElements();
            return bl;
        }
        catch (NamingException e) {
            throw new LdapControllerException("Error searching for the existence of user: " + key, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {
                    this.log.warn("Error closing search results", (Throwable)e);
                }
            }
        }
    }

    protected NamingEnumeration<SearchResult> searchUsers(Object key, DirContext context) throws NamingException {
        LdapUserQuery query = new LdapUserQuery();
        query.setUsername("" + key);
        return this.searchUsers(context, null, query);
    }

    protected NamingEnumeration<SearchResult> searchUsers(DirContext context) throws NamingException {
        return this.searchUsers(context, null, null);
    }

    protected NamingEnumeration<SearchResult> searchUsers(DirContext context, String[] returnAttributes) throws NamingException {
        return this.searchUsers(context, returnAttributes, null);
    }

    protected NamingEnumeration<SearchResult> searchUsers(DirContext context, String[] returnAttributes, LdapUserQuery query) throws NamingException {
        if (query == null) {
            query = new LdapUserQuery();
        }
        SearchControls ctls = new SearchControls();
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(this.mapper.getReturningAttributes());
        ctls.setCountLimit(((LdapUserMapper)this.mapper).getMaxResultCount());
        String finalFilter = "(&(objectClass=" + this.mapper.getUserObjectClass() + ")" + (this.mapper.getUserFilter() != null ? this.mapper.getUserFilter() : "") + query.getLdapFilter(this.mapper) + ")";
        this.log.info("Searching for users with filter: '" + finalFilter + "'" + " from base dn: " + this.mapper.getUserBaseDn());
        return context.search(this.mapper.getUserBaseDn(), finalFilter, ctls);
    }

    @Override
    public Collection<User> getUsers(DirContext context) throws LdapControllerException, MappingException {
        NamingEnumeration<SearchResult> results = null;
        try {
            LinkedHashSet<User> result;
            results = this.searchUsers(context, null, null);
            LinkedHashSet<LdapUser> users = new LinkedHashSet<LdapUser>();
            while (results.hasMoreElements()) {
                result = (SearchResult)results.nextElement();
                users.add(this.mapper.getUser(((SearchResult)((Object)result)).getAttributes()));
            }
            result = users;
            return result;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap information for users.";
            throw new LdapControllerException(message, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {
                    this.log.warn("failed to close search results", (Throwable)e);
                }
            }
        }
    }

    @Override
    public List<User> getUsersByQuery(LdapUserQuery query, DirContext context) throws LdapControllerException, MappingException {
        NamingEnumeration<SearchResult> results = null;
        try {
            LinkedList<User> result;
            results = this.searchUsers(context, null, query);
            LinkedList<LdapUser> users = new LinkedList<LdapUser>();
            while (results.hasMoreElements()) {
                result = (SearchResult)results.nextElement();
                users.add(this.mapper.getUser(((SearchResult)((Object)result)).getAttributes()));
            }
            result = users;
            return result;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap information for users.";
            throw new LdapControllerException(message, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {
                    this.log.warn("failed to close search results", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void createUser(User user, DirContext context, boolean encodePasswordIfChanged) throws LdapControllerException, MappingException {
        if (user == null) {
            return;
        }
        if (user.getUsername().equals("guest")) {
            return;
        }
    }

    @Override
    public LdapUser getUser(Object key, DirContext context) throws LdapControllerException, MappingException {
        String username = key.toString();
        this.log.info("Searching for user: " + username);
        LdapUserQuery query = new LdapUserQuery();
        query.setUsername(username);
        NamingEnumeration<SearchResult> result = null;
        try {
            result = this.searchUsers(context, null, query);
            if (result.hasMoreElements()) {
                SearchResult next = (SearchResult)result.nextElement();
                LdapUser ldapUser = this.mapper.getUser(next.getAttributes());
                return ldapUser;
            }
            LdapUser next = null;
            return next;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve information for user: " + username;
            throw new LdapControllerException(message, e);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (NamingException e) {
                    this.log.warn("failed to close search results", (Throwable)e);
                }
            }
        }
    }
}

