package org.datanucleus.api.json;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.query.Query;
import org.json.JSONObject;

public interface JsonAPI
{

    MetaDataManager getMetaDataManager();

    ClassLoaderResolver getClassLoaderResolver();

    JsonAPITransaction getTransaction();

    /**
     * JSON objects must have the key "class", which links to the ClassMetaData definition 
     * @param obj
     */
    void persist(JSONObject obj);

    Query newQuery(String language, String query);

    JSONObject findObject(JSONObject id);

    void deleteObject(JSONObject id);

    void close();

}