package org.datanucleus.api.json;

import java.util.Set;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.ActivityState;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.state.RelationshipManagerImpl;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonAPIObjectProvider implements ObjectProvider
{

    ExecutionContext ec;

    AbstractClassMetaData acmd;

    JSONObject obj;

    public JsonAPIObjectProvider(ExecutionContext ec, AbstractClassMetaData acmd, JSONObject obj)
    {
        this.ec = ec;
        this.acmd = acmd;
        this.obj = obj;
    }

    public AbstractClassMetaData getClassMetaData()
    {
        return acmd;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.ObjectProvider#replaceFieldValue(int, java.lang.Object)
     */
    public void replaceFieldValue(int fieldNumber, Object value)
    {
        // TODO Auto-generated method stub
        
    }

    public void replaceField(int fieldNumber, Object value)
    {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try
        {
            obj.put(ammd.getName(), obj);
        }
        catch (JSONException e)
        {
            e.printStackTrace();
        }
    }

    public void replaceFields(int[] fieldNumbers, FieldManager fm)
    {
        for (int i = 0; i < fieldNumbers.length; i++)
        {
            AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            try
            {
                obj.put(ammd.getName(), fm.fetchObjectField(fieldNumbers[i]));
            }
            catch (JSONException e)
            {
                e.printStackTrace();
            }
        }
    }

    public void replaceNonLoadedFields(int[] fieldNumbers, FieldManager fm)
    {
        for (int i = 0; i < fieldNumbers.length; i++)
        {
            AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            try
            {
                obj.put(ammd.getName(), fm.fetchObjectField(fieldNumbers[i]));
            }
            catch (JSONException e)
            {
                e.printStackTrace();
            }
        }
    }

    public void provideFields(int[] fieldNumbers, FieldManager fm)
    {
        for (int i = 0; i < fieldNumbers.length; i++)
        {
            AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            try
            {
                if (obj.isNull(ammd.getName()))
                {
                    fm.storeObjectField(fieldNumbers[i], null);
                }
                else
                {
                    fm.storeObjectField(fieldNumbers[i], obj.get(ammd.getName()));
                }
            }
            catch (JSONException e)
            {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    public Object provideField(int fieldNumber)
    {
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        try
        {
            if (obj.isNull(ammd.getName()))
            {
                return null;
            }
            else
            {
                return obj.get(ammd.getName());
            }
        }
        catch (JSONException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    public ExecutionContext getExecutionContext()
    {
        return ec;
    }

    public Object wrapSCOField(int fieldNumber, Object value, boolean forInsert, boolean forUpdate, boolean replaceFieldIfChanged)
    {
        return value;
    }

    public Object getObject()
    {
        return obj;
    }

    public String toPrintableID()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public Object getInternalObjectId()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public Object getExternalObjectId()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void setAssociatedValue(Object key, Object value)
    {
        // TODO Auto-generated method stub

    }

    public void loadUnloadedFields()
    {
        // TODO Auto-generated method stub

    }

    public int[] getDirtyFieldNumbers()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public String[] getDirtyFieldNames()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void makeDirty(int field)
    {
        // TODO Auto-generated method stub

    }

    public boolean isInserting()
    {
        // TODO Auto-generated method stub
        return false;
    }

    public ObjectProvider[] getEmbeddedOwners()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public LifeCycleState getLifecycleState()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void addEmbeddedOwner(ObjectProvider ownerSM, int ownerFieldNumber)
    {
        // TODO Auto-generated method stub

    }

    public boolean isEmbedded()
    {
        // TODO Auto-generated method stub
        return false;
    }

    public void copyFieldsFromObject(Object pc, int[] fieldNumbers)
    {
        // TODO Auto-generated method stub

    }

    public Object getTransactionalVersion()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public Object unwrapSCOField(int fieldNumber, Object value, boolean b)
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void replaceFieldMakeDirty(int fieldNumber, Object object)
    {
        // TODO Auto-generated method stub

    }

    public boolean[] getLoadedFields()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void runReachability(Set reachables)
    {
        // TODO Auto-generated method stub

    }

    public void setPcObjectType(short objectType)
    {
        // TODO Auto-generated method stub

    }

    public void setStoringPC()
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.ObjectProvider#isFlushedToDatastore()
     */
    public boolean isFlushedToDatastore()
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.ObjectProvider#isFlushedNew()
     */
    public boolean isFlushedNew()
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.ObjectProvider#setFlushedNew(boolean)
     */
    public void setFlushedNew(boolean flag)
    {
        // TODO Auto-generated method stub
        
    }

    public void flush()
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.ObjectProvider#setFlushing(boolean)
     */
    public void setFlushing(boolean flushing)
    {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.ObjectProvider#markAsFlushed()
     */
    public void markAsFlushed()
    {
        // TODO Auto-generated method stub
        
    }

    public boolean isWaitingToBeFlushedToDatastore()
    {
        // TODO Auto-generated method stub
        return false;
    }

    public boolean isDeleting()
    {
        // TODO Auto-generated method stub
        return false;
    }

    public void loadFieldValues(FieldValues fieldValues)
    {
        // TODO Auto-generated method stub

    }

    public RelationshipManagerImpl getRelationshipManager()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public Object getReferencedPC()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void unsetStoringPC()
    {
        // TODO Auto-generated method stub

    }

    public void loadField(int fieldNumber)
    {
        // TODO Auto-generated method stub

    }

    public boolean isLoaded(int absoluteFieldNumber)
    {
        // TODO Auto-generated method stub
        return false;
    }

    public void setTransactionalVersion(Object nextVersion)
    {
        // TODO Auto-generated method stub

    }

    public void replaceFields(int[] fieldNumbers, FieldManager fm, boolean b)
    {
        // TODO Auto-generated method stub

    }

    public void setVersion(Object version)
    {
        // TODO Auto-generated method stub

    }

    public int[] getLoadedFieldNumbers()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void updateFieldAfterInsert(Object persistable, int fieldNumber)
    {
        // TODO Auto-generated method stub

    }

    public void setPostStoreNewObjectId(Object newId)
    {
        // TODO Auto-generated method stub

    }

    public void changeActivityState(ActivityState inserting)
    {
        // TODO Auto-generated method stub

    }

    public Object getAssociatedValue(Object key)
    {
        // TODO Auto-generated method stub
        return null;
    }

    public boolean becomingDeleted()
    {
        // TODO Auto-generated method stub
        return false;
    }

    public void loadFieldsInFetchPlan(FetchPlanState state)
    {
        // TODO Auto-generated method stub

    }

    public void loadFieldFromDatastore(int fieldNumber)
    {
        // TODO Auto-generated method stub

    }

    public Object getObjectId()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public Object getVersion()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void unloadField(String name)
    {
        // TODO Auto-generated method stub

    }

    public void replaceAllLoadedSCOFieldsWithWrappers()
    {
        // TODO Auto-generated method stub

    }

    public void replaceAllLoadedSCOFieldsWithValues()
    {
        // TODO Auto-generated method stub

    }

    public boolean getAllFieldsLoaded()
    {
        // TODO Auto-generated method stub
        return false;
    }

    public void replaceManagedPC(Object pc2)
    {
        // TODO Auto-generated method stub

    }

    public String[] getLoadedFieldNames()
    {
        // TODO Auto-generated method stub
        return null;
    }

    public short getLockMode()
    {
        // TODO Auto-generated method stub
        return 0;
    }

    public void unlock()
    {
        // TODO Auto-generated method stub

    }

    public void locate()
    {
        // TODO Auto-generated method stub

    }

    public void lock(short lockMode)
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.ObjectProvider#isFieldLoaded(int)
     */
    public boolean isFieldLoaded(int fieldNumber)
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.ObjectProvider#getDirtyFields()
     */
    public boolean[] getDirtyFields()
    {
        // TODO Auto-generated method stub
        return null;
    }

}