/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.util.IoUtils;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;

public class LocalRuleExecutionSetProviderImpl
implements LocalRuleExecutionSetProvider {
    public RuleExecutionSet createRuleExecutionSet(InputStream ruleExecutionSetStream, Map properties) throws RuleExecutionSetCreateException {
        if (properties != null) {
            String source = (String)properties.get("javax.rules.admin.RuleExecutionSet.source");
            if (source == null) {
                source = (String)properties.get("source");
            }
            if (source != null && source.equals("javax.rules.admin.RuleExecutionSet.source.decisiontable")) {
                SpreadsheetCompiler converter = new SpreadsheetCompiler();
                String drl = converter.compile(ruleExecutionSetStream, InputType.XLS);
                return this.createRuleExecutionSet(new StringReader(drl), properties);
            }
            return this.createRuleExecutionSet(new InputStreamReader(ruleExecutionSetStream, IoUtils.UTF8_CHARSET), properties);
        }
        return this.createRuleExecutionSet(new InputStreamReader(ruleExecutionSetStream, IoUtils.UTF8_CHARSET), properties);
    }

    public RuleExecutionSet createRuleExecutionSet(Reader ruleExecutionSetReader, Map properties) throws RuleExecutionSetCreateException {
        try {
            KnowledgeBuilderConfigurationImpl config = null;
            if (properties != null) {
                config = (KnowledgeBuilderConfigurationImpl)properties.get("javax.rules.admin.RuleExecutionSet.packageBuilderConfiguration");
            }
            KnowledgeBuilderImpl builder = null;
            builder = config != null ? new KnowledgeBuilderImpl(config) : new KnowledgeBuilderImpl();
            Object dsrl = null;
            String source = null;
            if (properties != null) {
                dsrl = properties.get("javax.rules.admin.RuleExecutionSet.dsl");
                if (dsrl == null) {
                    dsrl = properties.get("dsl");
                }
                if ((source = (String)properties.get("javax.rules.admin.RuleExecutionSet.source")) == null) {
                    source = (String)properties.get("source");
                }
            }
            if (source == null) {
                source = "drl";
            }
            if (dsrl == null) {
                if (source.equals("javax.rules.admin.RuleExecutionSet.source.xml") || source.equals("xml")) {
                    builder.addPackageFromXml(ruleExecutionSetReader);
                } else {
                    builder.addPackageFromDrl(ruleExecutionSetReader);
                }
            } else if (source.equals("javax.rules.admin.RuleExecutionSet.source.xml") || source.equals("xml")) {
                builder.addPackageFromXml(ruleExecutionSetReader);
            } else if (dsrl instanceof Reader) {
                builder.addPackageFromDrl(ruleExecutionSetReader, (Reader)dsrl);
            } else {
                builder.addPackageFromDrl(ruleExecutionSetReader, (Reader)new StringReader(dsrl));
            }
            InternalKnowledgePackage pkg = builder.getPackageNames().stream().map(arg_0 -> ((KnowledgeBuilderImpl)builder).getPackage(arg_0)).filter(p -> !p.getRules().isEmpty()).findFirst().get();
            return this.createRuleExecutionSet(pkg, properties);
        }
        catch (IOException e) {
            throw new RuleExecutionSetCreateException("cannot create rule execution set", (Exception)e);
        }
        catch (DroolsParserException e) {
            throw new RuleExecutionSetCreateException("cannot create rule execution set", (Exception)((Object)e));
        }
    }

    public RuleExecutionSet createRuleExecutionSet(Object ruleExecutionSetAst, Map properties) throws RuleExecutionSetCreateException {
        if (ruleExecutionSetAst instanceof InternalKnowledgePackage) {
            InternalKnowledgePackage pkg = (InternalKnowledgePackage)ruleExecutionSetAst;
            return this.createRuleExecutionSet(pkg, properties);
        }
        throw new RuleExecutionSetCreateException(" Incoming AST object must be an org.kie.rule.Package.  Was " + ruleExecutionSetAst.getClass());
    }

    private RuleExecutionSet createRuleExecutionSet(InternalKnowledgePackage pkg, Map properties) throws RuleExecutionSetCreateException {
        try {
            return new RuleExecutionSetImpl(pkg, properties);
        }
        catch (Exception e) {
            throw new RuleExecutionSetCreateException("Failed to create RuleExecutionSet", e);
        }
    }
}

