/*
 * Decompiled with CFR 0.152.
 */
package org.easyb.maven;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.NoBannerLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.launch.Locator;

public class AntProject
extends Project {
    public AntProject() {
        NoBannerLogger logger = new NoBannerLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        this.addBuildListener((BuildListener)logger);
        this.init();
        this.getBaseDir();
    }

    public void initProperties() throws BuildException {
        this.setJavaVersionProperty();
        this.setSystemProperties();
        this.setPropertyInternal("ant.version", Main.getAntVersion());
        this.setAntLibCorrectly();
    }

    private void setPropertyInternal(String name, String value) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        ph.setProperty(null, name, (Object)value, false);
    }

    private void setAntLibCorrectly() {
        File antlib = AntProject.getClassSource(Project.class);
        if (antlib != null) {
            this.setPropertyInternal("ant.core.lib", antlib.getAbsolutePath());
        }
    }

    public static File getClassSource(Class c) {
        String classResource = c.getName().replace('.', '/') + ".class";
        try {
            classResource = URLEncoder.encode(classResource, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return Locator.getResourceSource((ClassLoader)c.getClassLoader(), (String)classResource);
    }
}

