/*
 * Decompiled with CFR 0.152.
 */
package org.easyb.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.easyb.maven.EasybExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasybMojo
extends AbstractMojo {
    MavenProject project;
    ArtifactFactory artifactFactory;
    ArtifactResolver resolver;
    private String pluginVersion;
    private ArtifactRepository localRepository;
    private ArtifactMetadataSource metadataSource;
    private List remoteRepositories;
    private List pluginArtifacts;
    String xmlReport;
    String test;
    String storyType;
    String storyReport;
    File easybTestDirectory;
    List<String> includes;
    boolean parallel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.buildExecutor().execute();
    }

    private EasybExecutor buildExecutor() {
        return new EasybExecutor(this);
    }

    private Artifact findEasybArtifact(List pluginArtifacts) throws MojoExecutionException {
        Artifact easybArtifact = null;
        Iterator artifacts = pluginArtifacts.iterator();
        while (artifacts.hasNext() && easybArtifact == null) {
            Artifact artifact = (Artifact)artifacts.next();
            if (!"org.easyb".equals(artifact.getGroupId()) || !"easyb".equals(artifact.getArtifactId())) continue;
            easybArtifact = artifact;
        }
        if (easybArtifact == null) {
            throw new MojoExecutionException("Couldn't find [org.easyb:easyb] artifact in plugin dependencies");
        }
        return easybArtifact;
    }

    List<String> easybDependencies() throws ArtifactResolutionException, ArtifactNotFoundException, MojoExecutionException {
        Artifact mojoArtifact = this.artifactFactory.createBuildArtifact("org.easyb", "maven-easyb-plugin", this.pluginVersion, "jar");
        Artifact easybArtifact = this.findEasybArtifact(this.pluginArtifacts);
        easybArtifact = this.artifactFactory.createArtifact(easybArtifact.getGroupId(), easybArtifact.getArtifactId(), easybArtifact.getVersion(), "compile", easybArtifact.getType());
        ArtifactResolutionResult resolutionResult = this.resolver.resolveTransitively(Collections.singleton(easybArtifact), mojoArtifact, Collections.EMPTY_LIST, this.localRepository, this.metadataSource);
        this.getLog().debug((CharSequence)("Using easyb " + easybArtifact));
        ArrayList<String> dependencies = new ArrayList<String>();
        for (Object each : resolutionResult.getArtifacts()) {
            Artifact artifact = (Artifact)each;
            this.getLog().info((CharSequence)("Using easyb dependency " + artifact));
            dependencies.add(artifact.getFile().getAbsolutePath());
        }
        return dependencies;
    }
}

