/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.connector.basic.ArtifactTransportListener;
import org.eclipse.aether.connector.basic.ChecksumCalculator;
import org.eclipse.aether.connector.basic.MetadataTransportListener;
import org.eclipse.aether.connector.basic.PartialFile;
import org.eclipse.aether.connector.basic.TransferTransportListener;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactTransfer;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataTransfer;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.spi.connector.transport.GetTask;
import org.eclipse.aether.spi.connector.transport.PeekTask;
import org.eclipse.aether.spi.connector.transport.PutTask;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.concurrency.RunnableErrorForwarder;
import org.eclipse.aether.util.concurrency.WorkerThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BasicRepositoryConnector
implements RepositoryConnector {
    private static final String PROP_THREADS = "aether.connector.basic.threads";
    private static final String PROP_RESUME = "aether.connector.resumeDownloads";
    private static final String PROP_RESUME_THRESHOLD = "aether.connector.resumeThreshold";
    private static final String PROP_SMART_CHECKSUMS = "aether.connector.smartChecksums";
    private final Logger logger;
    private final FileProcessor fileProcessor;
    private final RemoteRepository repository;
    private final RepositorySystemSession session;
    private final Transporter transporter;
    private final RepositoryLayout layout;
    private final PartialFile.Factory partialFileFactory;
    private final int maxThreads;
    private final boolean smartChecksums;
    private Executor executor;
    private boolean closed;

    public BasicRepositoryConnector(RepositorySystemSession session, RemoteRepository repository, TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, FileProcessor fileProcessor, Logger logger) throws NoRepositoryConnectorException {
        try {
            this.layout = layoutProvider.newRepositoryLayout(session, repository);
        }
        catch (NoRepositoryLayoutException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), (Throwable)e);
        }
        try {
            this.transporter = transporterProvider.newTransporter(session, repository);
        }
        catch (NoTransporterException e) {
            throw new NoRepositoryConnectorException(repository, e.getMessage(), (Throwable)e);
        }
        this.session = session;
        this.repository = repository;
        this.fileProcessor = fileProcessor;
        this.logger = logger;
        this.maxThreads = ConfigUtils.getInteger((RepositorySystemSession)session, (int)5, (String[])new String[]{PROP_THREADS, "maven.artifact.threads"});
        this.smartChecksums = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{PROP_SMART_CHECKSUMS});
        boolean resumeDownloads = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.connector.resumeDownloads." + repository.getId(), PROP_RESUME});
        long resumeThreshold = ConfigUtils.getLong((RepositorySystemSession)session, (long)65536L, (String[])new String[]{"aether.connector.resumeThreshold." + repository.getId(), PROP_RESUME_THRESHOLD});
        int requestTimeout = ConfigUtils.getInteger((RepositorySystemSession)session, (int)1800000, (String[])new String[]{"aether.connector.requestTimeout." + repository.getId(), "aether.connector.requestTimeout"});
        this.partialFileFactory = new PartialFile.Factory(resumeDownloads, resumeThreshold, requestTimeout, logger);
    }

    private Executor getExecutor(Collection<?> artifacts, Collection<?> metadatas) {
        if (this.maxThreads <= 1) {
            return DirectExecutor.INSTANCE;
        }
        int tasks = BasicRepositoryConnector.safe(artifacts).size() + BasicRepositoryConnector.safe(metadatas).size();
        if (tasks <= 1) {
            return DirectExecutor.INSTANCE;
        }
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(this.maxThreads, this.maxThreads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new WorkerThreadFactory(this.getClass().getSimpleName() + '-' + this.repository.getHost() + '-'));
        }
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).shutdown();
            }
            this.transporter.close();
        }
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        TaskRunner task;
        TransferTransportListener listener;
        TransferEvent.Builder builder;
        List checksums;
        URI location;
        if (this.closed) {
            throw new IllegalStateException("connector closed");
        }
        Executor executor = this.getExecutor(artifactDownloads, metadataDownloads);
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        for (MetadataDownload metadataDownload : BasicRepositoryConnector.safe(metadataDownloads)) {
            location = this.layout.getLocation(metadataDownload.getMetadata(), false);
            checksums = "ignore".equals(metadataDownload.getChecksumPolicy()) ? null : this.layout.getChecksums(metadataDownload.getMetadata(), false, location);
            builder = this.newEventBuilder(location, metadataDownload.getFile(), false, false, metadataDownload.getTrace());
            listener = new MetadataTransportListener((MetadataTransfer)metadataDownload, this.repository, builder);
            task = new GetTaskRunner(location, metadataDownload.getFile(), metadataDownload.getChecksumPolicy(), checksums, listener);
            executor.execute(errorForwarder.wrap((Runnable)task));
        }
        for (ArtifactDownload artifactDownload : BasicRepositoryConnector.safe(artifactDownloads)) {
            location = this.layout.getLocation(artifactDownload.getArtifact(), false);
            checksums = "ignore".equals(artifactDownload.getChecksumPolicy()) ? null : this.layout.getChecksums(artifactDownload.getArtifact(), false, location);
            builder = this.newEventBuilder(location, artifactDownload.getFile(), false, artifactDownload.isExistenceCheck(), artifactDownload.getTrace());
            listener = new ArtifactTransportListener((ArtifactTransfer)artifactDownload, this.repository, builder);
            task = artifactDownload.isExistenceCheck() ? new PeekTaskRunner(location, listener) : new GetTaskRunner(location, artifactDownload.getFile(), artifactDownload.getChecksumPolicy(), checksums, listener);
            executor.execute(errorForwarder.wrap((Runnable)task));
        }
        errorForwarder.await();
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        PutTaskRunner task;
        TransferTransportListener listener;
        TransferEvent.Builder builder;
        List checksums;
        URI location;
        if (this.closed) {
            throw new IllegalStateException("connector closed");
        }
        for (ArtifactUpload artifactUpload : BasicRepositoryConnector.safe(artifactUploads)) {
            location = this.layout.getLocation(artifactUpload.getArtifact(), true);
            checksums = this.layout.getChecksums(artifactUpload.getArtifact(), true, location);
            builder = this.newEventBuilder(location, artifactUpload.getFile(), true, false, artifactUpload.getTrace());
            listener = new ArtifactTransportListener((ArtifactTransfer)artifactUpload, this.repository, builder);
            task = new PutTaskRunner(location, artifactUpload.getFile(), checksums, listener);
            task.run();
        }
        for (MetadataUpload metadataUpload : BasicRepositoryConnector.safe(metadataUploads)) {
            location = this.layout.getLocation(metadataUpload.getMetadata(), true);
            checksums = this.layout.getChecksums(metadataUpload.getMetadata(), true, location);
            builder = this.newEventBuilder(location, metadataUpload.getFile(), true, false, metadataUpload.getTrace());
            listener = new MetadataTransportListener((MetadataTransfer)metadataUpload, this.repository, builder);
            task = new PutTaskRunner(location, metadataUpload.getFile(), checksums, listener);
            task.run();
        }
    }

    private static <T> Collection<T> safe(Collection<T> items) {
        return items != null ? items : Collections.emptyList();
    }

    private TransferEvent.Builder newEventBuilder(URI path, File file, boolean upload, boolean peek, RequestTrace trace) {
        TransferResource resource = new TransferResource(this.repository.getUrl(), path.toString(), file, trace);
        TransferEvent.Builder builder = new TransferEvent.Builder(this.session, resource);
        if (upload) {
            builder.setRequestType(TransferEvent.RequestType.PUT);
        } else if (!peek) {
            builder.setRequestType(TransferEvent.RequestType.GET);
        } else {
            builder.setRequestType(TransferEvent.RequestType.GET_EXISTENCE);
        }
        return builder;
    }

    public String toString() {
        return String.valueOf(this.repository);
    }

    private static class DirectExecutor
    implements Executor {
        static final Executor INSTANCE = new DirectExecutor();

        private DirectExecutor() {
        }

        public void execute(Runnable command) {
            command.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PutTaskRunner
    extends TaskRunner {
        private final File file;
        private final Collection<RepositoryLayout.Checksum> checksums;

        public PutTaskRunner(URI path, File file, List<RepositoryLayout.Checksum> checksums, TransferTransportListener<?> listener) {
            super(path, listener);
            this.file = file;
            this.checksums = BasicRepositoryConnector.safe(checksums);
        }

        @Override
        protected void runTask() throws Exception {
            if (this.file == null) {
                throw new IllegalArgumentException("source file has not been specified");
            }
            BasicRepositoryConnector.this.transporter.put(new PutTask(this.path).setDataFile(this.file).setListener((TransportListener)this.listener));
            this.uploadChecksums(this.file, this.path);
        }

        private void uploadChecksums(File file, URI location) {
            if (this.checksums.isEmpty()) {
                return;
            }
            try {
                HashSet<String> algos = new HashSet<String>();
                for (RepositoryLayout.Checksum checksum : this.checksums) {
                    algos.add(checksum.getAlgorithm());
                }
                Map sumsByAlgo = ChecksumUtils.calc((File)file, algos);
                for (RepositoryLayout.Checksum checksum : this.checksums) {
                    this.uploadChecksum(checksum.getLocation(), sumsByAlgo.get(checksum.getAlgorithm()));
                }
            }
            catch (IOException e) {
                String msg = "Failed to upload checksums for " + file + ": " + e.getMessage();
                if (BasicRepositoryConnector.this.logger.isDebugEnabled()) {
                    BasicRepositoryConnector.this.logger.warn(msg, (Throwable)e);
                }
                BasicRepositoryConnector.this.logger.warn(msg);
            }
        }

        private void uploadChecksum(URI location, Object checksum) {
            try {
                if (checksum instanceof Exception) {
                    throw (Exception)checksum;
                }
                BasicRepositoryConnector.this.transporter.put(new PutTask(location).setDataString((String)checksum));
            }
            catch (Exception e) {
                String msg = "Failed to upload checksum " + location + ": " + e.getMessage();
                if (BasicRepositoryConnector.this.logger.isDebugEnabled()) {
                    BasicRepositoryConnector.this.logger.warn(msg, (Throwable)e);
                }
                BasicRepositoryConnector.this.logger.warn(msg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GetTaskRunner
    extends TaskRunner
    implements PartialFile.RemoteAccessChecker {
        private final File file;
        private final String checksumPolicy;
        private final Collection<RepositoryLayout.Checksum> checksums;

        public GetTaskRunner(URI path, File file, String checksumPolicy, List<RepositoryLayout.Checksum> checksums, TransferTransportListener<?> listener) {
            super(path, listener);
            this.file = file;
            this.checksumPolicy = checksumPolicy;
            this.checksums = BasicRepositoryConnector.safe(checksums);
        }

        @Override
        public void checkRemoteAccess() throws Exception {
            BasicRepositoryConnector.this.transporter.peek(new PeekTask(this.path));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runTask() throws Exception {
            if (this.file == null) {
                throw new IllegalArgumentException("destination file has not been specified");
            }
            BasicRepositoryConnector.this.fileProcessor.mkdirs(this.file.getParentFile());
            PartialFile partFile = BasicRepositoryConnector.this.partialFileFactory.newInstance(this.file, this);
            if (partFile == null) {
                BasicRepositoryConnector.this.logger.debug("Concurrent download of " + this.file + " just finished, skipping download");
                return;
            }
            try {
                File tmp = partFile.getFile();
                this.listener.setChecksums(ChecksumCalculator.newInstance(tmp, this.checksums));
                int firstTrial = 0;
                int lastTrial = 1;
                for (int trial = firstTrial; trial <= lastTrial; ++trial) {
                    boolean resume = partFile.isResume() && trial <= firstTrial;
                    GetTask task = new GetTask(this.path).setDataFile(tmp, resume).setListener((TransportListener)this.listener);
                    BasicRepositoryConnector.this.transporter.get(task);
                    try {
                        if (!this.verifyChecksums(task.getChecksums())) {
                            trial = lastTrial;
                            throw new ChecksumFailureException("Checksum validation failed, no checksums available from the repository");
                        }
                        break;
                    }
                    catch (ChecksumFailureException e) {
                        if (trial >= lastTrial && "fail".equals(this.checksumPolicy)) {
                            throw e;
                        }
                        this.listener.transferCorrupted((Exception)((Object)e));
                        continue;
                    }
                }
                BasicRepositoryConnector.this.fileProcessor.move(tmp, this.file);
            }
            finally {
                partFile.close();
            }
        }

        private File newTempFile(File path) throws IOException {
            return File.createTempFile(path.getName() + "-" + UUID.randomUUID().toString().replace("-", ""), ".tmp", path.getParentFile());
        }

        private void delTempFile(File path) {
            if (path != null && !path.delete() && path.exists()) {
                BasicRepositoryConnector.this.logger.debug("Could not delete temorary file " + path);
            }
        }

        private boolean verifyChecksums(Map<String, String> inlinedChecksums) throws ChecksumFailureException {
            ChecksumCalculator calculator = this.listener.getChecksums();
            if (calculator == null) {
                return true;
            }
            Map<String, Object> sumsByAlgo = calculator.get();
            for (RepositoryLayout.Checksum checksum : this.checksums) {
                Object actual = sumsByAlgo.get(checksum.getAlgorithm());
                String inlinedChecksum = inlinedChecksums.get(checksum.getAlgorithm());
                if (actual == null || !this.verifyChecksum(checksum, actual, inlinedChecksum)) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean verifyChecksum(RepositoryLayout.Checksum checksum, Object actual, String inlinedChecksum) throws ChecksumFailureException {
            String ext = checksum.getAlgorithm().replace("-", "").toLowerCase(Locale.ENGLISH);
            File checksumFile = new File(this.file.getPath() + '.' + ext);
            if (actual instanceof Exception) {
                throw new ChecksumFailureException((Throwable)((Exception)actual));
            }
            String act = String.valueOf(actual);
            if (BasicRepositoryConnector.this.smartChecksums && inlinedChecksum != null && inlinedChecksum.equalsIgnoreCase(act)) {
                try {
                    BasicRepositoryConnector.this.fileProcessor.write(checksumFile, inlinedChecksum);
                    return true;
                }
                catch (IOException e) {
                    BasicRepositoryConnector.this.logger.debug("Failed to write checksum file " + checksumFile + ": " + e.getMessage(), (Throwable)e);
                }
                return true;
            }
            File tmp = null;
            try {
                tmp = this.newTempFile(checksumFile);
                try {
                    BasicRepositoryConnector.this.transporter.get(new GetTask(checksum.getLocation()).setDataFile(tmp));
                }
                catch (Exception e) {
                    if (BasicRepositoryConnector.this.transporter.classify((Throwable)e) != 1) throw new ChecksumFailureException((Throwable)e);
                    boolean bl = false;
                    this.delTempFile(tmp);
                    return bl;
                }
                String expected = ChecksumUtils.read((File)tmp);
                if (!expected.equalsIgnoreCase(act)) throw new ChecksumFailureException(expected, act);
            }
            catch (IOException e) {
                throw new ChecksumFailureException((Throwable)e);
            }
            try {
                BasicRepositoryConnector.this.fileProcessor.move(tmp, checksumFile);
                return true;
            }
            catch (IOException e) {
                BasicRepositoryConnector.this.logger.debug("Failed to write checksum file " + checksumFile + ": " + e.getMessage(), (Throwable)e);
                return true;
            }
            finally {
                this.delTempFile(tmp);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PeekTaskRunner
    extends TaskRunner {
        public PeekTaskRunner(URI path, TransferTransportListener<?> listener) {
            super(path, listener);
        }

        @Override
        protected void runTask() throws Exception {
            BasicRepositoryConnector.this.transporter.peek(new PeekTask(this.path));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class TaskRunner
    implements Runnable {
        protected final URI path;
        protected final TransferTransportListener<?> listener;

        public TaskRunner(URI path, TransferTransportListener<?> listener) {
            this.path = path;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                this.listener.transferInitiated();
                this.runTask();
                this.listener.transferSucceeded();
            }
            catch (Exception e) {
                this.listener.transferFailed(e, BasicRepositoryConnector.this.transporter.classify((Throwable)e));
            }
        }

        protected abstract void runTask() throws Exception;
    }
}

