/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoTransporterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Component(role=TransporterProvider.class)
public final class DefaultTransporterProvider
implements TransporterProvider,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement(role=TransporterFactory.class)
    private Collection<TransporterFactory> factories = new ArrayList<TransporterFactory>();
    private static final Comparator<TransporterFactory> COMPARATOR = new Comparator<TransporterFactory>(){

        @Override
        public int compare(TransporterFactory o1, TransporterFactory o2) {
            return Float.compare(o2.getPriority(), o1.getPriority());
        }
    };

    public DefaultTransporterProvider() {
    }

    @Inject
    DefaultTransporterProvider(Set<TransporterFactory> transporterFactories, LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
        this.setTransporterFactories(transporterFactories);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.setTransporterFactories(locator.getServices(TransporterFactory.class));
    }

    public DefaultTransporterProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultTransporterProvider addTransporterFactory(TransporterFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("transporter factory has not been specified");
        }
        this.factories.add(factory);
        return this;
    }

    public DefaultTransporterProvider setTransporterFactories(Collection<TransporterFactory> factories) {
        this.factories = factories == null ? new ArrayList<TransporterFactory>() : factories;
        return this;
    }

    DefaultTransporterProvider setFactories(List<TransporterFactory> factories) {
        return this.setTransporterFactories(factories);
    }

    public Transporter newTransporter(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        if (repository == null) {
            throw new IllegalArgumentException("remote repository has not been specified");
        }
        ArrayList<TransporterFactory> factories = new ArrayList<TransporterFactory>(this.factories);
        Collections.sort(factories, COMPARATOR);
        ArrayList<NoTransporterException> errors = new ArrayList<NoTransporterException>();
        for (TransporterFactory factory : factories) {
            try {
                Transporter transporter = factory.newInstance(session, repository);
                if (this.logger.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using transporter ").append(transporter.getClass().getSimpleName());
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    this.logger.debug(buffer.toString());
                }
                return transporter;
            }
            catch (NoTransporterException noTransporterException) {
                errors.add(noTransporterException);
            }
        }
        if (this.logger.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain transporter factory for " + repository;
            for (Exception exception : errors) {
                this.logger.debug(msg, (Throwable)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No transporter factories registered");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" using the registered transporter factories: ");
            ListIterator it = factories.listIterator();
            while (it.hasNext()) {
                TransporterFactory transporterFactory = (TransporterFactory)it.next();
                buffer.append(transporterFactory.getClass().getSimpleName());
                if (!it.hasNext()) continue;
                buffer.append(", ");
            }
        }
        throw new NoTransporterException(repository, buffer.toString(), errors.size() == 1 ? (NoTransporterException)((Object)errors.get(0)) : null);
    }
}

