/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.common.Validator;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.Permissions;

@Deprecated
@Immutable
public final class AclValidator
implements Validator {
    private static final String NO_AUTH_SUBJECT_PATTERN = "It must contain at least one Authorization Subject with the following permission(s): <{0}>!";
    private static final String AUTH_SUBJECT_NOT_PERMITTED_PATTERN = "The Authorization Subject <{0}> must have at least the permission(s): <{1}>!";
    private final AccessControlList acl;
    private final Permissions permissions;
    private boolean validationResult;
    private String reason;

    private AclValidator(AccessControlList accessControlList, Permissions minRequiredPermissions) {
        this.acl = accessControlList;
        this.permissions = minRequiredPermissions;
        this.validationResult = true;
        this.reason = null;
    }

    public static AclValidator newInstance(AccessControlList accessControlList, Permissions minRequiredPermissions) {
        Objects.requireNonNull(accessControlList, "The Access Control List to validate must not be null!");
        return new AclValidator(accessControlList, minRequiredPermissions);
    }

    public boolean isValid() {
        this.checkIfCompletelyEmpty();
        boolean doProceed = this.checkIfSingleEntryIsValid();
        if (doProceed) {
            this.checkIfAnyAuthorizationSubjectsWithRequiredPermissionsDoExist();
        }
        return this.validationResult;
    }

    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    private void checkIfCompletelyEmpty() {
        if (this.acl.isEmpty()) {
            this.reason = MessageFormat.format(NO_AUTH_SUBJECT_PATTERN, this.permissions);
        }
    }

    private boolean checkIfSingleEntryIsValid() {
        boolean result;
        if (!this.validationResult) {
            result = false;
        } else if (1 == this.acl.getSize()) {
            Set<AclEntry> aclEntries = this.acl.getEntriesSet();
            Iterator<AclEntry> aclEntryIterator = aclEntries.iterator();
            AclEntry aclEntry = aclEntryIterator.next();
            if (!aclEntry.containsAll(this.permissions)) {
                this.reason = MessageFormat.format(AUTH_SUBJECT_NOT_PERMITTED_PATTERN, aclEntry.getAuthorizationSubject(), this.permissions);
                this.validationResult = false;
            }
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    private void checkIfAnyAuthorizationSubjectsWithRequiredPermissionsDoExist() {
        Set<AuthorizationSubject> authorizationSubjects = this.acl.getAuthorizedSubjectsFor(this.permissions);
        if (authorizationSubjects.isEmpty()) {
            this.reason = MessageFormat.format(NO_AUTH_SUBJECT_PATTERN, this.permissions);
            this.validationResult = false;
        }
    }
}

