/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.things.Attributes;
import org.eclipse.ditto.model.things.AttributesBuilder;
import org.eclipse.ditto.model.things.ImmutableAttributes;
import org.eclipse.ditto.model.things.ImmutableAttributesBuilder;
import org.eclipse.ditto.model.things.JsonKeyValidator;
import org.eclipse.ditto.model.things.NullAttributes;

@Immutable
public final class AttributesModelFactory {
    private AttributesModelFactory() {
        throw new AssertionError();
    }

    public static Attributes emptyAttributes() {
        return ImmutableAttributes.empty();
    }

    public static Attributes nullAttributes() {
        return NullAttributes.newInstance();
    }

    public static Attributes newAttributes(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"JSON object for initialization");
        if (!jsonObject.isNull()) {
            return ImmutableAttributes.of(jsonObject);
        }
        return AttributesModelFactory.nullAttributes();
    }

    public static Attributes newAttributes(String jsonString) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return AttributesModelFactory.newAttributes(jsonObject);
    }

    public static AttributesBuilder newAttributesBuilder() {
        return ImmutableAttributesBuilder.empty();
    }

    public static AttributesBuilder newAttributesBuilder(JsonObject jsonObject) {
        return ImmutableAttributesBuilder.of(jsonObject);
    }

    public static JsonPointer validateAttributePointer(JsonPointer jsonPointer) {
        return JsonKeyValidator.validate(jsonPointer);
    }

    public static void validateAttributeKeys(JsonObject jsonObject) {
        JsonKeyValidator.validateJsonKeys(jsonObject);
    }
}

