/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.things.FeatureBuilder;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
public interface Feature
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public static FeatureBuilder.FromScratchBuildable newBuilder() {
        return ThingsModelFactory.newFeatureBuilder();
    }

    default public FeatureBuilder.FromCopyBuildable toBuilder() {
        return ThingsModelFactory.newFeatureBuilder(this);
    }

    public String getId();

    public Optional<FeatureDefinition> getDefinition();

    public Feature setDefinition(FeatureDefinition var1);

    public Feature removeDefinition();

    public Optional<FeatureProperties> getProperties();

    public Feature setProperties(FeatureProperties var1);

    public Feature removeProperties();

    default public Optional<JsonValue> getProperty(CharSequence pointer) {
        return this.getProperty(JsonPointer.of((CharSequence)pointer));
    }

    public Optional<JsonValue> getProperty(JsonPointer var1);

    default public Feature setProperty(CharSequence pointer, JsonValue propertyValue) {
        return this.setProperty(JsonPointer.of((CharSequence)pointer), propertyValue);
    }

    default public Feature setProperty(CharSequence pointer, boolean propertyValue) {
        return this.setProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((boolean)propertyValue));
    }

    default public Feature setProperty(CharSequence pointer, int propertyValue) {
        return this.setProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((int)propertyValue));
    }

    default public Feature setProperty(CharSequence pointer, long propertyValue) {
        return this.setProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((long)propertyValue));
    }

    default public Feature setProperty(CharSequence pointer, double propertyValue) {
        return this.setProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((double)propertyValue));
    }

    default public Feature setProperty(CharSequence pointer, String propertyValue) {
        return this.setProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((String)propertyValue));
    }

    public Feature setProperty(JsonPointer var1, JsonValue var2);

    default public Feature removeProperty(CharSequence pointer) {
        return this.removeProperty(JsonPointer.of((CharSequence)pointer));
    }

    public Feature removeProperty(JsonPointer var1);

    public Optional<FeatureProperties> getDesiredProperties();

    public Feature setDesiredProperties(FeatureProperties var1);

    public Feature removeDesiredProperties();

    default public Optional<JsonValue> getDesiredProperty(CharSequence pointer) {
        return this.getDesiredProperty(JsonPointer.of((CharSequence)pointer));
    }

    public Optional<JsonValue> getDesiredProperty(JsonPointer var1);

    default public Feature setDesiredProperty(CharSequence pointer, JsonValue desiredPropertyValue) {
        return this.setDesiredProperty(JsonPointer.of((CharSequence)pointer), desiredPropertyValue);
    }

    default public Feature setDesiredProperty(CharSequence pointer, boolean desiredPropertyValue) {
        return this.setDesiredProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((boolean)desiredPropertyValue));
    }

    default public Feature setDesiredProperty(CharSequence pointer, int desiredPropertyValue) {
        return this.setDesiredProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((int)desiredPropertyValue));
    }

    default public Feature setDesiredProperty(CharSequence pointer, long desiredPropertyValue) {
        return this.setDesiredProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((long)desiredPropertyValue));
    }

    default public Feature setDesiredProperty(CharSequence pointer, double desiredPropertyValue) {
        return this.setDesiredProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((double)desiredPropertyValue));
    }

    default public Feature setDesiredProperty(CharSequence pointer, String desiredPropertyValue) {
        return this.setDesiredProperty(JsonPointer.of((CharSequence)pointer), JsonValue.of((String)desiredPropertyValue));
    }

    public Feature setDesiredProperty(JsonPointer var1, JsonValue var2);

    default public Feature removeDesiredProperty(CharSequence pointer) {
        return this.removeDesiredProperty(JsonPointer.of((CharSequence)pointer));
    }

    public Feature removeDesiredProperty(JsonPointer var1);

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.regularOrSpecial())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> DEFINITION = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"definition", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> PROPERTIES = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"properties", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> DESIRED_PROPERTIES = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"desiredProperties", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }
}

