/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.net.URI;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.things.ThingException;

@JsonParsableException(errorCode="things:feature.definition.empty")
public final class FeatureDefinitionEmptyException
extends DittoRuntimeException
implements ThingException {
    public static final String ERROR_CODE = "things:feature.definition.empty";
    private static final String MESSAGE_TEMPLATE = "Feature Definition must not be empty!";
    private static final String DEFAULT_DESCRIPTION = "A Feature Definition must contain at least one element. It can however also be set to null or deleted completely.";
    private static final long serialVersionUID = -3812521480675928569L;

    public FeatureDefinitionEmptyException() {
        this(DittoHeaders.empty(), MESSAGE_TEMPLATE, DEFAULT_DESCRIPTION, null, null);
    }

    private FeatureDefinitionEmptyException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static FeatureDefinitionEmptyException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (FeatureDefinitionEmptyException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static FeatureDefinitionEmptyException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (FeatureDefinitionEmptyException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<FeatureDefinitionEmptyException> {
        private Builder() {
            this.description(FeatureDefinitionEmptyException.DEFAULT_DESCRIPTION);
            this.message(FeatureDefinitionEmptyException.MESSAGE_TEMPLATE);
        }

        protected FeatureDefinitionEmptyException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new FeatureDefinitionEmptyException(dittoHeaders, message, description, cause, href);
        }
    }
}

