/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.things;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKeyInvalidException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.validation.NoControlCharactersNoSlashesValidator;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.things.Feature;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.ThingsModelFactory;

@Immutable
final class ImmutableFeature
implements Feature {
    private final String featureId;
    @Nullable
    private final FeatureDefinition definition;
    @Nullable
    private final FeatureProperties properties;
    @Nullable
    private final FeatureProperties desiredProperties;

    private ImmutableFeature(String featureId, @Nullable FeatureDefinition definition, @Nullable FeatureProperties properties, @Nullable FeatureProperties desiredProperties) {
        this.featureId = (String)ConditionChecker.checkNotNull((Object)featureId, (String)"ID of the Feature");
        this.definition = definition;
        this.properties = properties;
        this.desiredProperties = desiredProperties;
    }

    public static ImmutableFeature of(String featureId) {
        return ImmutableFeature.of(featureId, null, null);
    }

    public static ImmutableFeature of(String featureId, @Nullable FeatureProperties properties) {
        return ImmutableFeature.of(featureId, null, properties);
    }

    public static ImmutableFeature of(String featureId, @Nullable FeatureDefinition definition, @Nullable FeatureProperties properties) {
        return ImmutableFeature.of(featureId, definition, properties, null);
    }

    public static ImmutableFeature of(CharSequence featureId, @Nullable FeatureDefinition definition, @Nullable FeatureProperties properties, @Nullable FeatureProperties desiredProperties) {
        ConditionChecker.checkNotNull((Object)featureId, (String)"ID of the Feature");
        NoControlCharactersNoSlashesValidator validator = NoControlCharactersNoSlashesValidator.getInstance((CharSequence)featureId);
        if (!validator.isValid()) {
            throw (JsonKeyInvalidException)JsonKeyInvalidException.newBuilderWithDescription((CharSequence)featureId, (String)validator.getReason().orElse(null)).build();
        }
        return new ImmutableFeature(featureId.toString(), definition, properties, desiredProperties);
    }

    @Override
    public String getId() {
        return this.featureId;
    }

    @Override
    public Feature setDefinition(FeatureDefinition featureDefinition) {
        ConditionChecker.checkNotNull((Object)featureDefinition, (String)"definition to be set");
        if (Objects.equals(this.definition, featureDefinition)) {
            return this;
        }
        return ImmutableFeature.of(this.featureId, featureDefinition, this.properties, this.desiredProperties);
    }

    @Override
    public Feature removeDefinition() {
        if (null == this.definition) {
            return this;
        }
        return ImmutableFeature.of(this.featureId, null, this.properties, this.desiredProperties);
    }

    @Override
    public Optional<FeatureProperties> getProperties() {
        return Optional.ofNullable(this.properties);
    }

    @Override
    public Feature setProperties(FeatureProperties properties) {
        ConditionChecker.checkNotNull((Object)properties, (String)"properties to be set");
        if (Objects.equals(this.properties, properties)) {
            return this;
        }
        return ImmutableFeature.of(this.featureId, this.definition, properties, this.desiredProperties);
    }

    @Override
    public Feature removeProperties() {
        if (null == this.properties) {
            return this;
        }
        return ImmutableFeature.of(this.featureId, this.definition, null, this.desiredProperties);
    }

    @Override
    public Optional<JsonValue> getProperty(JsonPointer propertyPath) {
        ConditionChecker.checkNotNull((Object)propertyPath, (String)"JSON path to the property to be retrieved");
        return this.getProperties().flatMap(props -> props.getValue((CharSequence)propertyPath));
    }

    @Override
    public Feature setProperty(JsonPointer propertyPath, JsonValue propertyValue) {
        ConditionChecker.checkNotNull((Object)propertyPath, (String)"JSON path to the property to be set");
        ConditionChecker.checkNotNull((Object)propertyValue, (String)"property value to be set");
        FeatureProperties newFeatureProperties = null == this.properties || this.properties.isEmpty() ? ThingsModelFactory.newFeaturePropertiesBuilder().set((CharSequence)propertyPath, propertyValue).build() : this.properties.setValue((CharSequence)propertyPath, propertyValue);
        return this.setProperties(newFeatureProperties);
    }

    @Override
    public Feature removeProperty(JsonPointer propertyPath) {
        ConditionChecker.checkNotNull((Object)propertyPath, (String)"JSON path to the property to be removed");
        if (null == this.properties || this.properties.isEmpty()) {
            return this;
        }
        return this.setProperties(this.properties.remove((CharSequence)propertyPath));
    }

    @Override
    public Optional<FeatureProperties> getDesiredProperties() {
        return Optional.ofNullable(this.desiredProperties);
    }

    @Override
    public Feature setDesiredProperties(FeatureProperties desiredProperties) {
        ConditionChecker.checkNotNull((Object)desiredProperties, (String)"desired properties to be set");
        if (Objects.equals(this.desiredProperties, desiredProperties)) {
            return this;
        }
        return ImmutableFeature.of(this.featureId, this.definition, this.properties, desiredProperties);
    }

    @Override
    public Feature removeDesiredProperties() {
        if (null == this.desiredProperties) {
            return this;
        }
        return ImmutableFeature.of(this.featureId, this.definition, this.properties, null);
    }

    @Override
    public Optional<JsonValue> getDesiredProperty(JsonPointer desiredPropertyPath) {
        ConditionChecker.checkNotNull((Object)desiredPropertyPath, (String)"JSON path to the desired property to be retrieved");
        return this.getDesiredProperties().flatMap(props -> props.getValue((CharSequence)desiredPropertyPath));
    }

    @Override
    public Feature setDesiredProperty(JsonPointer desiredPropertyPath, JsonValue desiredPropertyValue) {
        ConditionChecker.checkNotNull((Object)desiredPropertyPath, (String)"JSON path to the desired property to be set");
        ConditionChecker.checkNotNull((Object)desiredPropertyValue, (String)"desired property value to be set");
        FeatureProperties newDesiredFeatureProperties = null == this.desiredProperties || this.desiredProperties.isEmpty() ? ThingsModelFactory.newFeaturePropertiesBuilder().set((CharSequence)desiredPropertyPath, desiredPropertyValue).build() : this.desiredProperties.setValue((CharSequence)desiredPropertyPath, desiredPropertyValue);
        return this.setDesiredProperties(newDesiredFeatureProperties);
    }

    @Override
    public Feature removeDesiredProperty(JsonPointer desiredPropertyPath) {
        ConditionChecker.checkNotNull((Object)desiredPropertyPath, (String)"JSON path to the desired property to be removed");
        if (null == this.desiredProperties || this.desiredProperties.isEmpty()) {
            return this;
        }
        return this.setDesiredProperties(this.desiredProperties.remove((CharSequence)desiredPropertyPath));
    }

    @Override
    public Optional<FeatureDefinition> getDefinition() {
        return Optional.ofNullable(this.definition);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder().set(Feature.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        if (null != this.definition) {
            jsonObjectBuilder.set(Feature.JsonFields.DEFINITION, (Object)((JsonArray)this.definition.toJson()), predicate);
        }
        if (null != this.properties) {
            jsonObjectBuilder.set(Feature.JsonFields.PROPERTIES, (Object)this.properties, predicate);
        }
        if (null != this.desiredProperties) {
            jsonObjectBuilder.set(Feature.JsonFields.DESIRED_PROPERTIES, (Object)this.desiredProperties, predicate);
        }
        return jsonObjectBuilder.build();
    }

    public int hashCode() {
        return Objects.hash(this.featureId, this.definition, this.properties, this.desiredProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableFeature other = (ImmutableFeature)o;
        return Objects.equals(this.featureId, other.featureId) && Objects.equals(this.definition, other.definition) && Objects.equals(this.properties, other.properties) && Objects.equals(this.desiredProperties, other.desiredProperties);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [featureId=" + this.featureId + ", definition=" + this.definition + ", properties=" + this.properties + ", desiredProperties=" + this.desiredProperties + "]";
    }
}

